/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.examples.launcher.ItemDescriptor;
import org.eclipse.swt.examples.launcher.ItemTreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherPlugin
extends AbstractUIPlugin {
    private static LauncherPlugin plugin;
    private static ResourceBundle resourceBundle;
    public static final String LAUNCH_ITEMS_POINT_ID = "org.eclipse.swt.examples.launcher.launchItems";
    public static final String LAUNCH_ITEMS_XML_CATEGORY = "category";
    public static final String LAUNCH_ITEMS_XML_ITEM = "item";
    public static final String LAUNCH_ITEMS_XML_ITEM_ICON = "icon";
    public static final String LAUNCH_ITEMS_XML_ITEM_DESCRIPTION = "description";
    public static final String LAUNCH_ITEMS_XML_PROGRAM = "program";
    public static final String LAUNCH_ITEMS_XML_PROGRAM_PLUGIN = "pluginId";
    public static final String LAUNCH_ITEMS_XML_PROGRAM_CLASS = "mainClass";
    public static final String LAUNCH_ITEMS_XML_VIEW = "view";
    public static final String LAUNCH_ITEMS_XML_VIEW_VIEWID = "viewId";
    public static final String LAUNCH_ITEMS_XML_ATTRIB_ID = "id";
    public static final String LAUNCH_ITEMS_XML_ATTRIB_NAME = "name";
    public static final String LAUNCH_ITEMS_XML_ATTRIB_ENABLED = "enabled";
    public static final String LAUNCH_ITEMS_XML_ATTRIB_CATEGORY = "category";
    public static final String LAUNCH_ITEMS_XML_VALUE_TRUE = "true";
    public static final String LAUNCH_ITEMS_XML_VALUE_FALSE = "false";
    static final int liClosedFolder = 0;
    static final int liOpenFolder = 1;
    static final int liGenericExample = 2;
    static final String[] imageLocations;
    static Image[] images;

    static {
        imageLocations = new String[]{"icons/closedFolder.gif", "icons/openFolder.gif", "icons/generic_example.gif"};
    }

    public LauncherPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        LauncherPlugin.freeResources();
        super.stop(context);
    }

    public static LauncherPlugin getDefault() {
        return plugin;
    }

    public static void initResources() {
        if (images == null) {
            images = new Image[imageLocations.length];
            int i = 0;
            while (i < imageLocations.length) {
                LauncherPlugin.images[i] = LauncherPlugin.getImageFromPlugin(plugin.getBundle(), imageLocations[i]);
                if (images[i] == null) {
                    LauncherPlugin.freeResources();
                    LauncherPlugin.logError(LauncherPlugin.getResourceString("error.CouldNotLoadResources"), null);
                    throw new IllegalStateException();
                }
                ++i;
            }
        }
    }

    public static void freeResources() {
        if (images != null) {
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
            images = null;
        }
    }

    public static void logError(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
    }

    public static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(LauncherPlugin.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static ItemTreeNode getLaunchItemTree() {
        String attribId;
        String ceName;
        ItemTreeNode categoryTree = new ItemTreeNode(new ItemDescriptor("<<Root>>", "<<Root>>", null, null, null, null, null, null));
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(LAUNCH_ITEMS_POINT_ID);
        if (configurationElements == null || configurationElements.length == 0) {
            LauncherPlugin.logError(LauncherPlugin.getResourceString("error.CouldNotFindRegisteredExtensions"), null);
            return categoryTree;
        }
        HashMap<String, ItemTreeNode> idMap = new HashMap<String, ItemTreeNode>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String ceName2 = ce.getName();
            String attribId2 = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!idMap.containsKey(attribId2) && ceName2.equalsIgnoreCase("category")) {
                String attribName = LauncherPlugin.getItemName(ce);
                ItemDescriptor theDescriptor = new ItemDescriptor(attribId2, attribName, LauncherPlugin.getItemDescription(ce), null, null, null, null, ce);
                idMap.put(attribId2, new ItemTreeNode(theDescriptor));
            }
            ++n2;
        }
        HashSet<String> tempIdSet = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray2 = configurationElements;
        int n3 = configurationElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n];
            ceName = ce.getName();
            attribId = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!tempIdSet.contains(attribId) && ceName.equalsIgnoreCase("category")) {
                ItemTreeNode theNode = (ItemTreeNode)idMap.get(attribId);
                LauncherPlugin.addItemByCategory(ce, categoryTree, theNode, idMap);
                tempIdSet.add(attribId);
            }
            ++n;
        }
        iConfigurationElementArray2 = configurationElements;
        n3 = configurationElements.length;
        n = 0;
        while (n < n3) {
            ItemDescriptor theDescriptor;
            String enabled;
            IConfigurationElement ce = iConfigurationElementArray2[n];
            ceName = ce.getName();
            attribId = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ID, null);
            if (!idMap.containsKey(attribId) && !ceName.equalsIgnoreCase("category") && ceName.equalsIgnoreCase(LAUNCH_ITEMS_XML_ITEM) && !(enabled = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_ENABLED, LAUNCH_ITEMS_XML_VALUE_TRUE)).equalsIgnoreCase(LAUNCH_ITEMS_XML_VALUE_FALSE) && (theDescriptor = LauncherPlugin.createItemDescriptor(ce, attribId)) != null) {
                ItemTreeNode theNode = new ItemTreeNode(theDescriptor);
                LauncherPlugin.addItemByCategory(ce, categoryTree, theNode, idMap);
                idMap.put(attribId, theNode);
            }
            ++n;
        }
        return categoryTree;
    }

    private static void addItemByCategory(IConfigurationElement ce, ItemTreeNode root, ItemTreeNode theNode, HashMap<String, ItemTreeNode> idMap) {
        String attribCategory = LauncherPlugin.getItemAttribute(ce, "category", null);
        ItemTreeNode parentNode = null;
        if (attribCategory != null) {
            parentNode = idMap.get(attribCategory);
        }
        if (parentNode == null) {
            parentNode = root;
        }
        parentNode.addSortedNode(theNode);
    }

    private static ItemDescriptor createItemDescriptor(IConfigurationElement ce, String attribId) {
        String attribName = LauncherPlugin.getItemName(ce);
        Image attribIcon = LauncherPlugin.getItemIcon(ce);
        String attribDescription = LauncherPlugin.getItemDescription(ce);
        IConfigurationElement viewCE = LauncherPlugin.getItemElement(ce, LAUNCH_ITEMS_XML_VIEW);
        if (viewCE != null) {
            String attribView = LauncherPlugin.getItemAttribute(viewCE, LAUNCH_ITEMS_XML_VIEW_VIEWID, null);
            if (attribView == null) {
                LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteViewLaunchItem", new Object[]{attribId}), null);
                return null;
            }
            return new ItemDescriptor(attribId, attribName, attribDescription, attribIcon, attribView, null, null, viewCE);
        }
        IConfigurationElement programCE = LauncherPlugin.getItemElement(ce, LAUNCH_ITEMS_XML_PROGRAM);
        if (programCE != null) {
            String attribPluginId = LauncherPlugin.getItemAttribute(programCE, LAUNCH_ITEMS_XML_PROGRAM_PLUGIN, null);
            String attribClass = LauncherPlugin.getItemAttribute(programCE, LAUNCH_ITEMS_XML_PROGRAM_CLASS, null);
            if (attribClass == null || attribPluginId == null) {
                LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteProgramLaunchItem", new Object[]{attribId}), null);
                return null;
            }
            return new ItemDescriptor(attribId, attribName, attribDescription, attribIcon, null, attribClass, attribPluginId, programCE);
        }
        LauncherPlugin.logError(LauncherPlugin.getResourceString("error.IncompleteLaunchItem", new Object[]{attribId}), null);
        return null;
    }

    private static IConfigurationElement getItemElement(IConfigurationElement ce, String element) {
        IConfigurationElement[] elementCEs = ce.getChildren(element);
        return elementCEs != null && elementCEs.length != 0 ? elementCEs[0] : null;
    }

    private static String getItemAttribute(IConfigurationElement ce, String attribute, String defaultValue) {
        String value = ce.getAttribute(attribute);
        return value != null ? value : defaultValue;
    }

    private static String getItemDescription(IConfigurationElement ce) {
        String description = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ITEM_DESCRIPTION, "");
        return description.length() == 0 ? null : description;
    }

    private static String getItemName(IConfigurationElement ce) {
        return LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ATTRIB_NAME, LauncherPlugin.getResourceString("launchitem.Missing.name"));
    }

    private static Image getItemIcon(IConfigurationElement ce) {
        String symbolicName;
        Bundle bundle;
        Image icon;
        String iconPath = LauncherPlugin.getItemAttribute(ce, LAUNCH_ITEMS_XML_ITEM_ICON, "");
        if (iconPath.length() != 0 && (icon = LauncherPlugin.getImageFromPlugin(bundle = Platform.getBundle((String)(symbolicName = ce.getDeclaringExtension().getContributor().getName())), iconPath)) != null) {
            Image[] newImages = new Image[images.length + 1];
            System.arraycopy(images, 0, newImages, 0, images.length);
            newImages[LauncherPlugin.images.length] = icon;
            images = newImages;
            return icon;
        }
        return images[2];
    }

    /*
     * Loose catch block
     */
    private static Image getImageFromPlugin(Bundle bundle, String iconPath) {
        Image image;
        InputStream is = null;
        URL installUrl = bundle.getEntry("/");
        URL url = new URL(installUrl, iconPath);
        is = url.openConnection().getInputStream();
        ImageData source = new ImageData(is);
        ImageData mask = source.getTransparencyMask();
        Image image2 = image = new Image(null, source, mask);
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return image2;
        catch (Throwable throwable) {
            try {}
            catch (Throwable throwable2) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable2;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

