/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import java.lang.reflect.Method;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.examples.launcher.ItemDescriptor;
import org.eclipse.swt.examples.launcher.ItemTreeNode;
import org.eclipse.swt.examples.launcher.LauncherPlugin;
import org.eclipse.swt.examples.launcher.SplitLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class LauncherView
extends ViewPart {
    private Shell workbenchShell;
    private Tree launchTree;
    private Text descriptionText;
    private Button runButton;

    public LauncherView() {
        LauncherPlugin.initResources();
    }

    public void createPartControl(Composite parent) {
        this.workbenchShell = this.getSite().getShell();
        parent.setLayout((Layout)new SplitLayout());
        Group launchGroup = new Group(parent, 0);
        launchGroup.setText(LauncherPlugin.getResourceString("view.launchGroup.text"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        launchGroup.setLayout((Layout)gridLayout);
        this.launchTree = new Tree((Composite)launchGroup, 2816);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.launchTree.setLayoutData((Object)gridData);
        this.launchTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ItemDescriptor item = LauncherView.this.getSelectedItem();
                LauncherView.this.setDescriptionByItem(item);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ItemDescriptor item = LauncherView.this.getSelectedItem();
                LauncherView.this.setDescriptionByItem(item);
                if (item.getMainType() == null && item.getView() == null) {
                    TreeItem treeItem = (TreeItem)event.item;
                    boolean expanded = treeItem.getExpanded();
                    if (treeItem != null) {
                        treeItem.setExpanded(!expanded);
                    }
                    treeItem.setImage(LauncherPlugin.images[expanded ? 0 : 1]);
                } else {
                    LauncherView.this.launchItem(LauncherView.this.getSelectedItem());
                }
            }
        });
        this.launchTree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                item.setImage(LauncherPlugin.images[0]);
            }

            public void treeExpanded(TreeEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                item.setImage(LauncherPlugin.images[1]);
            }
        });
        this.runButton = new Button((Composite)launchGroup, 8);
        this.runButton.setText(LauncherPlugin.getResourceString("view.launchButton.text"));
        this.runButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LauncherView.this.launchItem(LauncherView.this.getSelectedItem());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Group descriptionGroup = new Group(parent, 0);
        descriptionGroup.setText(LauncherPlugin.getResourceString("view.descriptionGroup.text"));
        descriptionGroup.setLayout((Layout)new FillLayout());
        this.descriptionText = new Text((Composite)descriptionGroup, 2634);
        this.setDescriptionByItem(null);
        this.setItemDescriptors(LauncherPlugin.getLaunchItemTree());
    }

    public void setFocus() {
        this.launchTree.setFocus();
        this.runButton.getShell().setDefaultButton(this.runButton);
    }

    public void dispose() {
        this.workbenchShell = null;
        this.launchTree = null;
        this.descriptionText = null;
        this.runButton = null;
        super.dispose();
    }

    public void setItemDescriptors(final ItemTreeNode newRoot) {
        if (this.workbenchShell == null) {
            return;
        }
        this.workbenchShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (LauncherView.this.launchTree == null || LauncherView.this.launchTree.isDisposed()) {
                    return;
                }
                LauncherView.this.launchTree.removeAll();
                ItemTreeNode node = newRoot.getFirstChild();
                while (node != null) {
                    this.doNode(node, new TreeItem(LauncherView.this.launchTree, 0));
                    node = node.getNextSibling();
                }
            }

            private void addGroup(TreeItem parent, ItemTreeNode node) {
                while (node != null) {
                    this.doNode(node, new TreeItem(parent, 0));
                    node = node.getNextSibling();
                }
            }

            private void doNode(ItemTreeNode node, TreeItem treeItem) {
                ItemDescriptor item = node.getDescriptor();
                treeItem.setText(item.getName());
                treeItem.setData((Object)item);
                if (node.getDescriptor().isFolder()) {
                    treeItem.setExpanded(false);
                    treeItem.setImage(LauncherPlugin.images[0]);
                } else {
                    treeItem.setImage(node.getDescriptor().getIcon());
                }
                this.addGroup(treeItem, node.getFirstChild());
            }
        });
    }

    private void launchItem(ItemDescriptor itemDescriptor) {
        String pluginViewId = itemDescriptor.getView();
        if (pluginViewId != null) {
            LauncherView workbenchPart = this;
            IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
            IWorkbenchPage workbenchPage = workbenchPartSite.getPage();
            try {
                workbenchPage.showView(pluginViewId);
            }
            catch (PartInitException e) {
                LauncherPlugin.logError(LauncherPlugin.getResourceString("run.error.Invocation"), e);
            }
            return;
        }
        if (this.workbenchShell == null) {
            return;
        }
        try {
            Object instance = itemDescriptor.createItemInstance();
            if (instance != null) {
                Display display = this.workbenchShell.getDisplay();
                Method openMethod = instance.getClass().getDeclaredMethod("open", Display.class);
                openMethod.invoke(instance, display);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LauncherPlugin.logError(LauncherPlugin.getResourceString("run.error.DoesNotImplementMethod"), null);
        }
        catch (Exception e) {
            LauncherPlugin.logError(LauncherPlugin.getResourceString("run.error.CouldNotInstantiateClass"), e);
        }
    }

    private ItemDescriptor getSelectedItem() {
        TreeItem[] selections = this.launchTree.getSelection();
        if (selections.length == 0) {
            return null;
        }
        ItemDescriptor itemDescriptor = (ItemDescriptor)selections[0].getData();
        return itemDescriptor;
    }

    private void setDescriptionByItem(ItemDescriptor itemDescriptor) {
        String description;
        if (itemDescriptor == null) {
            description = LauncherPlugin.getResourceString("launchitem.Null.description");
            if (this.runButton != null) {
                this.runButton.setEnabled(false);
            }
        } else {
            description = itemDescriptor.getDescription();
            if (description == null) {
                description = LauncherPlugin.getResourceString("launchitem.Missing.description");
            }
            if (this.runButton != null) {
                this.runButton.setEnabled(itemDescriptor.getView() != null || itemDescriptor.getMainType() != null);
            }
        }
        this.descriptionText.setText(description);
    }
}

