/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class XMLNode
extends DocumentRangeNode
implements ITypedElement {
    private String fValue;
    private String fName;
    private String fSignature;
    private String fOrigId;
    private XMLNode parent;
    private String fXMLType;
    private boolean fUsesIDMAP;
    private boolean fOrderedChild;
    public int bodies;

    public XMLNode(String XMLType, String id, String value, String signature, IDocument doc, int start, int length) {
        super(0, id, doc, start, length);
        this.fXMLType = XMLType;
        this.fValue = value;
        this.fSignature = signature;
        this.fOrigId = id;
        this.bodies = 0;
        this.fUsesIDMAP = false;
        this.fOrderedChild = false;
    }

    void setValue(String value) {
        this.fValue = value;
    }

    String getValue() {
        return this.fValue;
    }

    public String getName() {
        if (this.fName != null) {
            return this.fName;
        }
        return this.getId();
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getType() {
        return "txt";
    }

    public void setIsOrderedChild(boolean isOrderedChild) {
        this.fOrderedChild = isOrderedChild;
    }

    public Image getImage() {
        if (this.fOrderedChild) {
            return CompareUI.getImage((String)"xml_element_ordered");
        }
        return CompareUI.getImage((String)("xml_" + this.getXMLType()));
    }

    public void setParent(XMLNode parent0) {
        this.parent = parent0;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    String getXMLType() {
        return this.fXMLType;
    }

    String getSignature() {
        return this.fSignature;
    }

    void setOrigId(String id) {
        this.fOrigId = id;
    }

    public String getOrigId() {
        return this.fOrigId;
    }

    public void setUsesIDMAP(boolean b) {
        this.fUsesIDMAP = b;
    }

    public boolean usesIDMAP() {
        return this.fUsesIDMAP;
    }

    public boolean testEquals(Object obj) {
        if (obj instanceof XMLNode) {
            XMLNode n = (XMLNode)((Object)obj);
            return this.fValue.equals(n.getValue()) && this.fSignature.equals(n.getSignature()) && this.fXMLType.equals(n.getXMLType()) && this.fUsesIDMAP == n.usesIDMAP();
        }
        return false;
    }

    public boolean subtreeEquals(Object obj) {
        if (!this.testEquals(obj)) {
            return false;
        }
        if (obj instanceof XMLNode) {
            XMLNode n = (XMLNode)((Object)obj);
            if (this.getXMLType().equals("attribute") && n.getXMLType().equals("attribute")) {
                return true;
            }
            Object[] children = this.getChildren();
            Object[] n_children = n.getChildren();
            if (!(children != null && children.length > 0 || n_children != null && n_children.length > 0)) {
                return true;
            }
            if (children == null || children.length <= 0 || n_children == null || n_children.length <= 0 || children.length != n_children.length) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                if (!((XMLNode)((Object)children[i])).subtreeEquals(n_children[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

