/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.StreamUtil;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;

public class FileSystemOperations {
    private FileSystemProvider provider;

    FileSystemOperations(FileSystemProvider provider) {
        this.provider = provider;
    }

    public void get(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("GetAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 30));
            this.internalGet(resources, depth, overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(progress, 70));
        }
        finally {
            progress.done();
        }
    }

    public void get(ResourceTraversal[] traversals, boolean overrideOutgoing, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.get(traversal.getResources(), traversal.getDepth(), overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void checkout(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        try {
            try {
                progress = Policy.monitorFor(progress);
                progress.beginTask(Policy.bind("FileSystemSimpleAccessOperations.1"), resources.length);
                int i = 0;
                while (i < resources.length) {
                    Policy.checkCanceled(progress);
                    resources[i].accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1) {
                                resource.setReadOnly(false);
                            }
                            return true;
                        }
                    }, depth, false);
                    progress.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkin(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 30));
            this.internalPut(resources, depth, overrideIncoming, (IProgressMonitor)new SubProgressMonitor(progress, 70));
        }
        finally {
            progress.done();
        }
    }

    public void checkin(ResourceTraversal[] traversals, boolean overrideIncoming, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.checkin(traversal.getResources(), traversal.getDepth(), overrideIncoming, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isCheckedOut(IResource resource) {
        if (resource.getType() != 1) {
            return true;
        }
        return !resource.isReadOnly();
    }

    private FileSystemResourceVariant getResourceVariant(IResource resource) {
        return (FileSystemResourceVariant)this.provider.getResourceVariant(resource);
    }

    private void internalGet(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        progress.beginTask(Policy.bind("GetAction.working"), -1);
        int i = 0;
        while (i < resources.length) {
            Policy.checkCanceled(progress);
            if (resources[i].getType() == 1) {
                this.internalGet((IFile)resources[i], overrideOutgoing, progress);
            } else if (depth != 0) {
                this.internalGet((IContainer)resources[i], depth, overrideOutgoing, progress);
            }
            progress.worked(1);
            ++i;
        }
    }

    private void internalGet(IContainer container, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            ArrayList<IFolder> toDelete = new ArrayList<IFolder>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                FileSystemResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    folder.create(false, true, progress);
                    synchronizer.setBaseBytes((IResource)folder, remote.asBytes());
                } else if (folder.exists() && remote == null) {
                    toDelete.add(folder);
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalGet(children, depth == 2 ? 2 : 0, overrideOutgoing, progress);
            }
            Iterator iter = toDelete.iterator();
            while (iter.hasNext()) {
                IFolder folder = (IFolder)iter.next();
                if (folder.members().length != 0) continue;
                folder.delete(false, true, progress);
                synchronizer.flush((IResource)folder, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    private void internalGet(IFile localFile, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getResourceVariant((IResource)localFile, baseBytes);
        if (!synchronizer.hasSyncBytes((IResource)localFile) || this.isLocallyModified(localFile) && !overrideOutgoing) {
            return;
        }
        if (base != null && remote == null) {
            try {
                localFile.delete(false, true, progress);
                synchronizer.flush((IResource)localFile, 0);
                return;
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        if (!synchronizer.isLocallyModified((IResource)localFile) && base != null && remote != null && comparator.compare(base, (IResourceVariant)remote)) {
            return;
        }
        try {
            InputStream source = null;
            try {
                source = remote.getContents();
                if (localFile.exists()) {
                    localFile.setContents(source, false, false, progress);
                } else {
                    localFile.create(source, false, progress);
                }
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
            localFile.setReadOnly(true);
            synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
        }
        catch (IOException e) {
            throw FileSystemPlugin.wrapException(e);
        }
        catch (CoreException e) {
            throw FileSystemPlugin.wrapException(e);
        }
    }

    private void internalPut(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        progress = Policy.monitorFor(progress);
        progress.beginTask(Policy.bind("PutAction.working"), -1);
        int i = 0;
        while (i < resources.length) {
            Policy.checkCanceled(progress);
            if (resources[i].getType() == 1) {
                this.internalPut((IFile)resources[i], overrideIncoming, progress);
            } else if (depth > 0) {
                this.internalPut((IContainer)resources[i], depth, overrideIncoming, progress);
            }
            progress.worked(1);
            ++i;
        }
        progress.done();
    }

    private boolean internalPut(IFile localFile, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getResourceVariant((IResource)localFile, baseBytes);
        if (base == null && remote != null && !overrideIncoming) {
            return false;
        }
        if (base != null && remote == null) {
            if (!localFile.exists()) {
                synchronizer.flush((IResource)localFile, 0);
            } else if (!overrideIncoming) {
                return false;
            }
        } else if (base != null && remote != null) {
            boolean same = comparator.compare(base, (IResourceVariant)remote);
            if (!this.isLocallyModified(localFile) && same) {
                return true;
            }
            if (!same && !overrideIncoming) {
                return false;
            }
        }
        File diskFile = this.provider.getFile((IResource)localFile);
        if (!localFile.exists()) {
            diskFile.delete();
            synchronizer.flush((IResource)localFile, 0);
        } else {
            try {
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    if (!diskFile.getParentFile().exists()) {
                        diskFile.getParentFile().mkdirs();
                    }
                    in = localFile.getContents();
                    out = new FileOutputStream(diskFile);
                    StreamUtil.pipe(in, out, diskFile.length(), progress, diskFile.getName());
                    localFile.setReadOnly(true);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                remote = this.getResourceVariant((IResource)localFile);
                synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
            }
            catch (IOException e) {
                throw FileSystemPlugin.wrapException(e);
            }
            catch (CoreException e) {
                throw FileSystemPlugin.wrapException(e);
            }
        }
        return true;
    }

    private boolean isLocallyModified(IFile localFile) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        if (!localFile.exists()) {
            return synchronizer.getBaseBytes((IResource)localFile) != null;
        }
        return synchronizer.isLocallyModified((IResource)localFile);
    }

    private void internalPut(IContainer container, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            ArrayList<File> toDelete = new ArrayList<File>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                File diskFile = this.provider.getFile((IResource)container);
                FileSystemResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    toDelete.add(diskFile);
                } else if (folder.exists() && remote == null) {
                    diskFile.mkdir();
                    synchronizer.setBaseBytes((IResource)folder, this.provider.getResourceVariant((IResource)folder).asBytes());
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalPut(children, depth == 2 ? 2 : 0, overrideIncoming, progress);
            }
            Iterator iter = toDelete.iterator();
            while (iter.hasNext()) {
                File diskFile = (File)iter.next();
                if (diskFile.listFiles().length != 0) continue;
                diskFile.delete();
                synchronizer.flush((IResource)container, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

