/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.ui.FileSystemMainPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;

public class ConfigurationWizard
extends Wizard
implements IConfigurationWizard,
IAdaptable {
    IProject[] projects;
    FileSystemMainPage mainPage;
    static /* synthetic */ Class class$0;

    public ConfigurationWizard() {
        IDialogSettings workbenchSettings = FileSystemPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ProviderExamplesWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("ProviderExamplesWizard");
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IProject project) {
        this.setProjects(new IProject[]{project});
    }

    public void addPages() {
        this.mainPage = new FileSystemMainPage("FileSystemMainPage", Policy.bind("ConfigurationWizard.name"), Policy.bind("ConfigurationWizard.description"), null);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.mainPage.finish(null);
        try {
            if (this.projects.length == 1) {
                RepositoryProvider.map((IProject)this.projects[0], (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
                FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)this.projects[0]);
                provider.setTargetLocation(this.mainPage.getLocation());
            } else {
                int i = 0;
                while (i < this.projects.length) {
                    IProject project = this.projects[i];
                    RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
                    FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)project);
                    String path = new Path(this.mainPage.getLocation()).append(project.getName()).toOSString();
                    provider.setTargetLocation(path);
                    ++i;
                }
            }
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("ConfigurationWizard.errorMapping"), (String)Policy.bind("ConfigurationWizard.error"), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.ui.IConfigurationWizardExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IConfigurationWizardExtension(){

                public void init(IWorkbench workbench, IProject[] projects) {
                    ConfigurationWizard.this.setProjects(projects);
                }
            };
        }
        return null;
    }

    void setProjects(IProject[] projects) {
        this.projects = projects;
    }
}

