/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemMergeContext;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.examples.filesystem.ui.FileSystemOperation;
import org.eclipse.team.examples.filesystem.ui.ModelPutAction;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;

public class FileSystemSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String ID = "org.eclipse.team.examples.filesystem.participant";
    public static final String VIEWER_ID = "org.eclipse.team.examples.filesystem.syncViewer";
    public static final String CONTEXT_MENU_PUT_GROUP_1 = "put";
    public static final String CONTEXT_MENU_OVERWRITE_GROUP_1 = "overwrite";

    public FileSystemSynchronizeParticipant() {
    }

    public FileSystemSynchronizeParticipant(SynchronizationContext context) {
        super(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            TeamUIPlugin.log((CoreException)e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        configuration.addLabelDecorator((ILabelDecorator)new FileSystemParticipantLabelDecorator());
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new FileSystemParticipantActionGroup();
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) {
        return new FileSystemMergeContext(manager);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return FileSystemOperation.createScopeManager(this.getName(), mappings);
    }

    public class FileSystemParticipantActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_PUT_GROUP_1, (IAction)new ModelPutAction("Put", configuration));
        }

        protected void configureMergeAction(String mergeActionId, Action action) {
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                action.setText("Get");
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                action.setText("Ignore Remote");
            } else {
                super.configureMergeAction(mergeActionId, action);
            }
        }

        protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
            IContributionItem group = null;
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                group = manager.find("merge");
            } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                group = manager.find(FileSystemSynchronizeParticipant.CONTEXT_MENU_OVERWRITE_GROUP_1);
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                group = manager.find("other");
            } else {
                super.addToContextMenu(mergeActionId, action, manager);
                return;
            }
            if (group != null) {
                manager.appendToGroup(group.getId(), (IAction)action);
            } else {
                manager.add((IAction)action);
            }
        }
    }

    public class FileSystemParticipantLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            try {
                SyncInfo info;
                IResourceVariant variant;
                IResource resource;
                if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && resource.getType() == 1 && (variant = (info = FileSystemSubscriber.getInstance().getSyncInfo(resource)).getRemote()) != null) {
                    return String.valueOf(text) + " (" + variant.getContentIdentifier() + ")";
                }
            }
            catch (TeamException e) {
                FileSystemPlugin.log((CoreException)((Object)e));
            }
            return null;
        }
    }
}

