/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.ui.NonSyncMergePart;
import org.eclipse.team.internal.ui.mapping.SynchronizationResourceMappingContext;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.synchronize.ModelMergeOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;

public class NonSyncModelMergePage
extends Page {
    IMergeContext context;
    TreeViewer viewer;
    List mappings;

    public NonSyncModelMergePage(IMergeContext context) {
        this.context = context;
    }

    public void computeMappings(IProgressMonitor monitor) {
        IModelProviderDescriptor[] descriptors = ModelProvider.getModelProviderDescriptors();
        this.mappings = new ArrayList();
        int i = 0;
        while (i < descriptors.length) {
            IModelProviderDescriptor descriptor = descriptors[i];
            try {
                IResource[] resources = descriptor.getMatchingResources(this.getOutOfSyncFiles());
                if (resources.length > 0) {
                    ModelProvider provider = descriptor.getModelProvider();
                    ResourceMapping[] mappings = provider.getMappings(resources, (ResourceMappingContext)new SynchronizationResourceMappingContext((ISynchronizationContext)this.context), monitor);
                    this.mappings.addAll(Arrays.asList(mappings));
                }
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
            ++i;
        }
    }

    private IResource[] getOutOfSyncFiles() {
        IDiff[] diffs = this.getContext().getDiffTree().getDiffs((IResource)ResourcesPlugin.getWorkspace().getRoot(), 2);
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource.getType() == 1) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public IMergeContext getContext() {
        return this.context;
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new PageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PageLabelProvider());
        this.viewer.setSorter((ViewerSorter)new PageSorter());
        this.hookContextMenu(this.viewer);
        this.viewer.setInput((Object)this.context);
    }

    private void hookContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NonSyncModelMergePage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Action markAsMerged = new Action("Mark as Merged"){

            public void run() {
                try {
                    IStructuredSelection selection = (IStructuredSelection)NonSyncModelMergePage.this.viewer.getSelection();
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(this, selection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.this$1 = var1_1;
                            this.val$selection = iStructuredSelection;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            IDiff[] diffs = 2.access$0(this.this$1).getSelectedDiffs(this.val$selection, monitor);
                            if (!2.access$0(this.this$1).checkForModelOverlap(diffs, monitor)) {
                                return;
                            }
                            try {
                                2.access$0(this.this$1).context.markAsMerged(diffs, false, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    FileSystemPlugin.log((IStatus)new Status(4, "org.eclipse.team.examples.filesystem", 0, e.getTargetException().getMessage(), e.getTargetException()));
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ NonSyncModelMergePage access$0(2 var0) {
                return var0.NonSyncModelMergePage.this;
            }
        };
        manager.add((IAction)markAsMerged);
    }

    protected IDiff[] getSelectedDiffs(IStructuredSelection selection, IProgressMonitor monitor) {
        Object[] elements = selection.toArray();
        return this.getDiffs(elements, monitor);
    }

    private IDiff[] getDiffs(Object[] elements, IProgressMonitor monitor) {
        HashSet<IDiff> result = new HashSet<IDiff>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            try {
                if (element instanceof ResourceMapping) {
                    ResourceMapping mapping = (ResourceMapping)element;
                    ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)new SynchronizationResourceMappingContext((ISynchronizationContext)this.context), monitor);
                    result.addAll(Arrays.asList(this.context.getDiffTree().getDiffs(traversals)));
                }
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
            ++i;
        }
        return result.toArray(new IDiff[result.size()]);
    }

    protected boolean checkForModelOverlap(IDiff[] diffs, IProgressMonitor monitor) {
        return true;
    }

    public Control getControl() {
        if (this.viewer != null) {
            return this.viewer.getControl();
        }
        return null;
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public ISelectionProvider getViewer() {
        return this.viewer;
    }

    class PageContentProvider
    implements ITreeContentProvider {
        PageContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IMergeContext) {
                if (NonSyncModelMergePage.this.mappings == null) {
                    NonSyncModelMergePage.this.computeMappings((IProgressMonitor)new NullProgressMonitor());
                }
                return NonSyncModelMergePage.this.mappings.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ResourceMapping) {
                return NonSyncModelMergePage.this.context;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IMergeContext;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PageLabelProvider
    extends LabelProvider {
        PageLabelProvider() {
        }

        public String getText(Object element) {
            ResourceMapping mapping;
            ISynchronizationCompareAdapter adapter;
            if (element instanceof ResourceMapping && (adapter = NonSyncMergePart.getCompareAdapter(mapping = (ResourceMapping)element)) != null) {
                return String.valueOf(adapter.getPathString(mapping)) + "(" + mapping.getModelProvider().getDescriptor().getLabel() + ")";
            }
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                ci.getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ResourceMapping mapping;
            ISynchronizationCompareAdapter adapter;
            ICompareInput input;
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                ci.getImage();
            }
            if (element instanceof ResourceMapping && (input = (adapter = NonSyncMergePart.getCompareAdapter(mapping = (ResourceMapping)element)).asCompareInput((ISynchronizationContext)NonSyncModelMergePage.this.context, mapping.getModelObject())) != null) {
                return input.getImage();
            }
            return super.getImage(element);
        }
    }

    class PageSorter
    extends ViewerSorter {
        PageSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ResourceMapping && e2 instanceof ResourceMapping) {
                ResourceMapping m1 = (ResourceMapping)e1;
                ResourceMapping m2 = (ResourceMapping)e2;
                if (m1.getModelProvider() == m2.getModelProvider()) {
                    return this.getLabel(m1).compareTo(this.getLabel(m2));
                }
                return this.compare(m1, m2);
            }
            return super.compare(viewer, e1, e2);
        }

        private int compare(ResourceMapping m1, ResourceMapping m2) {
            ModelProvider[] sorted = ModelMergeOperation.sortByExtension((ModelProvider[])new ModelProvider[]{m1.getModelProvider(), m2.getModelProvider()});
            return sorted[0] == m1.getModelProvider() ? -1 : 1;
        }

        private String getLabel(ResourceMapping mapping) {
            ISynchronizationCompareAdapter adapter = NonSyncMergePart.getCompareAdapter(mapping);
            if (adapter != null) {
                return adapter.getPathString(mapping);
            }
            return "";
        }
    }
}

