/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.ui.FileSystemRevisionEditorInput;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressService;

public class OpenFileSystemRevisionAction
extends BaseSelectionListenerAction {
    private IStructuredSelection selection;
    HistoryPage page;
    static /* synthetic */ Class class$0;

    public OpenFileSystemRevisionAction(String text) {
        super(text);
    }

    public void run() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        int i = 0;
        while (i < objArray.length) {
            Object tempRevision = objArray[i];
            final IFileRevision revision = (IFileRevision)tempRevision;
            if (revision == null || !revision.exists()) {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)"Deleted Revision", (String)"Can't open a deleted revision");
            } else {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            IStorage file = revision.getStorage(monitor);
                            String id = OpenFileSystemRevisionAction.this.getEditorID(file.getName(), file.getContents());
                            if (file instanceof IFile) {
                                IDE.openEditor((IWorkbenchPage)OpenFileSystemRevisionAction.this.page.getSite().getPage(), (IFile)((IFile)file));
                            } else {
                                FileSystemRevisionEditorInput fileRevEditorInput = new FileSystemRevisionEditorInput(revision);
                                if (!OpenFileSystemRevisionAction.this.editorAlreadyOpenOnContents(fileRevEditorInput)) {
                                    OpenFileSystemRevisionAction.this.page.getSite().getPage().openEditor((IEditorInput)fileRevEditorInput, id);
                                }
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.run(false, false, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = FileSystemPlugin.getPlugin().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {}
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return this.shouldShow();
    }

    public void setPage(HistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean editorAlreadyOpenOnContents(FileSystemRevisionEditorInput input) {
        IEditorReference[] editorRefs = this.page.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof FileSystemRevisionEditorInput) {
                IFileRevision editorRevision;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.core.history.IFileRevision");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IFileRevision inputRevision = (IFileRevision)input.getAdapter(clazz);
                IEditorInput iEditorInput = part.getEditorInput();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (inputRevision.equals(editorRevision = (IFileRevision)iEditorInput.getAdapter((Class)clazz2))) {
                    this.page.getSite().getPage().activate((IWorkbenchPart)part);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

