/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.localhistory;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.examples.localhistory.LocalHistorySubscriber;
import org.eclipse.team.examples.localhistory.LocalHistoryVariant;
import org.eclipse.team.examples.localhistory.RevertAllOperation;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class LocalHistoryParticipant
extends SubscriberParticipant {
    public static final String ID = "org.eclipse.team.synchronize.example";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_1";
    static /* synthetic */ Class class$0;

    public LocalHistoryParticipant() {
        this.setSubscriber(new LocalHistorySubscriber());
    }

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            this.setInitializationData(descriptor);
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
        catch (CoreException coreException) {}
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.addActionContribution((SynchronizePageActionGroup)new LocalHistoryActionContribution());
        configuration.addLabelDecorator((ILabelDecorator)new LocalHistoryDecorator());
    }

    protected static SyncInfo getSyncInfo(ISynchronizeModelElement element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (SyncInfo)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void prepareCompareInput(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) throws TeamException {
        super.prepareCompareInput(element, config, monitor);
        SyncInfo sync = LocalHistoryParticipant.getSyncInfo(element);
        IResourceVariant remote = sync.getRemote();
        if (remote != null) {
            config.setRightLabel(NLS.bind((String)"Local History ({0})", (Object[])new String[]{remote.getContentIdentifier()}));
        } else {
            config.setRightLabel("Local History");
        }
    }

    private class LocalHistoryActionContribution
    extends SynchronizePageActionGroup {
        private LocalHistoryActionContribution() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", LocalHistoryParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new SynchronizeModelAction(this, "Revert to latest in local history", configuration){
                final /* synthetic */ LocalHistoryActionContribution this$1;
                {
                    this.this$1 = localHistoryActionContribution;
                }

                protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                    return new RevertAllOperation(configuration, elements);
                }
            });
        }
    }

    private class LocalHistoryDecorator
    extends LabelProvider
    implements ILabelDecorator {
        private LocalHistoryDecorator() {
        }

        public String decorateText(String text, Object element) {
            ISynchronizeModelElement node;
            if (element instanceof ISynchronizeModelElement && (node = (ISynchronizeModelElement)element) instanceof IAdaptable) {
                SyncInfo info;
                IAdaptable iAdaptable = (IAdaptable)node;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((info = (SyncInfo)iAdaptable.getAdapter((Class)clazz)) != null) {
                    LocalHistoryVariant state = (LocalHistoryVariant)info.getRemote();
                    return String.valueOf(text) + " (" + state.getContentIdentifier() + ")";
                }
            }
            return text;
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }
    }
}

