/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.examples.model.ModelFolder;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.ModelResource;

public abstract class ModelContainer
extends ModelResource {
    protected ModelContainer(IContainer container) {
        super((IResource)container);
    }

    protected IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    public ModelObject[] getChildren() throws CoreException {
        IResource[] members = this.getContainer().members();
        ArrayList<ModelResource> result = new ArrayList<ModelResource>();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource instanceof IFolder) {
                result.add(new ModelFolder((IFolder)resource));
            } else if (ModelObjectDefinitionFile.isModFile(resource)) {
                result.add(new ModelObjectDefinitionFile((IFile)resource));
            } else if (resource instanceof IProject && ModelProject.isModProject((IProject)resource)) {
                result.add(new ModelProject((IProject)resource));
            }
            ++i;
        }
        return result.toArray(new ModelObject[result.size()]);
    }
}

