/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui.mapping;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelResource;
import org.eclipse.team.examples.model.mapping.ExampleModelProvider;
import org.eclipse.team.ui.mapping.SynchronizationCompareAdapter;
import org.eclipse.ui.IMemento;

public class CompareAdapter
extends SynchronizationCompareAdapter {
    private static final String CTX_MODEL_MAPPINGS = "org.eclipse.team.examples.filesystem.modelMappings";
    private final ExampleModelProvider provider;
    static /* synthetic */ Class class$0;

    public CompareAdapter(ExampleModelProvider provider) {
        this.provider = provider;
    }

    public String getName(ResourceMapping mapping) {
        Object o = mapping.getModelObject();
        if (o instanceof ModelObject) {
            return ((ModelObject)((Object)o)).getName();
        }
        return super.getName(mapping);
    }

    public String getPathString(ResourceMapping mapping) {
        Object o = mapping.getModelObject();
        if (o instanceof ModelObject) {
            return ((ModelObject)((Object)o)).getPath();
        }
        return super.getPathString(mapping);
    }

    public ICompareInput asCompareInput(ISynchronizationContext context, Object o) {
        if (o instanceof ModelObjectElementFile) {
            ModelObjectElementFile moeFile = (ModelObjectElementFile)((Object)o);
            return super.asCompareInput(context, (Object)moeFile.getResource());
        }
        return super.asCompareInput(context, o);
    }

    public ResourceMapping[] restore(IMemento memento) {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IMemento[] children = memento.getChildren(CTX_MODEL_MAPPINGS);
        int i = 0;
        while (i < children.length) {
            IMemento child = children[i];
            ResourceMapping mapping = this.restoreMapping(child);
            if (mapping != null) {
                result.add(mapping);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public void save(ResourceMapping[] mappings, IMemento memento) {
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            Object o = mapping.getModelObject();
            if (o instanceof ModelObject) {
                ModelObject mo = (ModelObject)((Object)o);
                this.save(mo, memento.createChild(CTX_MODEL_MAPPINGS));
            }
            ++i;
        }
    }

    private ResourceMapping restoreMapping(IMemento child) {
        String parent = child.getString("definition");
        String path = child.getString("resource");
        if (parent != null) {
            ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)ModelObject.create(this.getResource(parent));
            if (modFile != null) {
                ModelObjectElementFile modelObjectElementFile = new ModelObjectElementFile(modFile, (IFile)this.getResource(path));
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (ResourceMapping)modelObjectElementFile.getAdapter(clazz);
            }
        } else {
            ModelObject object = ModelObject.create(this.getResource(path));
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (ResourceMapping)object.getAdapter(clazz);
            }
        }
        return null;
    }

    private IResource getResource(String path) {
        Path resourcePath = new Path(path);
        if (path.endsWith("mod") || path.endsWith("moe")) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath);
        }
        if (resourcePath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.lastSegment());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)resourcePath);
    }

    private void save(ModelObject mo, IMemento memento) {
        if (mo instanceof ModelResource) {
            ModelResource resource = (ModelResource)mo;
            memento.putString("resource", resource.getResource().getFullPath().toString());
            if (mo instanceof ModelObjectElementFile) {
                ModelObjectElementFile moeFile = (ModelObjectElementFile)mo;
                ModelObjectDefinitionFile parent = (ModelObjectDefinitionFile)moeFile.getParent();
                memento.putString("definition", parent.getResource().getFullPath().toString());
            }
        }
    }

    public ModelProvider getProvider() {
        return this.provider;
    }
}

