/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.IResourceStateListener;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;

public class PessimisticDecorator
extends LabelProvider
implements ILabelDecorator,
IResourceStateListener {
    static /* synthetic */ Class class$0;

    public PessimisticDecorator() {
        PessimisticFilesystemProviderPlugin.getInstance().addProviderListener(this);
    }

    public String decorateText(String text, Object element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return text;
        }
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return text;
        }
        if (provider.isControlled(resource)) {
            if (provider.isCheckedout(resource)) {
                return ">" + text;
            }
            return text;
        }
        if (provider.isIgnored(resource)) {
            return "[ignored] " + text;
        }
        return "(not controlled) " + text;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    private PessimisticFilesystemProvider getProvider(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            return (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
        }
        return null;
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private void postLabelEvents(final LabelProviderChangedEvent[] events) {
        if (events != null && events.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < events.length) {
                        PessimisticDecorator.this.fireLabelProviderChanged(events[i]);
                        ++i;
                    }
                }
            });
        }
    }

    public void dispose() {
        PessimisticFilesystemProviderPlugin.getInstance().removeProviderListener(this);
        super.dispose();
    }

    public void stateChanged(IResource[] resources) {
        if (resources.length > 0) {
            LabelProviderChangedEvent[] events = new LabelProviderChangedEvent[resources.length];
            int i = 0;
            while (i < resources.length) {
                events[i] = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)resources[i]);
                ++i;
            }
            this.postLabelEvents(events);
        }
    }
}

