/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.ui.PessimisticProviderAction;

public abstract class SourceManagementAction
extends PessimisticProviderAction {
    public void run(IAction action) {
        IResource[] resources = this.getSelectedResources();
        if (resources == null || resources.length == 0) {
            return;
        }
        HashSet resourceSet = new HashSet(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.recursivelyAdd(resource, resourceSet);
            ++i;
        }
        if (!resourceSet.isEmpty()) {
            final Map byProject = this.sortByProject(resourceSet);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Iterator i = byProject.keySet().iterator();
                    while (i.hasNext()) {
                        IProject project = (IProject)i.next();
                        PessimisticFilesystemProvider provider = SourceManagementAction.this.getProvider((IResource)project);
                        if (provider == null) continue;
                        Set set = (Set)byProject.get(project);
                        IResource[] resources = new IResource[set.size()];
                        set.toArray(resources);
                        SourceManagementAction.this.manageResources(provider, resources, monitor);
                    }
                }
            };
            this.runWithProgressDialog(runnable);
        }
    }

    protected abstract void manageResources(PessimisticFilesystemProvider var1, IResource[] var2, IProgressMonitor var3);
}

