/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browser.demos.views;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EditorTab {
    Browser browser;
    Text htmlText;
    Text scriptText;
    Button htmlButton;
    Button scriptButton;
    static String html = "<html>\r\n\t<body>\r\n\t\t<h1 id='myid'>HTML Document</h1>\r\n\t\t<h2>Set HTML content</h2>\r\n\t\t<ol>\r\n\t\t\t<li>Enter html data into the 'setText' pane</li>\r\n\t\t\t<li>Click on 'setText' to set the new content</li>\r\n\t\t</ol>\r\n\t\t<h2>Query or modify HTML document</h2>\r\n\t\t<ol>\r\n\t\t<li>Enter javascript commands into the 'execute' pane</li>\r\n\t\t<li>Click on 'execute' to run the javascript in the current document</li>\r\n\t\t</ol>\r\n\t</body>\r\n</html>";
    static String script = "var node = document.createElement('P');\r\nvar text = document.createTextNode('Content inserted!');\r\nnode.appendChild(text);\r\ndocument.getElementById('myid').appendChild(node);\r\n\r\ndocument.bgColor = 'yellow';";

    public EditorTab(TabItem item) {
        final Composite parent = new Composite((Composite)item.getParent(), 0);
        item.setText("Editor");
        item.setControl((Control)parent);
        try {
            this.browser = new Browser(parent, 0);
        }
        catch (SWTError e) {
            e.printStackTrace();
            return;
        }
        final Sash sash = new Sash(parent, 512);
        Composite panel = new Composite(parent, 0);
        FormLayout form = new FormLayout();
        parent.setLayout((Layout)form);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)data);
        final FormData sashData = new FormData();
        sashData.left = new FormAttachment(50, 0);
        sashData.top = new FormAttachment(0, 0);
        sashData.bottom = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = sash.getBounds();
                Rectangle parentRect = sash.getParent().getClientArea();
                int right = parentRect.width - rect.width - 20;
                e.x = Math.max(Math.min(e.x, right), 20);
                if (e.x != rect.x) {
                    sashData.left = new FormAttachment(0, e.x);
                    parent.layout();
                }
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        panel.setLayoutData((Object)data);
        panel.setLayout((Layout)new FillLayout(512));
        Group htmlGroup = new Group(panel, 0);
        htmlGroup.setText("setText");
        this.htmlText = new Text((Composite)htmlGroup, 2);
        this.htmlButton = new Button((Composite)htmlGroup, 8);
        this.htmlButton.setText("setText");
        GridLayout gridLayout = new GridLayout();
        htmlGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.htmlText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.htmlButton.setLayoutData((Object)gridData);
        htmlGroup.layout();
        Group scriptGroup = new Group(panel, 0);
        scriptGroup.setText("execute");
        this.scriptText = new Text((Composite)scriptGroup, 2);
        this.scriptButton = new Button((Composite)scriptGroup, 8);
        this.scriptButton.setText("execute");
        gridLayout = new GridLayout();
        scriptGroup.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.scriptText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.scriptButton.setLayoutData((Object)gridData);
        scriptGroup.layout();
        this.browser.setText(html);
        this.htmlText.setText(html);
        this.scriptText.setText(script);
        parent.layout();
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Widget w = e.widget;
                if (w == EditorTab.this.htmlButton) {
                    EditorTab.this.browser.setText(EditorTab.this.htmlText.getText());
                }
                if (w == EditorTab.this.scriptButton) {
                    EditorTab.this.browser.execute(EditorTab.this.scriptText.getText());
                }
            }
        };
        this.htmlButton.addListener(13, listener);
        this.scriptButton.addListener(13, listener);
    }
}

