/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAuthInformation;
import org.eclipse.swt.internal.mozilla.nsIChannel;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.widgets.Shell;

class PromptAuth2 {
    XPCOMObject supports;
    XPCOMObject promptAuth;
    int refCount = 0;
    long parent;

    PromptAuth2() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public long method0(long[] args) {
                return PromptAuth2.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return PromptAuth2.this.AddRef();
            }

            public long method2(long[] args) {
                return PromptAuth2.this.Release();
            }
        };
        this.promptAuth = new XPCOMObject(new int[]{2, 0, 0, 4, 6}){

            public long method0(long[] args) {
                return PromptAuth2.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return PromptAuth2.this.AddRef();
            }

            public long method2(long[] args) {
                return PromptAuth2.this.Release();
            }

            public long method3(long[] args) {
                return PromptAuth2.this.PromptAuth(args[0], (int)args[1], args[2], args[3]);
            }

            public long method4(long[] args) {
                return PromptAuth2.this.AsyncPromptAuth(args[0], args[1], args[2], (int)args[3], args[4], args[5]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptAuth != null) {
            this.promptAuth.dispose();
            this.promptAuth = null;
        }
    }

    long getAddress() {
        return this.promptAuth.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(IIDStore.GetIID(nsISupports.class))) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IAUTHPROMPT2_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.promptAuth.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser() {
        if (this.parent == 0L) {
            return null;
        }
        return Mozilla.getBrowser(this.parent);
    }

    void setParent(long aParent) {
        this.parent = aParent;
    }

    int PromptAuth(long aChannel, int level, long authInfo, long _retval) {
        long host;
        nsIURI nsURI;
        nsIAuthInformation auth = new nsIAuthInformation(authInfo);
        Browser browser = this.getBrowser();
        if (browser != null) {
            Mozilla mozilla = (Mozilla)browser.webBrowser;
            if (mozilla.authCount++ < 3) {
                for (int i = 0; i < mozilla.authenticationListeners.length; ++i) {
                    AuthenticationEvent event = new AuthenticationEvent(browser);
                    event.location = mozilla.lastNavigateURL;
                    mozilla.authenticationListeners[i].authenticate(event);
                    if (!event.doit) {
                        XPCOM.memmove(_retval, new boolean[]{false});
                        return 0;
                    }
                    if (event.user == null || event.password == null) continue;
                    nsEmbedString string = new nsEmbedString(event.user);
                    int rc = auth.SetUsername(string.getAddress());
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    string.dispose();
                    string = new nsEmbedString(event.password);
                    rc = auth.SetPassword(string.getAddress());
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    string.dispose();
                    XPCOM.memmove(_retval, new boolean[]{true});
                    return 0;
                }
            }
        }
        String checkLabel = null;
        boolean[] checkValue = new boolean[1];
        String[] userLabel = new String[1];
        String[] passLabel = new String[1];
        String title = SWT.getMessage("SWT_Authentication_Required");
        long ptr = XPCOM.nsEmbedString_new();
        int rc = auth.GetUsername(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        int length = XPCOM.nsEmbedString_Length(ptr);
        long buffer = XPCOM.nsEmbedString_get(ptr);
        char[] chars = new char[length];
        XPCOM.memmove(chars, buffer, (long)(length * 2));
        userLabel[0] = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        ptr = XPCOM.nsEmbedString_new();
        rc = auth.GetPassword(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedString_Length(ptr);
        buffer = XPCOM.nsEmbedString_get(ptr);
        chars = new char[length];
        XPCOM.memmove(chars, buffer, (long)(length * 2));
        passLabel[0] = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        ptr = XPCOM.nsEmbedString_new();
        rc = auth.GetRealm(ptr);
        if (rc != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedString_Length(ptr);
        buffer = XPCOM.nsEmbedString_get(ptr);
        chars = new char[length];
        XPCOM.memmove(chars, buffer, (long)(length * 2));
        String realm = new String(chars);
        XPCOM.nsEmbedString_delete(ptr);
        nsIChannel channel = new nsIChannel(aChannel);
        long[] uri = new long[1];
        rc = channel.GetURI(uri);
        if (rc != 0) {
            SWT.error(rc);
        }
        if (uri[0] == 0L) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (nsURI = new nsIURI(uri[0])).GetHost(host = XPCOM.nsEmbedCString_new())) != 0) {
            SWT.error(rc);
        }
        length = XPCOM.nsEmbedCString_Length(host);
        buffer = XPCOM.nsEmbedCString_get(host);
        byte[] bytes = new byte[length];
        XPCOM.memmove(bytes, buffer, (long)length);
        String hostString = new String(bytes);
        XPCOM.nsEmbedCString_delete(host);
        nsURI.Release();
        String message = realm.length() > 0 && hostString.length() > 0 ? Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{realm, hostString}) : "";
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog dialog = new PromptDialog(shell);
        boolean[] result = new boolean[1];
        dialog.promptUsernameAndPassword(title, message, checkLabel, userLabel, passLabel, checkValue, result);
        XPCOM.memmove(_retval, result);
        if (result[0]) {
            nsEmbedString string = new nsEmbedString(userLabel[0]);
            rc = auth.SetUsername(string.getAddress());
            if (rc != 0) {
                SWT.error(rc);
            }
            string.dispose();
            string = new nsEmbedString(passLabel[0]);
            rc = auth.SetPassword(string.getAddress());
            if (rc != 0) {
                SWT.error(rc);
            }
            string.dispose();
        }
        return 0;
    }

    int AsyncPromptAuth(long aChannel, long aCallback, long aContext, int level, long authInfo, long _retval) {
        return -2147467263;
    }
}

