/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Cursor
extends Resource {
    static final byte[] WAIT_SOURCE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] SHADOWED_IBEAM_SOURCE = new byte[]{85, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, -86, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -86, -1, -1, -1, -1, 85, 85, 85, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public NSCursor handle;

    Cursor(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, int style) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        boolean shouldCreateCursor = false;
        try {
            switch (style) {
                case 21: {
                    this.handle = NSCursor.pointingHandCursor();
                    break;
                }
                case 0: {
                    this.handle = NSCursor.arrowCursor();
                    break;
                }
                case 1: {
                    shouldCreateCursor = true;
                    break;
                }
                case 2: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 3: {
                    this.handle = NSCursor.arrowCursor();
                    break;
                }
                case 4: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 5: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 6: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 7: {
                    this.handle = NSCursor.resizeUpDownCursor();
                    break;
                }
                case 8: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 9: {
                    this.handle = NSCursor.resizeLeftRightCursor();
                    break;
                }
                case 10: {
                    this.handle = NSCursor.resizeUpCursor();
                    break;
                }
                case 11: {
                    this.handle = NSCursor.resizeDownCursor();
                    break;
                }
                case 12: {
                    this.handle = NSCursor.resizeRightCursor();
                    break;
                }
                case 13: {
                    this.handle = NSCursor.resizeLeftCursor();
                    break;
                }
                case 14: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 15: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 16: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 17: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 18: {
                    this.handle = NSCursor.crosshairCursor();
                    break;
                }
                case 19: {
                    shouldCreateCursor = true;
                    break;
                }
                case 20: {
                    this.handle = NSCursor.operationNotAllowedCursor();
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            if (this.handle == null && shouldCreateCursor) {
                NSImage nsImage = (NSImage)new NSImage().alloc();
                NSBitmapImageRep nsImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
                this.handle = (NSCursor)new NSCursor().alloc();
                int width = 16;
                int height = 16;
                NSSize size = new NSSize();
                size.width = width;
                size.height = height;
                nsImage = nsImage.initWithSize(size);
                nsImageRep = nsImageRep.initWithBitmapDataPlanes(0L, width, height, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, width * 4, 32L);
                NSPoint point = new NSPoint();
                if (style == 1) {
                    OS.memmove(nsImageRep.bitmapData(), WAIT_SOURCE, (long)WAIT_SOURCE.length);
                } else {
                    OS.memmove(nsImageRep.bitmapData(), SHADOWED_IBEAM_SOURCE, (long)SHADOWED_IBEAM_SOURCE.length);
                    point.x = 4.0;
                    point.y = 8.0;
                }
                nsImage.addRepresentation(nsImageRep);
                this.handle = this.handle.initWithImage(nsImage, point);
                nsImageRep.release();
                nsImage.release();
            } else {
                this.handle.retain();
            }
            this.handle.setOnMouseEntered(true);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        byte[] data = new byte[source.width * source.height * 4];
        for (int y = 0; y < source.height; ++y) {
            int offset = y * source.width * 4;
            for (int x = 0; x < source.width; ++x) {
                int pixel = source.getPixel(x, y);
                int maskPixel = mask.getPixel(x, y);
                if (pixel == 0 && maskPixel == 0) {
                    data[offset] = -1;
                } else if (pixel == 0 && maskPixel == 1) {
                    data[offset + 3] = -1;
                    data[offset + 2] = -1;
                    data[offset + 1] = -1;
                    data[offset] = -1;
                } else if (pixel != 1 || maskPixel == 0) {
                    // empty if block
                }
                offset += 4;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.createNSCursor(hotspotX, hotspotY, data, source.width, source.height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void createNSCursor(int hotspotX, int hotspotY, byte[] buffer, int width, int height) {
        NSImage nsImage = (NSImage)new NSImage().alloc();
        NSBitmapImageRep nsImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        this.handle = (NSCursor)new NSCursor().alloc();
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        nsImage = nsImage.initWithSize(size);
        nsImageRep = nsImageRep.initWithBitmapDataPlanes(0L, width, height, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, width * 4, 32L);
        OS.memmove(nsImageRep.bitmapData(), buffer, (long)buffer.length);
        nsImage.addRepresentation(nsImageRep);
        NSPoint point = new NSPoint();
        point.x = hotspotX;
        point.y = hotspotY;
        this.handle = this.handle.initWithImage(nsImage, point);
        nsImageRep.release();
        nsImage.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        int i;
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        byte[] data = new byte[source.width * source.height * 4];
        PaletteData palette = source.palette;
        if (palette.isDirect) {
            ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, data, 32, source.width * 4, 1, 0, 0, source.width, source.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            byte[] srcReds = new byte[length];
            byte[] srcGreens = new byte[length];
            byte[] srcBlues = new byte[length];
            for (int i2 = 0; i2 < rgbs.length; ++i2) {
                RGB rgb = rgbs[i2];
                if (rgb == null) continue;
                srcReds[i2] = (byte)rgb.red;
                srcGreens[i2] = (byte)rgb.green;
                srcBlues[i2] = (byte)rgb.blue;
            }
            ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, data, 32, source.width * 4, 1, 0, 0, source.width, source.height, 0xFF0000, 65280, 255, false, false);
        }
        if (source.maskData != null || source.transparentPixel != -1) {
            ImageData mask = source.getTransparencyMask();
            byte[] maskData = mask.data;
            int maskBpl = mask.bytesPerLine;
            int offset = 0;
            int maskOffset = 0;
            for (int y = 0; y < source.height; ++y) {
                for (int x = 0; x < source.width; ++x) {
                    data[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                    offset += 4;
                }
                maskOffset += maskBpl;
            }
        } else if (source.alpha != -1) {
            byte alpha = (byte)source.alpha;
            for (i = 0; i < data.length; i += 4) {
                data[i] = alpha;
            }
        } else if (source.alphaData != null) {
            byte[] alphaData = source.alphaData;
            for (i = 0; i < data.length; i += 4) {
                data[i] = alphaData[i / 4];
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.createNSCursor(hotspotX, hotspotY, data, source.width, source.height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor cocoa_new(Device device, NSCursor handle) {
        Cursor cursor = new Cursor(device);
        cursor.handle = handle;
        return cursor;
    }
}

