/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSData;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data = new TransferData[types.length];
        for (int i = 0; i < types.length; ++i) {
            data[i] = new TransferData();
            data[i].type = types[i];
        }
        return data;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        for (int i = 0; i < types.length; ++i) {
            if (transferData.type != types[i]) continue;
            return true;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) && !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] orig = (byte[])object;
        NSData data = NSData.dataWithBytes(orig, orig.length);
        transferData.data = data;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data == null) {
            return null;
        }
        NSData data = (NSData)transferData.data;
        if (data.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[data.length()];
        data.getBytes(bytes);
        return bytes;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

