/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    boolean warnings;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    NSMutableParagraphStyle paragraphStyle;
    Point dpi;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            if (NSThread.isMainThread()) {
                NSString key;
                NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                NSThread nsthread = NSThread.currentThread();
                NSMutableDictionary dictionary = nsthread.threadDictionary();
                id obj = dictionary.objectForKey(key = NSString.stringWith("SWT_NSAutoreleasePool"));
                if (obj == null) {
                    NSNumber nsnumber = NSNumber.numberWithInteger(pool.id);
                    dictionary.setObject(nsnumber, key);
                } else {
                    pool.release();
                }
            }
            this.create(data);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSScreen screen = this.getPrimaryScreen();
        NSRect frame = screen.frame();
        float scaleFactor = screen.userSpaceScaleFactor();
        frame.x /= scaleFactor;
        frame.y /= scaleFactor;
        frame.width /= scaleFactor;
        frame.height /= scaleFactor;
        return new Rectangle((int)frame.x, (int)frame.y, (int)frame.width, (int)frame.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                for (int i = 0; i < length; ++i) {
                    if (this.objects[i] == null) continue;
                    ++count;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                for (int i = 0; i < length; ++i) {
                    if (this.objects[i] == null) continue;
                    data.objects[index] = this.objects[i];
                    data.errors[index] = this.errors[i];
                    ++index;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return OS.NSBitsPerPixelFromDepth(this.getPrimaryScreen().depth());
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    NSScreen getPrimaryScreen() {
        NSArray screens = NSScreen.screens();
        return new NSScreen(screens.objectAtIndex(0));
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        String systemFontName = this.systemFont.getFontData()[0].getName();
        boolean systemFontIncluded = false;
        int count = 0;
        NSArray families = NSFontManager.sharedFontManager().availableFontFamilies();
        FontData[] fds = new FontData[100];
        if (families != null) {
            int familyCount = families.count();
            for (int i = 0; i < familyCount; ++i) {
                NSString nsFamily = new NSString(families.objectAtIndex(i));
                String name = nsFamily.getString();
                NSArray fonts = NSFontManager.sharedFontManager().availableMembersOfFontFamily(nsFamily);
                if (fonts == null) continue;
                int fontCount = fonts.count();
                for (int j = 0; j < fontCount; ++j) {
                    NSArray fontDetails = new NSArray(fonts.objectAtIndex(j));
                    String nsName = new NSString(fontDetails.objectAtIndex(0)).getString();
                    int weight = new NSNumber(fontDetails.objectAtIndex(2)).integerValue();
                    int traits = new NSNumber(fontDetails.objectAtIndex(3)).integerValue();
                    int style = 0;
                    if ((traits & 1) != 0) {
                        style |= 2;
                    }
                    if (weight == 9) {
                        style |= 1;
                    }
                    if (faceName != null && !Compatibility.equalsIgnoreCase(faceName, name)) continue;
                    FontData data = new FontData(name, 0, style);
                    data.nsName = nsName;
                    if (Compatibility.equalsIgnoreCase(systemFontName, name)) {
                        systemFontIncluded = true;
                    }
                    if (count == fds.length) {
                        FontData[] newFds = new FontData[fds.length + 100];
                        System.arraycopy(fds, 0, newFds, 0, fds.length);
                        fds = newFds;
                    }
                    fds[count++] = data;
                }
            }
        }
        if (!systemFontIncluded && (faceName == null || Compatibility.equalsIgnoreCase(faceName, systemFontName))) {
            if (count == fds.length) {
                FontData[] newFds = new FontData[fds.length + 1];
                System.arraycopy(fds, 0, newFds, 0, fds.length);
                fds = newFds;
            }
            fds[count++] = this.systemFont.getFontData()[0];
        }
        if (count == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[count];
        System.arraycopy(fds, 0, result, 0, count);
        return result;
    }

    Point getScreenDPI() {
        NSScreen screen = this.getPrimaryScreen();
        NSDictionary dictionary = screen.deviceDescription();
        NSValue value = new NSValue(dictionary.objectForKey((id)new id((int)OS.NSDeviceResolution())).id);
        NSSize size = value.sizeValue();
        float scaling = 1.0f;
        if (OS.VERSION >= 4208) {
            scaling = screen.backingScaleFactor();
        }
        return new Point((int)(size.width / scaling), (int)(size.height / scaling));
    }

    public Color getSystemColor(int id2) {
        this.checkDevice();
        switch (id2) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        this.paragraphStyle.setAlignment(0);
        this.paragraphStyle.setLineBreakMode(2);
        NSArray tabs = new NSArray(new NSArray().alloc().init());
        this.paragraphStyle.setTabStops(tabs);
        tabs.release();
        boolean smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        float systemFontSize = smallFonts ? NSFont.smallSystemFontSize() : NSFont.systemFontSize();
        Point dpi = this.dpi = this.getDPI();
        Point screenDPI = this.getScreenDPI();
        NSFont font = NSFont.systemFontOfSize(systemFontSize * (float)dpi.y / (float)screenDPI.y);
        font.retain();
        this.systemFont = Font.cocoa_new(this, font);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path) {
        boolean[] isDirectory;
        byte[] fsRef;
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        boolean result = false;
        NSString nsPath = NSString.stringWith(path);
        int fsRepresentation = nsPath.fileSystemRepresentation();
        if (fsRepresentation != 0 && OS.FSPathMakeRef(fsRepresentation, fsRef = new byte[80], isDirectory = new boolean[1]) == 0) {
            result = OS.ATSFontActivateFromFileReference(fsRef, 2, 0, 0, 0, null) == 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int objectCount = 0;
                int colors = 0;
                int cursors = 0;
                int fonts = 0;
                int gcs = 0;
                int images = 0;
                int paths = 0;
                int patterns = 0;
                int regions = 0;
                int textLayouts = 0;
                int transforms = 0;
                for (int i = 0; i < this.objects.length; ++i) {
                    Object object2 = this.objects[i];
                    if (object2 == null) continue;
                    ++objectCount;
                    if (object2 instanceof Color) {
                        ++colors;
                    }
                    if (object2 instanceof Cursor) {
                        ++cursors;
                    }
                    if (object2 instanceof Font) {
                        ++fonts;
                    }
                    if (object2 instanceof GC) {
                        ++gcs;
                    }
                    if (object2 instanceof Image) {
                        ++images;
                    }
                    if (object2 instanceof Path) {
                        ++paths;
                    }
                    if (object2 instanceof Pattern) {
                        ++patterns;
                    }
                    if (object2 instanceof Region) {
                        ++regions;
                    }
                    if (object2 instanceof TextLayout) {
                        ++textLayouts;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++transforms;
                }
                if (objectCount != 0) {
                    String string = "Summary: ";
                    if (colors != 0) {
                        string = string + colors + " Color(s), ";
                    }
                    if (cursors != 0) {
                        string = string + cursors + " Cursor(s), ";
                    }
                    if (fonts != 0) {
                        string = string + fonts + " Font(s), ";
                    }
                    if (gcs != 0) {
                        string = string + gcs + " GC(s), ";
                    }
                    if (images != 0) {
                        string = string + images + " Image(s), ";
                    }
                    if (paths != 0) {
                        string = string + paths + " Path(s), ";
                    }
                    if (patterns != 0) {
                        string = string + patterns + " Pattern(s), ";
                    }
                    if (regions != 0) {
                        string = string + regions + " Region(s), ";
                    }
                    if (textLayouts != 0) {
                        string = string + textLayouts + " TextLayout(s), ";
                    }
                    if (transforms != 0) {
                        string = string + transforms + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.out.println(string);
                    }
                    for (int i = 0; i < this.errors.length; ++i) {
                        if (this.errors[i] == null) continue;
                        this.errors[i].printStackTrace(System.out);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.release();
        }
        this.paragraphStyle = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
        this.warnings = warnings;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

