/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSCalendarDate;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDatePicker;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTDatePicker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    NSButton buttonView;
    Shell popupShell;
    DateTime popupCalendar;
    int savedYear;
    int savedMonth;
    int savedDay;
    Listener clickListener;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        if (((style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        NSControl widget = (NSControl)this.view;
        NSSize size = widget.cell().cellSize();
        width = (int)Math.ceil(size.width);
        height = (int)Math.ceil(size.height);
        if ((this.style & 4) != 0) {
            size = this.buttonView.cell().cellSize();
            width += (int)Math.ceil(size.width) - this.getBezelSize() * 2;
            height = Math.max(height, (int)Math.ceil(size.height));
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        NSDatePicker widget = (NSDatePicker)new SWTDatePicker().alloc();
        widget.init();
        int pickerStyle = (this.style & 4) != 0 ? 2 : 0;
        int elementFlags = 0;
        if ((this.style & 0x400) != 0) {
            pickerStyle = 1;
            elementFlags = 224;
        } else {
            if ((this.style & 0x80) != 0) {
                int n = elementFlags = (this.style & 0x8000) != 0 ? 12 : 14;
            }
            if ((this.style & 0x20) != 0) {
                elementFlags = (this.style & 0x8000) != 0 ? 192 : 224;
            }
        }
        widget.setBezeled((this.style & 0x800) != 0);
        if ((this.style & 0x800) == 0) {
            widget.setFocusRingType(1);
        }
        widget.setDrawsBackground(true);
        widget.setDatePickerStyle(pickerStyle);
        widget.setDatePickerElements(elementFlags);
        NSCalendarDate date = NSCalendarDate.calendarDate();
        widget.setDateValue(date);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
        if ((this.style & 4) != 0) {
            NSButton buttonWidget = (NSButton)new SWTButton().alloc();
            buttonWidget.init();
            buttonWidget.setButtonType(0);
            buttonWidget.setBezelStyle(14);
            buttonWidget.setFocusRingType(1);
            buttonWidget.setTitle(NSString.stringWith(""));
            buttonWidget.setImagePosition(0);
            buttonWidget.setTarget(this.view);
            buttonWidget.setAction(OS.sel_sendVerticalSelection);
            this.view.addSubview(buttonWidget);
            this.buttonView = buttonWidget;
            this.createPopupShell(-1, -1, -1);
        }
    }

    void createPopupShell(int year, int month, int day) {
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupShell.isPopup = true;
        this.popupShell.window.setHasShadow(true);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.clickListener == null) {
            this.clickListener = new Listener(){

                public void handleEvent(Event event) {
                    Control c;
                    if (event.widget instanceof Control && event.widget != DateTime.this && (c = (Control)event.widget).getShell() != DateTime.this.popupShell) {
                        DateTime.this.hideCalendar();
                    }
                }
            };
        }
        this.popupCalendar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int year = DateTime.this.popupCalendar.getYear();
                int month = DateTime.this.popupCalendar.getMonth();
                int day = DateTime.this.popupCalendar.getDay();
                DateTime.this.setDate(year, month, day);
                Event e = new Event();
                e.time = event.time;
                DateTime.this.notifyListeners(13, e);
                DateTime.this.hideCalendar();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (DateTime.this.popupShell != null && !DateTime.this.popupShell.isDisposed()) {
                    DateTime.this.disposePopupShell();
                }
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                DateTime.this.hideCalendar();
                DateTime.this.display.removeFilter(3, DateTime.this.clickListener);
            }
        });
        if (year != -1) {
            this.popupCalendar.setDate(year, month, day);
        }
    }

    NSFont defaultNSFont() {
        return this.display.datePickerFont;
    }

    void deregister() {
        super.deregister();
        if (this.buttonView != null) {
            this.display.removeWidget(this.buttonView);
            this.display.removeWidget(this.buttonView.cell());
        }
    }

    void disposePopupShell() {
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
    }

    void drawBackground(int id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    void showCalendar() {
        if (this.isDropped()) {
            return;
        }
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
        if (this.getShell() != this.popupShell.getParent()) {
            this.disposePopupShell();
            this.createPopupShell(this.savedYear, this.savedMonth, this.savedDay);
        }
        Point dateBounds = this.getSize();
        Point calendarSize = this.popupCalendar.computeSize(-1, -1, false);
        this.popupCalendar.setBounds(1, 1, Math.max(dateBounds.x - 2, calendarSize.x), calendarSize.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        Rectangle parentRect = this.display.map((Control)this.getParent(), null, this.getBounds());
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(dateBounds.x, calendarSize.x + 2);
        int height = calendarSize.y + 2;
        int x = parentRect.x;
        int y = parentRect.y + dateBounds.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - calendarSize.x;
        }
        this.popupShell.setBounds(x, y, width, height);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
        this.display.addFilter(3, this.clickListener);
    }

    void hideCalendar() {
        if (!this.isDropped()) {
            return;
        }
        this.popupShell.setVisible(false);
        if (!this.isDisposed() && this.isFocusControl()) {
            this.setFocus();
        }
        this.display.removeFilter(3, this.clickListener);
    }

    int getBezelInset() {
        return this.buttonView.cell().controlSize() == 2 ? 3 : 1;
    }

    int getBezelSize() {
        return this.buttonView.cell().controlSize() == 2 ? 6 : 4;
    }

    NSCalendarDate getCalendarDate() {
        NSDate date = ((NSDatePicker)this.view).dateValue();
        return date.dateWithCalendarFormat(null, null);
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public int getDay() {
        this.checkWidget();
        return this.getCalendarDate().dayOfMonth();
    }

    public int getHours() {
        this.checkWidget();
        return this.getCalendarDate().hourOfDay();
    }

    public int getMinutes() {
        this.checkWidget();
        return this.getCalendarDate().minuteOfHour();
    }

    public int getMonth() {
        this.checkWidget();
        return this.getCalendarDate().monthOfYear() - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() : this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        return this.getCalendarDate().secondOfMinute();
    }

    public int getYear() {
        this.checkWidget();
        return this.getCalendarDate().yearOfCommonEra();
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    boolean isEventView(int id2) {
        return true;
    }

    boolean isFlipped(int id2, int sel) {
        if ((this.style & 0x400) != 0) {
            return super.isFlipped(id2, sel);
        }
        return true;
    }

    void keyDown(int id2, int sel, int theEvent) {
        if ((this.style & 4) != 0) {
            boolean alt;
            NSEvent nsEvent = new NSEvent(theEvent);
            int keyCode = Display.translateKey(nsEvent.keyCode());
            boolean bl = alt = (nsEvent.modifierFlags() & 0x80000) != 0;
            if (alt && (keyCode == 0x1000001 || keyCode == 0x1000002)) {
                if (this.isDropped()) {
                    this.hideCalendar();
                } else {
                    this.showCalendar();
                }
                return;
            }
            if (keyCode == 27) {
                this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                this.hideCalendar();
                return;
            }
        }
        super.keyDown(id2, sel, theEvent);
        if ((this.style & 4) != 0 && this.popupCalendar != null) {
            int month = this.getMonth();
            int day = this.getDay();
            int year = this.getYear();
            this.popupCalendar.setDate(year, month, day);
        }
    }

    void register() {
        super.register();
        if (this.buttonView != null) {
            this.display.addWidget(this.buttonView, this);
            this.display.addWidget(this.buttonView.cell(), this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.buttonView != null) {
            this.buttonView.release();
        }
        this.buttonView = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resized() {
        super.resized();
        if (this.buttonView == null) {
            return;
        }
        NSSize buttonSize = this.buttonView.cell().cellSize();
        NSRect rect = this.view.bounds();
        rect.x = rect.width - buttonSize.width + (float)this.getBezelSize();
        rect.y = -this.getBezelInset();
        rect.width = buttonSize.width;
        rect.height = buttonSize.height;
        this.buttonView.setFrame(rect);
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        if ((this.style & 0x400) == 0) {
            short keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 36: 
                case 76: {
                    if ((this.style & 4) != 0) {
                        this.hideCalendar();
                    }
                    this.sendSelectionEvent(14);
                }
            }
        }
        return result;
    }

    void sendSelection() {
        NSEvent event = NSApplication.sharedApplication().currentEvent();
        if (event != null && (this.style & 0x400) != 0) {
            if (event.clickCount() == 2) {
                this.sendSelectionEvent(14);
            } else if (event.type() == 2) {
                this.sendSelectionEvent(13);
            }
        } else {
            this.sendSelectionEvent(13);
        }
    }

    void sendVerticalSelection() {
        this.setFocus();
        if (this.isDropped()) {
            this.hideCalendar();
        } else {
            this.showCalendar();
        }
    }

    void setBackgroundColor(NSColor nsColor) {
        ((NSDatePicker)this.view).setBackgroundColor(nsColor);
    }

    void setBackgroundImage(NSImage image) {
        ((NSDatePicker)this.view).setDrawsBackground(image == null);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(year, month + 1, day, date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == year && newDate.monthOfYear() == month + 1 && newDate.dayOfMonth() == day) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), day, date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == date.yearOfCommonEra() && newDate.monthOfYear() == date.monthOfYear() && newDate.dayOfMonth() == day) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    void setForeground(float[] color) {
        NSColor nsColor = color == null ? ((this.style & 0x400) != 0 ? NSColor.controlTextColor() : NSColor.textColor()) : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0f);
        ((NSDatePicker)this.view).setTextColor(nsColor);
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (hours < 0 || hours > 23) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), hours, date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (minutes < 0 || minutes > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), minutes, date.secondOfMinute(), date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setMonth(int month) {
        this.checkWidget();
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), month + 1, date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == date.yearOfCommonEra() && newDate.monthOfYear() == month + 1 && newDate.dayOfMonth() == date.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (seconds < 0 || seconds > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), seconds, date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    void setSmallSize() {
        if (this.buttonView != null) {
            this.buttonView.cell().setControlSize(2);
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (hours < 0 || hours > 23 || minutes < 0 || minutes > 59 || seconds < 0 || seconds > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), hours, minutes, seconds, date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setYear(int year) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(year, date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == year && newDate.monthOfYear() == date.monthOfYear() && newDate.dayOfMonth() == date.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }
}

