/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class Accessible {
    Vector accessibleListeners;
    Vector accessibleControlListeners;
    Vector accessibleTextListeners;
    Vector accessibleActionListeners;
    Vector accessibleEditableTextListeners;
    Vector accessibleHyperlinkListeners;
    Vector accessibleTableListeners;
    Vector accessibleTableCellListeners;
    Vector accessibleTextExtendedListeners;
    Vector accessibleValueListeners;
    Vector accessibleAttributeListeners;
    Accessible parent;
    AccessibleObject accessibleObject;
    Control control;
    Vector relations;
    Vector children;

    public Accessible(Accessible parent) {
        this.parent = Accessible.checkNull(parent);
        this.control = parent.control;
        if (parent.children == null) {
            parent.children = new Vector();
        }
        parent.children.addElement(this);
    }

    @Deprecated
    protected Accessible() {
    }

    static Accessible checkNull(Accessible parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    Accessible(Control control) {
        this.control = control;
        AccessibleFactory.registerAccessible(this);
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new Vector();
        }
        this.accessibleListeners.addElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new Vector();
        }
        this.accessibleControlListeners.addElement(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new Vector();
            }
            this.accessibleTextExtendedListeners.addElement(listener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new Vector();
            }
            this.accessibleTextListeners.addElement(listener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new Vector();
        }
        this.accessibleActionListeners.addElement(listener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new Vector();
        }
        this.accessibleEditableTextListeners.addElement(listener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new Vector();
        }
        this.accessibleHyperlinkListeners.addElement(listener);
    }

    public void addAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new Vector();
        }
        this.accessibleTableListeners.addElement(listener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new Vector();
        }
        this.accessibleTableCellListeners.addElement(listener);
    }

    public void addAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new Vector();
        }
        this.accessibleValueListeners.addElement(listener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new Vector();
        }
        this.accessibleAttributeListeners.addElement(listener);
    }

    public void addRelation(int type, Accessible target) {
        Relation relation;
        this.checkWidget();
        if (this.relations == null) {
            this.relations = new Vector();
        }
        if (this.relations.indexOf(relation = new Relation(type, target)) != -1) {
            return;
        }
        this.relations.add(relation);
        if (this.accessibleObject != null) {
            this.accessibleObject.addRelation(type, target);
        }
    }

    void addRelations() {
        if (this.relations == null) {
            return;
        }
        if (this.accessibleObject == null) {
            return;
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            Relation relation = (Relation)this.relations.elementAt(i);
            this.accessibleObject.addRelation(relation.type, relation.target);
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release();
        this.parent.children.removeElement(this);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleObject getAccessibleObject() {
        if (this.accessibleObject == null) {
            if (this.parent == null) {
                AccessibleFactory.createAccessible(this);
            } else {
                this.accessibleObject = AccessibleFactory.createChildAccessible(this, -1);
                this.accessibleObject.parent = this.parent.getAccessibleObject();
            }
        }
        return this.accessibleObject;
    }

    int getControlHandle() {
        int list;
        int result = this.control.handle;
        if (this.control instanceof Label && (list = OS.gtk_container_get_children(result)) != 0) {
            int temp = list;
            while (temp != 0) {
                int widget = OS.g_list_data(temp);
                if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0) ? OS.gtk_widget_get_visible(widget) : OS.GTK_WIDGET_VISIBLE(widget)) {
                    result = widget;
                    break;
                }
                temp = OS.g_list_next(temp);
            }
            OS.g_list_free(list);
        }
        return result;
    }

    public void internal_dispose_Accessible() {
        AccessibleFactory.unregisterAccessible(this);
        this.release();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Accessible child = (Accessible)this.children.elementAt(i);
                child.dispose();
            }
        }
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.removeElement(listener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.removeElement(listener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.removeElement(listener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.removeElement(listener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.removeElement(listener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.removeElement(listener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.removeElement(listener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.removeElement(listener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.removeElement(listener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.removeElement(listener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.removeElement(listener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int type, Accessible target) {
        this.checkWidget();
        if (this.relations == null) {
            return;
        }
        Relation relation = new Relation(type, target);
        int index = this.relations.indexOf(relation);
        if (index == -1) {
            return;
        }
        this.relations.remove(index);
        if (this.accessibleObject != null) {
            this.accessibleObject.removeRelation(type, target);
        }
    }

    public void sendEvent(int event, Object eventData) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.sendEvent(event, eventData);
        }
    }

    public void sendEvent(int event, Object eventData, int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            switch (event) {
                case 32777: 
                case 32778: 
                case 32779: 
                case 32780: 
                case 32781: 
                case 32782: 
                case 32788: {
                    this.accessibleObject.sendEvent(event, eventData, childID);
                }
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(childID);
        }
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(index);
        }
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(type, startIndex, length);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }

    static class Relation {
        int type;
        Accessible target;

        public Relation(int type, Accessible target) {
            this.type = type;
            this.target = target;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation relation = (Relation)object;
            return relation.type == this.type && relation.target == this.target;
        }
    }
}

