/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.XRenderPictureAttributes;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, gdkGC);
        this.init();
    }

    static void addCairoString(int cairo, String string, float x, float y, Font font) {
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int layout = OS.pango_cairo_create_layout(cairo);
        if (layout == 0) {
            SWT.error(2);
        }
        OS.pango_layout_set_text(layout, buffer, -1);
        OS.pango_layout_set_font_description(layout, font.handle);
        double[] currentX = new double[1];
        double[] currentY = new double[1];
        Cairo.cairo_get_current_point(cairo, currentX, currentY);
        if (currentX[0] != (double)x || currentY[0] != (double)y) {
            Cairo.cairo_move_to(cairo, x, y);
        }
        OS.pango_cairo_layout_path(cairo, layout);
        OS.g_object_unref(layout);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC gtk_new(int handle, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, handle);
        return gc;
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int gdkGC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if ((state & 3) != 0) {
                Pattern pattern;
                GdkColor color;
                if ((state & 1) != 0) {
                    color = this.data.foreground;
                    pattern = this.data.foregroundPattern;
                    this.data.state &= 0xFFFFFFFD;
                } else {
                    color = this.data.background;
                    pattern = this.data.backgroundPattern;
                    this.data.state &= 0xFFFFFFFE;
                }
                if (pattern != null) {
                    if ((this.data.style & 0x8000000) != 0 && pattern.surface != 0) {
                        int newPattern = Cairo.cairo_pattern_create_for_surface(pattern.surface);
                        if (newPattern == 0) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_set_extend(newPattern, 1);
                        double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                        Cairo.cairo_pattern_set_matrix(newPattern, matrix);
                        Cairo.cairo_set_source(cairo, newPattern);
                        Cairo.cairo_pattern_destroy(newPattern);
                    } else {
                        Cairo.cairo_set_source(cairo, pattern.handle);
                    }
                } else {
                    Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
            }
            if ((state & 4) != 0 && this.data.layout != 0) {
                Font font = this.data.font;
                OS.pango_layout_set_font_description(this.data.layout, font.handle);
            }
            if ((state & 0x10) != 0) {
                int cap_style = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        cap_style = 1;
                        break;
                    }
                    case 1: {
                        cap_style = 0;
                        break;
                    }
                    case 3: {
                        cap_style = 2;
                    }
                }
                Cairo.cairo_set_line_cap(cairo, cap_style);
            }
            if ((state & 0x20) != 0) {
                int join_style = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        join_style = 0;
                        break;
                    }
                    case 2: {
                        join_style = 1;
                        break;
                    }
                    case 3: {
                        join_style = 2;
                    }
                }
                Cairo.cairo_set_line_join(cairo, join_style);
            }
            if ((state & 0x40) != 0) {
                Cairo.cairo_set_line_width(cairo, this.data.lineWidth == 0.0f ? 1.0 : (double)this.data.lineWidth);
                switch (this.data.lineStyle) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        state |= 8;
                    }
                }
            }
            if ((state & 8) != 0) {
                float dashesOffset = 0.0f;
                float[] dashes = null;
                float width = this.data.lineWidth;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                        break;
                    }
                    case 3: {
                        dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                        break;
                    }
                    case 4: {
                        dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        dashes = this.data.lineDashes;
                    }
                }
                if (dashes != null) {
                    dashesOffset = this.data.lineDashesOffset;
                    double[] cairoDashes = new double[dashes.length];
                    for (int i = 0; i < cairoDashes.length; ++i) {
                        cairoDashes[i] = width == 0.0f || this.data.lineStyle == 6 ? (double)dashes[i] : (double)(dashes[i] * width);
                    }
                    Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, dashesOffset);
                } else {
                    Cairo.cairo_set_dash(cairo, null, 0, 0.0);
                }
            }
            if ((state & 0x80) != 0) {
                Cairo.cairo_set_miter_limit(cairo, this.data.lineMiterLimit);
            }
            if ((state & 0x200) != 0) {
                double strokeWidth;
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                double[] dx = new double[]{1.0};
                double[] dy = new double[]{1.0};
                Cairo.cairo_user_to_device_distance(cairo, dx, dy);
                double scaling = dx[0];
                if (scaling < 0.0) {
                    scaling = -scaling;
                }
                if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                    this.data.cairoXoffset = 0.5 / scaling;
                }
                if ((scaling = dy[0]) < 0.0) {
                    scaling = -scaling;
                }
                if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                    this.data.cairoYoffset = 0.5 / scaling;
                }
            }
            return;
        }
        if ((state & 3) != 0) {
            GdkColor foreground;
            if ((state & 1) != 0) {
                foreground = this.data.foreground;
                this.data.state &= 0xFFFFFFFD;
            } else {
                foreground = this.data.background;
                this.data.state &= 0xFFFFFFFE;
            }
            OS.gdk_gc_set_foreground(this.handle, foreground);
        }
        if ((state & 0x100) != 0) {
            GdkColor background = this.data.background;
            OS.gdk_gc_set_background(this.handle, background);
        }
        if ((state & 4) != 0 && this.data.layout != 0) {
            Font font = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, font.handle);
        }
        if ((state & 0x78) != 0) {
            int cap_style = 0;
            int join_style = 0;
            int width = (int)this.data.lineWidth;
            int line_style = 0;
            float[] dashes = null;
            switch (this.data.lineCap) {
                case 2: {
                    cap_style = 2;
                    break;
                }
                case 1: {
                    cap_style = 1;
                    break;
                }
                case 3: {
                    cap_style = 3;
                }
            }
            switch (this.data.lineJoin) {
                case 2: {
                    join_style = 1;
                    break;
                }
                case 1: {
                    join_style = 0;
                    break;
                }
                case 3: {
                    join_style = 2;
                }
            }
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0 ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0 ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                if ((state & 8) != 0) {
                    byte[] dash_list = new byte[dashes.length];
                    for (int i = 0; i < dash_list.length; ++i) {
                        dash_list[i] = (byte)(width == 0 || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * (float)width);
                    }
                    OS.gdk_gc_set_dashes(this.handle, 0, dash_list, dash_list.length);
                }
                line_style = 1;
            } else {
                line_style = 0;
            }
            OS.gdk_gc_set_line_attributes(this.handle, width, line_style, cap_style, join_style);
        }
    }

    int convertRgn(int rgn, double[] matrix) {
        int newRgn = OS.gdk_region_new();
        if (this.isIdentity(matrix)) {
            OS.gdk_region_union(newRgn, rgn);
            return newRgn;
        }
        int[] nRects = new int[1];
        int[] rects = new int[1];
        Region.gdk_region_get_rectangles(rgn, rects, nRects);
        GdkRectangle rect = new GdkRectangle();
        int[] pointArray = new int[8];
        double[] x = new double[1];
        double[] y = new double[1];
        for (int i = 0; i < nRects[0]; ++i) {
            OS.memmove(rect, rects[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
            x[0] = rect.x;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[0] = (int)x[0];
            pointArray[1] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[2] = (int)Math.round(x[0]);
            pointArray[3] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[4] = (int)Math.round(x[0]);
            pointArray[5] = (int)Math.round(y[0]);
            x[0] = rect.x;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[6] = (int)x[0];
            pointArray[7] = (int)Math.round(y[0]);
            int polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
            OS.gdk_region_union(newRgn, polyRgn);
            OS.gdk_region_destroy(polyRgn);
        }
        if (rects[0] != 0) {
            OS.g_free(rects[0]);
        }
        return newRgn;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (OS.USE_CAIRO) {
            int cairo = Cairo.cairo_create(image.surface);
            if (cairo == 0) {
                SWT.error(2);
            }
            Cairo.cairo_translate(cairo, -x, -y);
            Cairo.cairo_push_group(cairo);
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(cairo, this.data.image.surface, 0.0, 0.0);
            } else if (this.data.drawable != 0) {
                if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_cairo_set_source_window(cairo, this.data.drawable, 0, 0);
                } else {
                    int[] w = new int[1];
                    int[] h = new int[1];
                    OS.gdk_drawable_get_size(this.data.drawable, w, h);
                    int width = w[0];
                    int height = h[0];
                    int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                    int xDrawable = OS.gdk_x11_drawable_get_xid(this.data.drawable);
                    int xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
                    int srcSurface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
                    Cairo.cairo_set_source_surface(cairo, srcSurface, 0.0, 0.0);
                }
            } else {
                Cairo.cairo_destroy(cairo);
                return;
            }
            Cairo.cairo_set_operator(cairo, 1);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_pop_group_to_source(cairo);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_destroy(cairo);
            return;
        }
        Rectangle rect = image.getBounds();
        int gdkGC = OS.gdk_gc_new(image.pixmap);
        if (gdkGC == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow(gdkGC, 1);
        OS.gdk_draw_drawable(image.pixmap, gdkGC, this.data.drawable, x, y, 0, 0, rect.width, rect.height);
        OS.g_object_unref(gdkGC);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int drawable = this.data.drawable;
        if (OS.USE_CAIRO) {
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(this.handle, this.data.image.surface, deltaX, deltaY);
                Cairo.cairo_rectangle(this.handle, destX, destY, width, height);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_fill(this.handle);
            } else if (drawable != 0) {
                Cairo.cairo_save(this.handle);
                Cairo.cairo_rectangle(this.handle, destX, destY, width, height);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_translate(this.handle, deltaX, deltaY);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_push_group(this.handle);
                OS.gdk_cairo_set_source_window(this.handle, drawable, 0, 0);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_pop_group_to_source(this.handle);
                Cairo.cairo_rectangle(this.handle, destX - deltaX, destY - deltaY, width, height);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_restore(this.handle);
                if (paint) {
                    int visibleRegion = OS.GTK3 ? OS.gdk_window_get_visible_region(drawable) : OS.gdk_drawable_get_visible_region(drawable);
                    GdkRectangle srcRect = new GdkRectangle();
                    srcRect.x = srcX;
                    srcRect.y = srcY;
                    srcRect.width = width;
                    srcRect.height = height;
                    int copyRegion = OS.gdk_region_rectangle(srcRect);
                    OS.gdk_region_intersect(copyRegion, visibleRegion);
                    int invalidateRegion = OS.gdk_region_rectangle(srcRect);
                    OS.gdk_region_subtract(invalidateRegion, visibleRegion);
                    OS.gdk_region_offset(invalidateRegion, deltaX, deltaY);
                    OS.gdk_window_invalidate_region(drawable, invalidateRegion, false);
                    OS.gdk_region_destroy(visibleRegion);
                    OS.gdk_region_destroy(copyRegion);
                    OS.gdk_region_destroy(invalidateRegion);
                }
            }
        } else {
            if (this.data.image == null && paint) {
                OS.gdk_gc_set_exposures(this.handle, true);
            }
            OS.gdk_draw_drawable(drawable, this.handle, drawable, srcX, srcY, destX, destY, width, height);
        }
        if (this.data.image == null & paint) {
            if (!OS.USE_CAIRO) {
                OS.gdk_gc_set_exposures(this.handle, false);
            }
            boolean disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
            GdkRectangle rect = new GdkRectangle();
            if (disjoint) {
                rect.x = srcX;
                rect.y = srcY;
                rect.width = width;
                rect.height = height;
                OS.gdk_window_invalidate_rect(drawable, rect, false);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    rect.x = newX;
                    rect.y = srcY;
                    rect.width = Math.abs(deltaX);
                    rect.height = height;
                    OS.gdk_window_invalidate_rect(drawable, rect, false);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    rect.x = srcX;
                    rect.y = newY;
                    rect.width = width;
                    rect.height = Math.abs(deltaY);
                    OS.gdk_window_invalidate_rect(drawable, rect, false);
                }
            }
        }
    }

    void createLayout() {
        int context = OS.gdk_pango_context_get();
        if (context == 0) {
            SWT.error(2);
        }
        this.data.context = context;
        int layout = OS.pango_layout_new(context);
        if (layout == 0) {
            SWT.error(2);
        }
        this.data.layout = layout;
        OS.pango_context_set_language(context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(context, (this.data.style & 0x8000000) != 0 ? 1 : 0);
        OS.pango_layout_set_auto_dir(layout, false);
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0;
        this.data.layout = 0;
    }

    void destroy() {
        Image image;
        int cairo;
        if (this.data.disposeCairo && (cairo = this.data.cairo) != 0) {
            Cairo.cairo_destroy(cairo);
        }
        this.data.cairo = 0;
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.gdk_region_destroy(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0;
        this.data.drawable = 0;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void drawFocus(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0) {
            this.checkGC(1);
            if (OS.GTK3) {
                int context = OS.gtk_widget_get_style_context(this.data.device.shellHandle);
                OS.gtk_render_focus(context, cairo, x, y, width, height);
            } else {
                double dash_offset;
                int[] lineWidth = new int[1];
                OS.gtk_widget_style_get(this.data.device.shellHandle, OS.focus_line_width, lineWidth, 0);
                Cairo.cairo_save(cairo);
                Cairo.cairo_set_line_width(cairo, lineWidth[0]);
                double[] dashes = new double[]{1.0, 1.0};
                for (dash_offset = (double)((float)(-lineWidth[0]) / 2.0f); dash_offset < 0.0; dash_offset += 2.0) {
                }
                Cairo.cairo_set_dash(cairo, dashes, dashes.length, dash_offset);
                Cairo.cairo_rectangle(cairo, (float)x + (float)lineWidth[0] / 2.0f, (float)y + (float)lineWidth[0] / 2.0f, width, height);
                Cairo.cairo_stroke(cairo);
                Cairo.cairo_restore(cairo);
            }
            return;
        }
        int style = OS.gtk_widget_get_style(this.data.device.shellHandle);
        OS.gtk_paint_focus(style, this.data.drawable, 0, null, this.data.device.shellHandle, new byte[1], x, y, width, height);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int imgHeight;
        int imgWidth;
        if (OS.USE_CAIRO) {
            imgWidth = srcImage.width;
            imgHeight = srcImage.height;
        } else {
            int[] width = new int[1];
            int[] height = new int[1];
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                OS.gdk_pixmap_get_size(srcImage.pixmap, width, height);
            } else {
                OS.gdk_drawable_get_size(srcImage.pixmap, width, height);
            }
            imgWidth = width[0];
            imgHeight = height[0];
        }
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (this.data.alpha != 0) {
                srcImage.createSurface();
                Cairo.cairo_save(cairo);
                if ((this.data.style & 0x8000000) != 0) {
                    Cairo.cairo_scale(cairo, -1.0, 1.0);
                    Cairo.cairo_translate(cairo, -2 * destX - destWidth, 0.0);
                }
                Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
                Cairo.cairo_clip(cairo);
                if (srcWidth != destWidth || srcHeight != destHeight) {
                    float scaleX = (float)destWidth / (float)srcWidth;
                    float scaleY = (float)destHeight / (float)srcHeight;
                    Cairo.cairo_translate(cairo, destX - (int)((float)srcX * scaleX), destY - (int)((float)srcY * scaleY));
                    Cairo.cairo_scale(cairo, scaleX, scaleY);
                } else {
                    Cairo.cairo_translate(cairo, destX - srcX, destY - srcY);
                }
                int filter = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        filter = 1;
                        break;
                    }
                    case 0: {
                        filter = 3;
                        break;
                    }
                    case 1: {
                        filter = 0;
                        break;
                    }
                    case 2: {
                        filter = 2;
                    }
                }
                int pattern = Cairo.cairo_pattern_create_for_surface(srcImage.surface);
                if (pattern == 0) {
                    SWT.error(2);
                }
                if (srcWidth != destWidth || srcHeight != destHeight) {
                    int version = Cairo.cairo_version();
                    if (version >= Cairo.CAIRO_VERSION_ENCODE(1, 4, 0) && version < Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        int surface = Cairo.cairo_image_surface_create(0, imgWidth * 3, imgHeight * 3);
                        int cr = Cairo.cairo_create(surface);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_scale(cr, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, -imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, -imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, -imgHeight * 3);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, -imgHeight * 3);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_scale(cr, 1.0, -1.0);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_scale(cr, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, -imgHeight);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, -imgHeight * 3);
                        Cairo.cairo_paint(cr);
                        Cairo.cairo_destroy(cr);
                        int newPattern = Cairo.cairo_pattern_create_for_surface(surface);
                        Cairo.cairo_surface_destroy(surface);
                        if (newPattern == 0) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_destroy(pattern);
                        pattern = newPattern;
                        Cairo.cairo_pattern_set_extend(pattern, 3);
                        double[] matrix = new double[6];
                        Cairo.cairo_matrix_init_translate(matrix, imgWidth, imgHeight);
                        Cairo.cairo_pattern_set_matrix(pattern, matrix);
                    } else if (version >= Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        Cairo.cairo_pattern_set_extend(pattern, 3);
                    }
                }
                Cairo.cairo_pattern_set_filter(pattern, filter);
                Cairo.cairo_set_source(cairo, pattern);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(cairo, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(cairo);
                }
                Cairo.cairo_restore(cairo);
                Cairo.cairo_pattern_destroy(pattern);
            }
            return;
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.gdk_draw_drawable(this.data.drawable, this.handle, srcImage.pixmap, srcX, srcY, destX, destY, destWidth, destHeight);
        } else {
            if (this.device.useXRender) {
                this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, 0, -1);
                return;
            }
            int pixbuf = this.scale(srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destWidth, destHeight);
            if (pixbuf != 0) {
                OS.gdk_pixbuf_render_to_drawable(pixbuf, this.data.drawable, this.handle, 0, 0, destX, destY, destWidth, destHeight, 1, 0, 0);
                OS.g_object_unref(pixbuf);
            }
        }
    }

    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, srcImage.mask, 2);
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new(0, true, 8, srcWidth, srcHeight);
        if (pixbuf == 0) {
            return;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, srcImage.pixmap, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] line = new byte[stride];
        byte alpha = (byte)srcImage.alpha;
        byte[] alphaData = srcImage.alphaData;
        for (int y = 0; y < srcHeight; ++y) {
            int alphaIndex = (y + srcY) * imgWidth + srcX;
            OS.memmove(line, pixels + y * stride, stride);
            for (int x = 3; x < stride; x += 4) {
                line[x] = alphaData == null ? alpha : alphaData[alphaIndex++];
            }
            OS.memmove(pixels + y * stride, line, stride);
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
            OS.g_object_unref(pixbuf);
            if (scaledPixbuf == 0) {
                return;
            }
            pixbuf = scaledPixbuf;
        }
        OS.gdk_draw_pixbuf(this.data.drawable, this.handle, pixbuf, 0, 0, destX, destY, destWidth, destHeight, 1, 0, 0);
        OS.g_object_unref(pixbuf);
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int drawable = this.data.drawable;
        int colorPixmap = srcImage.pixmap;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        int maskPixmap = srcImage.mask;
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, maskPixmap, 4);
        } else {
            int newHeight;
            int newWidth;
            int bytesPerLine;
            byte[] maskData;
            int mask;
            if (srcWidth != destWidth || srcHeight != destHeight) {
                int pixbuf = OS.gdk_pixbuf_new(0, true, 8, srcWidth, srcHeight);
                if (pixbuf != 0) {
                    int colormap = OS.gdk_colormap_get_system();
                    OS.gdk_pixbuf_get_from_drawable(pixbuf, colorPixmap, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
                    int maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, srcWidth, srcHeight);
                    if (maskPixbuf != 0) {
                        OS.gdk_pixbuf_get_from_drawable(maskPixbuf, maskPixmap, 0, srcX, srcY, 0, 0, srcWidth, srcHeight);
                        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                        byte[] line = new byte[stride];
                        int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                        int maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                        byte[] maskLine = new byte[maskStride];
                        for (int y = 0; y < srcHeight; ++y) {
                            int offset = pixels + y * stride;
                            OS.memmove(line, offset, stride);
                            int maskOffset = maskPixels + y * maskStride;
                            OS.memmove(maskLine, maskOffset, maskStride);
                            for (int x = 0; x < srcWidth; ++x) {
                                if (maskLine[x * 3] != 0) continue;
                                line[x * 4 + 3] = 0;
                            }
                            OS.memmove(offset, line, stride);
                        }
                        OS.g_object_unref(maskPixbuf);
                        int scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
                        if (scaledPixbuf != 0) {
                            int[] colorBuffer = new int[1];
                            int[] maskBuffer = new int[1];
                            OS.gdk_pixbuf_render_pixmap_and_mask(scaledPixbuf, colorBuffer, maskBuffer, 128);
                            colorPixmap = colorBuffer[0];
                            maskPixmap = maskBuffer[0];
                            OS.g_object_unref(scaledPixbuf);
                        }
                    }
                    OS.g_object_unref(pixbuf);
                }
                srcX = 0;
                srcY = 0;
                srcWidth = destWidth;
                srcHeight = destHeight;
            }
            if (this.data.clipRgn != 0 && (mask = OS.gdk_bitmap_create_from_data(0, maskData = new byte[(bytesPerLine = ((newWidth = srcX + srcWidth) + 7) / 8) * (newHeight = srcY + srcHeight)], newWidth, newHeight)) != 0) {
                int gc = OS.gdk_gc_new(mask);
                OS.gdk_region_offset(this.data.clipRgn, -destX + srcX, -destY + srcY);
                OS.gdk_gc_set_clip_region(gc, this.data.clipRgn);
                OS.gdk_region_offset(this.data.clipRgn, destX - srcX, destY - srcY);
                GdkColor color = new GdkColor();
                color.pixel = 1;
                OS.gdk_gc_set_foreground(gc, color);
                OS.gdk_draw_rectangle(mask, gc, 1, 0, 0, newWidth, newHeight);
                OS.gdk_gc_set_function(gc, 4);
                OS.gdk_draw_drawable(mask, gc, maskPixmap, 0, 0, 0, 0, newWidth, newHeight);
                OS.g_object_unref(gc);
                if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
                    OS.g_object_unref(maskPixmap);
                }
                maskPixmap = mask;
            }
            GdkGCValues values = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, values);
            OS.gdk_gc_set_clip_mask(this.handle, maskPixmap);
            OS.gdk_gc_set_clip_origin(this.handle, destX - srcX, destY - srcY);
            OS.gdk_draw_drawable(drawable, this.handle, colorPixmap, srcX, srcY, destX, destY, srcWidth, srcHeight);
            OS.gdk_gc_set_values(this.handle, values, 6272);
            if (this.data.clipRgn != 0) {
                OS.gdk_gc_set_clip_region(this.handle, this.data.clipRgn);
            }
        }
        if (colorPixmap != 0 && srcImage.pixmap != colorPixmap) {
            OS.g_object_unref(colorPixmap);
        }
        if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
            OS.g_object_unref(maskPixmap);
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    void drawImageXRender(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int maskPixmap, int maskType) {
        int srcPict;
        int translateX = 0;
        int translateY = 0;
        int drawable = this.data.drawable;
        if (this.data.image == null && !this.data.realDrawable) {
            int[] x = new int[1];
            int[] y = new int[1];
            int[] real_drawable = new int[1];
            OS.gdk_window_get_internal_paint_info(drawable, real_drawable, x, y);
            drawable = real_drawable[0];
            translateX = -x[0];
            translateY = -y[0];
        }
        int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        int maskPict = 0;
        if (maskPixmap != 0) {
            int attribCount = 0;
            XRenderPictureAttributes attrib = null;
            if (srcImage.alpha != -1) {
                attribCount = 1;
                attrib = new XRenderPictureAttributes();
                attrib.repeat = true;
            }
            if ((maskPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(maskPixmap), OS.XRenderFindStandardFormat(xDisplay, maskType), attribCount, attrib)) == 0) {
                SWT.error(2);
            }
        }
        int format = OS.XRenderFindVisualFormat(xDisplay, OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()));
        int destPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(drawable), format, 0, null);
        if (destPict == 0) {
            SWT.error(2);
        }
        if ((srcPict = OS.XRenderCreatePicture(xDisplay, OS.gdk_x11_drawable_get_xid(srcImage.pixmap), format, 0, null)) == 0) {
            SWT.error(2);
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int[] transform = new int[]{(int)((float)srcWidth / (float)destWidth * 65536.0f), 0, 0, 0, (int)((float)srcHeight / (float)destHeight * 65536.0f), 0, 0, 0, 65536};
            OS.XRenderSetPictureTransform(xDisplay, srcPict, transform);
            if (maskPict != 0) {
                OS.XRenderSetPictureTransform(xDisplay, maskPict, transform);
            }
            srcX = (int)((float)srcX * ((float)destWidth / (float)srcWidth));
            srcY = (int)((float)srcY * ((float)destHeight / (float)srcHeight));
        }
        int clipping = this.data.clipRgn;
        if (this.data.damageRgn != 0) {
            if (clipping == 0) {
                clipping = this.data.damageRgn;
            } else {
                clipping = OS.gdk_region_new();
                OS.gdk_region_union(clipping, this.data.clipRgn);
                OS.gdk_region_intersect(clipping, this.data.damageRgn);
            }
        }
        if (clipping != 0) {
            int[] nRects = new int[1];
            int[] rects = new int[1];
            OS.gdk_region_get_rectangles(clipping, rects, nRects);
            GdkRectangle rect = new GdkRectangle();
            short[] xRects = new short[nRects[0] * 4];
            int i = 0;
            int j = 0;
            while (i < nRects[0]) {
                OS.memmove(rect, rects[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
                xRects[j] = (short)(translateX + rect.x);
                xRects[j + 1] = (short)(translateY + rect.y);
                xRects[j + 2] = (short)rect.width;
                xRects[j + 3] = (short)rect.height;
                ++i;
                j += 4;
            }
            OS.XRenderSetPictureClipRectangles(xDisplay, destPict, 0, 0, xRects, nRects[0]);
            if (clipping != this.data.clipRgn && clipping != this.data.damageRgn) {
                OS.gdk_region_destroy(clipping);
            }
            if (rects[0] != 0) {
                OS.g_free(rects[0]);
            }
        }
        OS.XRenderComposite(xDisplay, maskPict != 0 ? 3 : 1, srcPict, maskPict, destPict, srcX, srcY, srcX, srcY, destX + translateX, destY + translateY, destWidth, destHeight);
        OS.XRenderFreePicture(xDisplay, destPict);
        OS.XRenderFreePicture(xDisplay, srcPict);
        if (maskPict != 0) {
            OS.XRenderFreePicture(xDisplay, maskPict);
        }
    }

    int scale(int src, int srcX, int srcY, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        int pixbuf = OS.gdk_pixbuf_new(0, false, 8, srcWidth, srcHeight);
        if (pixbuf == 0) {
            return 0;
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, src, colormap, srcX, srcY, 0, 0, srcWidth, srcHeight);
        int scaledPixbuf = OS.gdk_pixbuf_scale_simple(pixbuf, destWidth, destHeight, 2);
        OS.g_object_unref(pixbuf);
        return scaledPixbuf;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            Cairo.cairo_move_to(cairo, (double)x1 + xOffset, (double)y1 + yOffset);
            Cairo.cairo_line_to(cairo, (double)x2 + xOffset, (double)y2 + yOffset);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_line(this.data.drawable, this.handle, x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, x, y, width, height, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(761);
        int cairo = this.data.cairo;
        Cairo.cairo_save(cairo);
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_translate(cairo, xOffset, yOffset);
        int copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_stroke(cairo);
        Cairo.cairo_restore(cairo);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_rectangle(cairo, x, y, 1.0, 1.0);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_point(this.data.drawable, this.handle, x, y);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 0, pointArray, pointArray.length / 2);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, false);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_lines(this.data.drawable, this.handle, pointArray, pointArray.length / 2);
    }

    void drawPolyline(int cairo, int[] pointArray, boolean close) {
        int count = pointArray.length / 2;
        if (count == 0) {
            return;
        }
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_move_to(cairo, (double)pointArray[0] + xOffset, (double)pointArray[1] + yOffset);
        int i = 1;
        int j = 2;
        while (i < count) {
            Cairo.cairo_line_to(cairo, (double)pointArray[j] + xOffset, (double)pointArray[j + 1] + yOffset);
            ++i;
            j += 2;
        }
        if (close) {
            Cairo.cairo_close_path(cairo);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 0, x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (naw == 0 || nah == 0) {
                Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
            } else {
                float naw2 = (float)naw / 2.0f;
                float nah2 = (float)nah / 2.0f;
                float fw = (float)nw / naw2;
                float fh = (float)nh / nah2;
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)nx + xOffset, (double)ny + yOffset);
                Cairo.cairo_scale(cairo, naw2, nah2);
                Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(cairo);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, naw, nah, 5760, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny + nh - nah, naw, nah, 11520, 5760);
                OS.gdk_draw_line(drawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
            } else {
                OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, naw, nh, 5760, 11520);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.gdk_draw_arc(drawable, this.handle, 0, nx + nw - naw, ny, naw, nh, 17280, 11520);
                OS.gdk_draw_line(drawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, nw, nah, 0, 11520);
            OS.gdk_draw_line(drawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny + nh - nah, nw, nah, 11520, 11520);
            OS.gdk_draw_line(drawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
        } else {
            OS.gdk_draw_arc(drawable, this.handle, 0, nx, ny, nw, nh, 0, 23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int cairo = this.data.cairo;
        this.setString(string, flags);
        if (cairo != 0) {
            this.checkGC(4);
            if ((flags & 1) == 0) {
                this.checkGC(2);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_rectangle(cairo, x, y, this.data.stringWidth, this.data.stringHeight);
                Cairo.cairo_fill(cairo);
            }
            this.checkGC(1);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_save(cairo);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_scale(cairo, -1.0, 1.0);
                Cairo.cairo_translate(cairo, -2 * x - this.data.stringWidth, 0.0);
            }
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.data.layout);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_new_path(cairo);
            return;
        }
        this.checkGC(261);
        GdkColor background = null;
        if ((flags & 1) == 0) {
            background = this.data.background;
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors(this.data.drawable, this.handle, x, y, this.data.layout, null, background);
        } else {
            int gdkGC;
            int pixmap;
            int layout = this.data.layout;
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            if ((pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), this.data.stringWidth, this.data.stringHeight, -1)) == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0) {
                SWT.error(2);
            }
            GdkColor black = new GdkColor();
            OS.gdk_gc_set_foreground(gdkGC, black);
            OS.gdk_draw_rectangle(pixmap, gdkGC, 1, 0, 0, this.data.stringWidth, this.data.stringHeight);
            OS.gdk_gc_set_foreground(gdkGC, this.data.foreground);
            OS.gdk_draw_layout_with_colors(pixmap, gdkGC, 0, 0, layout, null, background);
            OS.g_object_unref(gdkGC);
            OS.gdk_draw_drawable(this.data.drawable, this.handle, pixmap, 0, 0, x, y, this.data.stringWidth, this.data.stringHeight);
            OS.g_object_unref(pixmap);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, 0.0, 0.0);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int pattern = vertical ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 0.0, (float)fromRGB.red / 255.0f, (float)fromRGB.green / 255.0f, (float)fromRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 1.0, (float)toRGB.red / 255.0f, (float)toRGB.green / 255.0f, (float)toRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, x, y);
            Cairo.cairo_scale(cairo, width, height);
            Cairo.cairo_rectangle(cairo, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(cairo, pattern);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, x, y, width, height, 0, 23040);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        int cairo = this.data.cairo;
        int copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_fill(cairo);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 1, pointArray, pointArray.length / 2);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_rectangle(cairo, x, y, width, height);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 1, x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0) {
            if (naw == 0 || nah == 0) {
                Cairo.cairo_rectangle(cairo, x, y, width, height);
            } else {
                float naw2 = (float)naw / 2.0f;
                float nah2 = (float)nah / 2.0f;
                float fw = (float)nw / naw2;
                float fh = (float)nh / nah2;
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, nx, ny);
                Cairo.cairo_scale(cairo, naw2, nah2);
                Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(cairo);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int drawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, naw, nah, 5760, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx, ny + nah2, naw2, nh - nah2 * 2);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + nw - naw2, ny + nah2, naw2, nh - nah2 * 2);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny + nh - nah, naw, nah, 11520, 5760);
            } else {
                OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, naw, nh, 5760, 11520);
                OS.gdk_draw_rectangle(drawable, this.handle, 1, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.gdk_draw_arc(drawable, this.handle, 1, nx + nw - naw, ny, naw, nh, 17280, 11520);
            }
        } else if (nh > nah) {
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, nw, nah, 0, 11520);
            OS.gdk_draw_rectangle(drawable, this.handle, 1, nx, ny + nah2, nw, nh - nah2 * 2);
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny + nh - nah, nw, nah, 11520, 11520);
        } else {
            OS.gdk_draw_arc(drawable, this.handle, 1, nx, ny, nw, nh, 0, 23040);
        }
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        int mnemonic = -1;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == -1) {
                mnemonic = j;
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.cairo != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int antialias = Cairo.cairo_get_antialias(this.data.cairo);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.gtk_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        this.getSize(w, h);
        width = w[0];
        height = h[0];
        int cairo = this.data.cairo;
        int clipRgn = this.data.clipRgn;
        int damageRgn = this.data.damageRgn;
        if (clipRgn != 0 || damageRgn != 0 || cairo != 0) {
            int rgn = OS.gdk_region_new();
            GdkRectangle rect = new GdkRectangle();
            rect.width = width;
            rect.height = height;
            OS.gdk_region_union_with_rect(rgn, rect);
            if (damageRgn != 0) {
                OS.gdk_region_intersect(rgn, damageRgn);
            }
            if (clipRgn != 0) {
                if (this.data.clippingTransform != null) {
                    clipRgn = this.convertRgn(clipRgn, this.data.clippingTransform);
                    OS.gdk_region_intersect(rgn, clipRgn);
                    OS.gdk_region_destroy(clipRgn);
                } else {
                    OS.gdk_region_intersect(rgn, clipRgn);
                }
            }
            if (cairo != 0) {
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                Cairo.cairo_matrix_invert(matrix);
                clipRgn = this.convertRgn(rgn, matrix);
                OS.gdk_region_destroy(rgn);
                rgn = clipRgn;
            }
            OS.gdk_region_get_clipbox(rgn, rect);
            OS.gdk_region_destroy(rgn);
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        int clipping = region.handle;
        OS.gdk_region_subtract(clipping, clipping);
        int cairo = this.data.cairo;
        int clipRgn = this.data.clipRgn;
        if (clipRgn == 0) {
            GdkRectangle rect = new GdkRectangle();
            int[] width = new int[1];
            int[] height = new int[1];
            this.getSize(width, height);
            rect.width = width[0];
            rect.height = height[0];
            OS.gdk_region_union_with_rect(clipping, rect);
        } else if (this.data.clippingTransform != null) {
            int rgn = this.convertRgn(clipRgn, this.data.clippingTransform);
            OS.gdk_region_union(clipping, rgn);
            OS.gdk_region_destroy(rgn);
        } else {
            OS.gdk_region_union(clipping, clipRgn);
        }
        if (this.data.damageRgn != 0) {
            OS.gdk_region_intersect(clipping, this.data.damageRgn);
        }
        if (cairo != 0) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            Cairo.cairo_matrix_invert(matrix);
            int rgn = this.convertRgn(clipping, matrix);
            OS.gdk_region_subtract(clipping, clipping);
            OS.gdk_region_union(clipping, rgn);
            OS.gdk_region_destroy(rgn);
        }
    }

    public int getFillRule() {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) == 0) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(cairo) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.context == 0) {
            this.createLayout();
        }
        this.checkGC(4);
        Font font = this.data.font;
        int context = this.data.context;
        int lang = OS.pango_context_get_language(context);
        int metrics = OS.pango_context_get_metrics(context, font.handle, lang);
        FontMetrics fm = new FontMetrics();
        fm.ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(metrics));
        fm.descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(metrics));
        fm.averageCharWidth = OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(metrics));
        fm.height = fm.ascent + fm.descent;
        OS.pango_font_metrics_unref(metrics);
        return fm;
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.gtk_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        for (int i = 0; i < lineDashes.length; ++i) {
            lineDashes[i] = (int)this.data.lineDashes[i];
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    void getSize(int[] width, int[] height) {
        if (this.data.width != -1 && this.data.height != -1) {
            width[0] = this.data.width;
            height[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                width[0] = OS.gdk_window_get_width(this.data.drawable);
                height[0] = OS.gdk_window_get_height(this.data.drawable);
            } else {
                OS.gdk_drawable_get_size(this.data.drawable, width, height);
            }
            return;
        }
        if (OS.USE_CAIRO) {
            int surface = Cairo.cairo_get_target(this.handle);
            switch (Cairo.cairo_surface_get_type(surface)) {
                case 0: {
                    width[0] = Cairo.cairo_image_surface_get_width(surface);
                    height[0] = Cairo.cairo_image_surface_get_height(surface);
                    break;
                }
                case 3: {
                    width[0] = Cairo.cairo_xlib_surface_get_width(surface);
                    height[0] = Cairo.cairo_xlib_surface_get_height(surface);
                }
            }
        }
    }

    public int getTextAntialias() {
        int options;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int antialias = 0;
        if (this.data.context != 0 && (options = OS.pango_cairo_context_get_font_options(this.data.context)) != 0) {
            antialias = Cairo.cairo_font_options_get_antialias(options);
        }
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_get_matrix(cairo, transform.handle);
            double[] identity = this.identity();
            Cairo.cairo_matrix_invert(identity);
            Cairo.cairo_matrix_multiply(transform.handle, transform.handle, identity);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    double[] identity() {
        double[] identity = new double[6];
        if ((this.data.style & 0x8000000) != 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            this.getSize(w, h);
            Cairo.cairo_matrix_init(identity, -1.0, 0.0, 0.0, 1.0, w[0], 0.0);
        } else {
            Cairo.cairo_matrix_init_identity(identity);
        }
        if (this.data.identity != null) {
            Cairo.cairo_matrix_multiply(identity, this.data.identity, identity);
        }
        return identity;
    }

    void init(Drawable drawable, GCData data, int gdkGC) {
        int cairo;
        Image image;
        if (data.foreground != null) {
            data.state &= 0xFFFFFFFE;
        }
        if (data.background != null) {
            data.state &= 0xFFFFFEFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = gdkGC;
        if (OS.USE_CAIRO) {
            cairo = data.cairo = this.handle;
            Cairo.cairo_set_fill_rule(cairo, 1);
            data.state &= 0xFFFFFD80;
        } else if (OS.INIT_CAIRO) {
            this.initCairo();
        }
        this.setClipping(data.clipRgn);
        if ((data.style & 0x8000000) != 0) {
            this.initCairo();
            cairo = data.cairo;
            Cairo.cairo_set_matrix(cairo, this.identity());
        }
    }

    void initCairo() {
        this.data.device.checkCairo();
        int cairo = this.data.cairo;
        if (cairo != 0) {
            return;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 17, 0)) {
            int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            int xDrawable = 0;
            int translateX = 0;
            int translateY = 0;
            int drawable = this.data.drawable;
            if (this.data.image != null) {
                xDrawable = OS.GDK_PIXMAP_XID(drawable);
            } else if (!this.data.realDrawable) {
                int[] x = new int[1];
                int[] y = new int[1];
                int[] real_drawable = new int[1];
                OS.gdk_window_get_internal_paint_info(drawable, real_drawable, x, y);
                xDrawable = OS.gdk_x11_drawable_get_xid(real_drawable[0]);
                translateX = -x[0];
                translateY = -y[0];
            }
            int width = 0;
            int height = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                width = OS.gdk_window_get_width(this.data.drawable);
                height = OS.gdk_window_get_height(this.data.drawable);
            } else {
                int[] w = new int[1];
                int[] h = new int[1];
                OS.gdk_drawable_get_size(drawable, w, h);
                width = w[0];
                height = h[0];
            }
            int surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
            if (surface == 0) {
                SWT.error(2);
            }
            Cairo.cairo_surface_set_device_offset(surface, translateX, translateY);
            this.data.cairo = cairo = Cairo.cairo_create(surface);
            Cairo.cairo_surface_destroy(surface);
        } else {
            this.data.cairo = cairo = OS.gdk_cairo_create(this.data.drawable);
        }
        if (cairo == 0) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(cairo, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    void computeStringSize() {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_pixel_size(this.data.layout, width, height);
        this.data.stringHeight = height[0];
        this.data.stringWidth = width[0];
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(double[] matrix) {
        if (matrix == null) {
            return true;
        }
        return matrix[0] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0 && matrix[3] == 1.0 && matrix[4] == 0.0 && matrix[5] == 0.0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((this.data.style & 0x8000000) != 0 || OS.USE_CAIRO || OS.INIT_CAIRO) {
            if (!advanced) {
                this.setAlpha(255);
                this.setAntialias(-1);
                this.setBackgroundPattern(null);
                this.setClipping(0);
                this.setForegroundPattern(null);
                this.setInterpolation(-1);
                this.setTextAntialias(-1);
                this.setTransform(null);
            }
            return;
        }
        if (advanced && this.data.cairo != 0) {
            return;
        }
        if (advanced) {
            try {
                this.initCairo();
            }
            catch (SWTException e) {}
        } else {
            if (!this.data.disposeCairo) {
                return;
            }
            int cairo = this.data.cairo;
            if (cairo != 0) {
                Cairo.cairo_destroy(cairo);
            }
            this.data.cairo = 0;
            this.data.interpolation = -1;
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && (alpha & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int cairo = this.data.cairo;
        Cairo.cairo_set_antialias(cairo, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(int cairo, Font font) {
        if (font == null || font.isDisposed()) {
            return;
        }
        GC.setCairoFont(cairo, font.handle);
    }

    static void setCairoFont(int cairo, int font) {
        int family = OS.pango_font_description_get_family(font);
        int length = OS.strlen(family);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, family, length);
        double height = OS.PANGO_PIXELS(OS.pango_font_description_get_size(font)) * 96 / 72;
        int pangoStyle = OS.pango_font_description_get_style(font);
        int pangoWeight = OS.pango_font_description_get_weight(font);
        int slant = 0;
        if (pangoStyle == 2) {
            slant = 1;
        }
        if (pangoStyle == 1) {
            slant = 2;
        }
        int weight = 0;
        if (pangoWeight == 700) {
            weight = 1;
        }
        Cairo.cairo_select_font_face(cairo, buffer, slant, weight);
        Cairo.cairo_set_font_size(cairo, height);
    }

    static void setCairoRegion(int cairo, int rgn) {
        OS.gdk_cairo_region(cairo, rgn);
    }

    static void setCairoPatternColor(int pattern, int offset, Color c, int alpha) {
        GdkColor color = c.handle;
        double aa = (double)(alpha & 0xFF) / 255.0;
        double red = (double)(color.red & 0xFFFF) / 65535.0;
        double green = (double)(color.green & 0xFFFF) / 65535.0;
        double blue = (double)(color.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(pattern, offset, red, green, blue, aa);
    }

    void setCairoClip(int damageRgn, int clipRgn) {
        int cairo = this.data.cairo;
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0) && this.data.drawable != 0 && !OS.GTK3) {
            OS.gdk_cairo_reset_clip(cairo, this.data.drawable);
        } else {
            Cairo.cairo_reset_clip(cairo);
        }
        if (damageRgn != 0) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            double[] identity = new double[6];
            Cairo.cairo_matrix_init_identity(identity);
            Cairo.cairo_set_matrix(cairo, identity);
            GC.setCairoRegion(cairo, damageRgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_matrix(cairo, matrix);
        }
        if (clipRgn != 0) {
            GC.setCairoRegion(cairo, clipRgn);
            Cairo.cairo_clip(cairo);
        }
    }

    void setClipping(int clipRgn) {
        int cairo = this.data.cairo;
        if (clipRgn == 0) {
            if (this.data.clipRgn != 0) {
                OS.gdk_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            if (cairo != 0) {
                this.data.clippingTransform = null;
                this.setCairoClip(this.data.damageRgn, 0);
            } else {
                int clipping = this.data.damageRgn != 0 ? this.data.damageRgn : 0;
                OS.gdk_gc_set_clip_region(this.handle, clipping);
            }
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.gdk_region_new();
            }
            OS.gdk_region_subtract(this.data.clipRgn, this.data.clipRgn);
            OS.gdk_region_union(this.data.clipRgn, clipRgn);
            if (cairo != 0) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(cairo, this.data.clippingTransform);
                this.setCairoClip(this.data.damageRgn, clipRgn);
            } else {
                int clipping = clipRgn;
                if (this.data.damageRgn != 0) {
                    clipping = OS.gdk_region_new();
                    OS.gdk_region_union(clipping, clipRgn);
                    OS.gdk_region_intersect(clipping, this.data.damageRgn);
                }
                OS.gdk_gc_set_clip_region(this.handle, clipping);
                if (clipping != clipRgn) {
                    OS.gdk_region_destroy(clipping);
                }
            }
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        int clipRgn = OS.gdk_region_new();
        OS.gdk_region_union_with_rect(clipRgn, rect);
        this.setClipping(clipRgn);
        OS.gdk_region_destroy(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0);
        if (path != null) {
            this.initCairo();
            int cairo = this.data.cairo;
            int copy = Cairo.cairo_copy_path(path.handle);
            if (copy == 0) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(cairo, copy);
            Cairo.cairo_path_destroy(copy);
            Cairo.cairo_clip(cairo);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int cairo_mode = 1;
        switch (rule) {
            case 2: {
                cairo_mode = 0;
                break;
            }
            case 1: {
                cairo_mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_set_fill_rule(cairo, cairo_mode);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && interpolation == -1) {
            return;
        }
        switch (interpolation) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = interpolation;
    }

    public void setLineAttributes(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x240;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x20;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x10;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            for (int i = 0; i < dashes.length; ++i) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (changed || lineDashes[i] == dash) continue;
                changed = true;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        this.initCairo();
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            int i;
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            for (i = 0; i < dashes.length; ++i) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (changed || lineDashes[i] == (float)dash) continue;
                changed = true;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            for (i = 0; i < dashes.length; ++i) {
                this.data.lineDashes[i] = dashes[i];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFFDBF;
    }

    void setString(String string, int flags) {
        byte[] buffer;
        int mnemonic;
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int length = string.length();
        int layout = this.data.layout;
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        if ((flags & 8) != 0 && (mnemonic = this.fixMnemonic(text)) != -1) {
            char[] text1 = new char[mnemonic - 1];
            System.arraycopy(text, 0, text1, 0, text1.length);
            byte[] buffer1 = Converter.wcsToMbcs(null, text1, false);
            char[] text2 = new char[text.length - mnemonic];
            System.arraycopy(text, mnemonic - 1, text2, 0, text2.length);
            byte[] buffer2 = Converter.wcsToMbcs(null, text2, false);
            buffer = new byte[buffer1.length + buffer2.length];
            System.arraycopy(buffer1, 0, buffer, 0, buffer1.length);
            System.arraycopy(buffer2, 0, buffer, buffer1.length, buffer2.length);
            int attr_list = OS.pango_attr_list_new();
            int attr = OS.pango_attr_underline_new(3);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, attr, PangoAttribute.sizeof);
            attribute.start_index = buffer1.length;
            attribute.end_index = buffer1.length + 1;
            OS.memmove(attr, attribute, PangoAttribute.sizeof);
            OS.pango_attr_list_insert(attr_list, attr);
            OS.pango_layout_set_attributes(layout, attr_list);
            OS.pango_attr_list_unref(attr_list);
        } else {
            buffer = Converter.wcsToMbcs(null, text, false);
            OS.pango_layout_set_attributes(layout, 0);
        }
        OS.pango_layout_set_text(layout, buffer, buffer.length);
        OS.pango_layout_set_single_paragraph_mode(layout, (flags & 2) == 0);
        OS.pango_layout_set_tabs(layout, (flags & 4) != 0 ? 0 : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int options = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(options, mode);
        if (this.data.context == 0) {
            this.createLayout();
        }
        OS.pango_cairo_context_set_font_options(this.data.context, options);
        Cairo.cairo_font_options_destroy(options);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && transform == null) {
            return;
        }
        this.initCairo();
        int cairo = this.data.cairo;
        double[] identity = this.identity();
        if (transform != null) {
            Cairo.cairo_matrix_multiply(identity, transform.handle, identity);
        }
        Cairo.cairo_set_matrix(cairo, identity);
        this.data.state &= 0xFFFFFDFF;
    }

    @Deprecated
    public void setXORMode(boolean xor) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) != 0 && Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 10, 0)) {
            Cairo.cairo_set_operator(this.handle, xor ? 23 : 2);
        }
        if (!OS.USE_CAIRO) {
            OS.gdk_gc_set_function(this.handle, xor ? 2 : 0);
        }
        this.data.xorMode = xor;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setString(string, flags);
        this.checkGC(4);
        if (this.data.stringWidth == -1) {
            this.computeStringSize();
        }
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

