/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    long layoutText = 0L;
    long layoutMessage = 0L;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
        parent.addToolTip(this);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] polyline;
        int t;
        long screen = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(this.handle);
        int monitorNumber = OS.gdk_screen_get_monitor_at_window(screen, this.gtk_widget_get_window(this.handle));
        GdkRectangle dest = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
        Point point = this.getSize(dest.width / 4);
        int w = point.x;
        int h = point.y;
        point = this.getLocation();
        int x = point.x;
        int y = point.y;
        OS.gtk_window_resize(this.handle, w, h + 20);
        boolean bl = this.spikeAbove = dest.height >= y + h + 20;
        if (dest.width >= x + w) {
            if (dest.height >= y + h + 20) {
                t = 20;
                polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, 16, t, 16, 0, 35, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
                this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, 16, t, 16, 1, 35, t, w - 6, 0 + t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[12] = w - 36;
                    polyline[14] = w - 16;
                    polyline[16] = w - 15;
                    this.borderPolygon[12] = w - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = w - 16;
                }
                OS.gtk_window_move(this.handle, Math.max(0, x - 17), y);
            } else {
                polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, 35, h, 16, h + 20, 16, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, 35, h - 1, 17, h + 20 - 2, 17, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[42] = polyline[44] = w - 16;
                    polyline[46] = w - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = w - 17;
                    this.borderPolygon[40] = w - 35;
                }
                OS.gtk_window_move(this.handle, Math.max(0, x - 17), y - h - 20);
            }
        } else if (dest.height >= y + h + 20) {
            t = 20;
            polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, w - 35, t, w - 16, 0, w - 16, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
            this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, w - 35, t, w - 17, 2, w - 17, t, w - 6, t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[14] = 16;
                polyline[12] = 16;
                polyline[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            OS.gtk_window_move(this.handle, Math.min(dest.width - w, x - w + 17), y);
        } else {
            polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, w - 16, h, w - 16, h + 20, w - 35, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, w - 17, h - 1, w - 17, h + 20 - 2, w - 36, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[42] = 35;
                polyline[46] = 16;
                polyline[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            OS.gtk_window_move(this.handle, Math.min(dest.width - w, x - w + 17), y - h - 20);
        }
        OS.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(polyline);
        if (OS.GTK3) {
            OS.gtk_widget_shape_combine_region(this.handle, region.handle);
        } else {
            long window = this.gtk_widget_get_window(this.handle);
            OS.gdk_window_shape_combine_region(window, region.handle, 0, 0);
        }
        region.dispose();
    }

    void createHandle(int index) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            this.handle = OS.gtk_window_new(1);
            Color background = this.display.getSystemColor(29);
            if (OS.GTK3) {
                GdkColor color = background.handle;
                GdkRGBA rgba = new GdkRGBA();
                rgba.alpha = 1.0;
                rgba.red = (float)(color.red & 0xFFFF) / 65535.0f;
                rgba.green = (float)(color.green & 0xFFFF) / 65535.0f;
                rgba.blue = (float)(color.blue & 0xFFFF) / 65535.0f;
                OS.gtk_widget_override_background_color(this.handle, 0, rgba);
            } else {
                OS.gtk_widget_modify_bg(this.handle, 0, background.handle);
            }
            OS.gtk_widget_set_app_paintable(this.handle, true);
            OS.gtk_window_set_type_hint(this.handle, 10);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            this.state |= 8;
            this.handle = OS.gtk_tooltips_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            OS.gtk_tooltips_force_window(this.handle);
            OS.g_object_ref(this.handle);
            OS.g_object_ref_sink(this.handle);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    void deregister() {
        long tipWindow;
        super.deregister();
        if ((this.style & 0x1000) == 0 && OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0L) {
            this.display.removeWidget(tipWindow);
        }
    }

    void destroyWidget() {
        long topHandle = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (topHandle != 0L && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                OS.gtk_widget_destroy(topHandle);
            } else {
                OS.g_object_unref(topHandle);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int x = this.x;
        int y = this.y;
        if (this.item != null) {
            long itemHandle = this.item.handle;
            GdkRectangle area = new GdkRectangle();
            OS.gtk_status_icon_get_geometry(itemHandle, 0L, area, 0L);
            x = area.x + area.width / 2;
            y = area.y + area.height / 2;
        }
        if (x == -1 || y == -1) {
            int[] px = new int[1];
            int[] py = new int[1];
            this.gdk_window_get_device_position(0L, px, py, null);
            x = px[0];
            y = py[0];
        }
        return new Point(x, y);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textWidth = w[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageWidth = w[0];
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != 0L && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, (maxWidth - textTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textHeight = h[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, (maxWidth - messageTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageHeight = h[0];
        }
        int height = 20 + messageHeight;
        if (this.layoutText != 0L) {
            height += Math.max(16, textHeight) + 10;
        }
        return new Point(width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return this.gtk_widget_get_visible(this.handle);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            long tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            return OS.GTK_WIDGET_VISIBLE(tipWindow);
        }
        return false;
    }

    long gtk_button_press_event(long widget, long event) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0L;
    }

    void drawTooltip(long cr) {
        long window = this.gtk_widget_get_window(this.handle);
        int x = 10;
        int y = 10;
        if (OS.USE_CAIRO) {
            int count;
            long cairo;
            long l = cairo = cr != 0L ? cr : OS.gdk_cairo_create(window);
            if (cairo == 0L) {
                this.error(2);
            }
            if ((count = this.borderPolygon.length / 2) != 0) {
                Cairo.cairo_set_line_width(cairo, 1.0);
                Cairo.cairo_move_to(cairo, this.borderPolygon[0], this.borderPolygon[1]);
                int i = 1;
                int j = 2;
                while (i < count) {
                    Cairo.cairo_line_to(cairo, (double)this.borderPolygon[j] + 0.5, (double)this.borderPolygon[j + 1] + 0.5);
                    ++i;
                    j += 2;
                }
                Cairo.cairo_close_path(cairo);
                Cairo.cairo_stroke(cairo);
            }
            if (this.spikeAbove) {
                y += 20;
            }
            if (this.layoutText != 0L) {
                byte[] buffer = null;
                int id = this.style & 0xB;
                switch (id) {
                    case 1: {
                        buffer = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                        break;
                    }
                    case 2: {
                        buffer = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                        break;
                    }
                    case 8: {
                        buffer = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                    }
                }
                if (buffer != null) {
                    long pixbuf;
                    long icon_set = OS.gtk_icon_factory_lookup_default(buffer);
                    if (OS.GTK3) {
                        pixbuf = OS.gtk_icon_set_render_icon_pixbuf(icon_set, OS.gtk_widget_get_style_context(this.handle), 1);
                    } else {
                        long style = OS.gtk_widget_get_default_style();
                        pixbuf = OS.gtk_icon_set_render_icon(icon_set, style, 0, 0, 1, 0L, 0L);
                    }
                    OS.gdk_cairo_set_source_pixbuf(cairo, pixbuf, x, y);
                    Cairo.cairo_paint(cairo);
                    OS.g_object_unref(pixbuf);
                    x += 16;
                }
                int[] w = new int[1];
                int[] h = new int[1];
                Color foreground = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(cairo, foreground.handle);
                Cairo.cairo_move_to(cairo, x += 4, y);
                OS.pango_cairo_show_layout(cairo, this.layoutText);
                OS.pango_layout_get_pixel_size(this.layoutText, w, h);
                y += 10 + Math.max(16, h[0]);
            }
            if (this.layoutMessage != 0L) {
                x = 14;
                Color foreground = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(cairo, foreground.handle);
                Cairo.cairo_move_to(cairo, x, y);
                OS.pango_cairo_show_layout(cairo, this.layoutMessage);
            }
            if (cairo != cr) {
                Cairo.cairo_destroy(cairo);
            }
            return;
        }
        long gdkGC = OS.gdk_gc_new(window);
        OS.gdk_draw_polygon(window, gdkGC, 0, this.borderPolygon, this.borderPolygon.length / 2);
        if (this.spikeAbove) {
            y += 20;
        }
        if (this.layoutText != 0L) {
            byte[] buffer = null;
            int id = this.style & 0xB;
            switch (id) {
                case 1: {
                    buffer = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                    break;
                }
                case 2: {
                    buffer = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                    break;
                }
                case 8: {
                    buffer = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                }
            }
            if (buffer != null) {
                long style = OS.gtk_widget_get_default_style();
                long pixbuf = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default(buffer), style, 0, 0, 1, 0L, 0L);
                OS.gdk_draw_pixbuf(window, gdkGC, pixbuf, 0, 0, x, y, 16, 16, 1, 0, 0);
                OS.g_object_unref(pixbuf);
                x += 16;
            }
            Color foreground = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(gdkGC, foreground.handle);
            OS.gdk_draw_layout(window, gdkGC, x += 4, y, this.layoutText);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            y += 10 + Math.max(16, h[0]);
        }
        if (this.layoutMessage != 0L) {
            x = 14;
            Color foreground = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(gdkGC, foreground.handle);
            OS.gdk_draw_layout(window, gdkGC, x, y, this.layoutMessage);
        }
        OS.g_object_unref(gdkGC);
    }

    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(cairo);
        return 0L;
    }

    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(0L);
        return 0L;
    }

    long gtk_size_allocate(long widget, long allocation) {
        Point point = this.getLocation();
        int x = point.x;
        int y = point.y;
        long screen = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(widget);
        int monitorNumber = OS.gdk_screen_get_monitor_at_window(screen, this.gtk_widget_get_window(widget));
        GdkRectangle dest = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
        GtkAllocation widgetAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(widget, widgetAllocation);
        int w = widgetAllocation.width;
        int h = widgetAllocation.height;
        if (dest.height < y + h) {
            y -= h;
        }
        if (dest.width < x + w) {
            x -= w;
        }
        OS.gtk_window_move(widget, x, y);
        return 0L;
    }

    void hookEvents() {
        long tipWindow;
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.gtk_widget_add_events(this.handle, 256);
            OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.getClosure(2), false);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0L) {
            OS.g_signal_connect_closure(tipWindow, OS.size_allocate, this.display.getClosure(47), false);
            OS.gtk_widget_add_events(tipWindow, 256);
            OS.g_signal_connect_closure(tipWindow, OS.button_press_event, this.display.getClosure(2), false);
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        long tipWindow;
        super.register();
        if ((this.style & 0x1000) == 0 && OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0L) {
            this.display.addWidget(tipWindow, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autohide = autoHide;
    }

    public void setLocation(int x, int y) {
        long tipWindow;
        this.checkWidget();
        this.x = x;
        this.y = y;
        if ((this.style & 0x1000) != 0) {
            if (this.gtk_widget_get_visible(this.handle)) {
                this.configure();
            }
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0) && this.gtk_widget_get_visible(tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle))) {
            OS.gtk_window_move(tipWindow, x, y);
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.message.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
            this.layoutMessage = OS.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (this.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.text.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, this.text, true);
            this.layoutText = OS.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            long boldAttr = OS.pango_attr_weight_new(700);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, boldAttr, (long)PangoAttribute.sizeof);
            attribute.start_index = 0;
            attribute.end_index = buffer.length;
            OS.memmove(boldAttr, attribute, (long)PangoAttribute.sizeof);
            long attrList = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(attrList, boldAttr);
            OS.pango_layout_set_attributes(this.layoutText, attrList);
            OS.pango_attr_list_unref(attrList);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (this.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (visible) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                OS.gtk_widget_show(this.handle);
            } else {
                long vboxHandle = this.parent.vboxHandle;
                StringBuffer string = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    string.append("\n\n");
                }
                string.append(this.message);
                byte[] buffer = Converter.wcsToMbcs(null, string.toString(), true);
                if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                    OS.gtk_widget_set_tooltip_text(vboxHandle, buffer);
                } else {
                    OS.gtk_tooltips_set_tip(this.handle, vboxHandle, buffer, null);
                    long data = OS.gtk_tooltips_data_get(vboxHandle);
                    OS.GTK_TOOLTIPS_SET_ACTIVE(this.handle, data);
                    OS.gtk_tooltips_set_tip(this.handle, vboxHandle, buffer, null);
                }
            }
            if (this.autohide) {
                this.timerId = OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else {
            long vboxHandle = this.parent.vboxHandle;
            byte[] buffer = Converter.wcsToMbcs(null, "", true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_widget_set_tooltip_text(vboxHandle, buffer);
            } else {
                OS.gtk_tooltips_set_tip(this.handle, vboxHandle, buffer, null);
            }
        }
    }

    long timerProc(long widget) {
        if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            long tipWindow = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            OS.gtk_widget_hide(tipWindow);
        }
        return 0L;
    }
}

