/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIFocusManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MozillaDelegate {
    Browser browser;
    Vector childWindows = new Vector(9);
    static int MozillaProc;
    static Callback SubclassProc;
    static Boolean IsXULRunner24;
    static final String LIB_XPCOM = "xpcom.dll";
    static final String LIB_XUL = "xul.dll";

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int handle) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(handle);
    }

    static String getCacheParentPath() {
        TCHAR buffer = new TCHAR(0, 260);
        if (OS.SHGetFolderPath(0, 28, 0, 0, buffer) == 0) {
            return buffer.toString(0, buffer.strlen()) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{"mozjs.dll", LIB_XUL};
    }

    static String getJSLibraryName_Pre10() {
        return "js3250.dll";
    }

    static String getLibraryName(String mozillaPath) {
        if (IsXULRunner24 == null) {
            IsXULRunner24 = new File(mozillaPath, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
        }
        return IsXULRunner24 != false ? LIB_XUL : LIB_XPCOM;
    }

    static String getProfilePath() {
        TCHAR buffer = new TCHAR(0, 260);
        String baseDir = OS.SHGetFolderPath(0, 26, 0, 0, buffer) == 0 ? buffer.toString(0, buffer.strlen()) : System.getProperty("user.home");
        return baseDir + Mozilla.SEPARATOR_OS + "Mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String mozillaPath, boolean isGlued) {
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        char[] chars = new char[buffer.length];
        int charCount = OS.MultiByteToWideChar(0, 1, buffer, buffer.length, chars, chars.length);
        if (charCount == chars.length) {
            return chars;
        }
        char[] result = new char[charCount];
        System.arraycopy(chars, 0, result, 0, charCount);
        return result;
    }

    static boolean needsSpinup() {
        return false;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int byteCount = chars.length * 2 + (terminate ? 1 : 0);
        byte[] bytes = new byte[byteCount];
        byteCount = OS.WideCharToMultiByte(0, 0, chars, chars.length, bytes, byteCount, null, null);
        if (terminate) {
            ++byteCount;
        } else if (bytes.length != byteCount) {
            byte[] result = new byte[byteCount];
            System.arraycopy(bytes, 0, result, 0, byteCount);
            bytes = result;
        }
        return bytes;
    }

    static int windowProc(int hwnd, int msg, int wParam, int lParam) {
        switch (msg) {
            case 296: {
                return 0;
            }
            case 20: {
                RECT rect = new RECT();
                OS.GetClientRect(hwnd, rect);
                OS.FillRect(wParam, rect, OS.GetSysColorBrush(OS.COLOR_WINDOW));
            }
        }
        return OS.CallWindowProc(MozillaProc, hwnd, msg, wParam, lParam);
    }

    void addWindowSubclass() {
        int hwndChild = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc == null) {
            SubclassProc = new Callback(MozillaDelegate.class, "windowProc", 4);
            MozillaProc = OS.GetWindowLongPtr(hwndChild, -4);
        }
        OS.SetWindowLongPtr(hwndChild, -4, SubclassProc.getAddress());
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        return baseWindow.Create();
    }

    int getHandle() {
        return this.browser.handle;
    }

    Point getNativeSize(int width, int height) {
        return new Point(width, height);
    }

    int getSiteWindow() {
        if (!MozillaVersion.CheckVersion(5) || Mozilla.IsGettingSiteWindow) {
            return this.getHandle();
        }
        Composite child = new Composite(this.browser, 0);
        this.childWindows.addElement(child);
        return child.handle;
    }

    void handleFocus() {
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
        if (MozillaVersion.CheckVersion(5)) {
            this.browser.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: 
                        case 4: {
                            event.doit = false;
                            break;
                        }
                        case 8: 
                        case 16: {
                            int[] result = new int[1];
                            int rc = XPCOM.NS_GetServiceManager(result);
                            if (rc != 0) {
                                Mozilla.error(rc);
                            }
                            if (result[0] == 0) {
                                Mozilla.error(-2147467262);
                            }
                            nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                            result[0] = 0;
                            byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/focus-manager;1", true);
                            rc = serviceManager.GetServiceByContractID(aContractID, IIDStore.GetIID(nsIFocusManager.class, 5), result);
                            serviceManager.Release();
                            if (rc != 0 || result[0] == 0) break;
                            nsIFocusManager focusManager = new nsIFocusManager(result[0]);
                            result[0] = 0;
                            rc = focusManager.GetFocusedElement(result);
                            focusManager.Release();
                            boolean bl = event.doit = result[0] == 0;
                            if (rc != 0 || result[0] == 0) break;
                            new nsISupports(result[0]).Release();
                            break;
                        }
                    }
                }
            });
            this.browser.addLocationListener(new LocationAdapter(){

                public void changing(LocationEvent event) {
                    Enumeration enumeration = MozillaDelegate.this.childWindows.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Composite)enumeration.nextElement()).dispose();
                    }
                    MozillaDelegate.this.childWindows.clear();
                }
            });
        }
    }

    void onDispose(int embedHandle) {
        if (SubclassProc == null) {
            return;
        }
        int hwndChild = OS.GetWindow(this.browser.handle, 5);
        OS.SetWindowLongPtr(hwndChild, -4, MozillaProc);
        this.childWindows = null;
        this.browser = null;
    }

    void removeWindowSubclass() {
        int hwndChild = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc != null) {
            OS.SetWindowLongPtr(hwndChild, -4, MozillaProc);
        }
    }

    boolean sendTraverse() {
        return false;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

