/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

class Relation {
    Accessible accessible;
    COMObject objIAccessibleRelation;
    int refCount;
    int type;
    Accessible[] targets;
    static final String[] relationTypeString = new String[]{"controlledBy", "controllerFor", "describedBy", "descriptionFor", "embeddedBy", "embeds", "flowsFrom", "flowsTo", "labelFor", "labelledBy", "memberOf", "nodeChildOf", "parentWindowOf", "popupFor", "subwindowOf"};
    static final String[] localizedRelationTypeString = new String[]{SWT.getMessage("SWT_Controlled_By"), SWT.getMessage("SWT_Controller_For"), SWT.getMessage("SWT_Described_By"), SWT.getMessage("SWT_Description_For"), SWT.getMessage("SWT_Embedded_By"), SWT.getMessage("SWT_Embeds"), SWT.getMessage("SWT_Flows_From"), SWT.getMessage("SWT_Flows_To"), SWT.getMessage("SWT_Label_For"), SWT.getMessage("SWT_Labelled_By"), SWT.getMessage("SWT_Member_Of"), SWT.getMessage("SWT_Node_Child_Of"), SWT.getMessage("SWT_Parent_Window_Of"), SWT.getMessage("SWT_Popup_For"), SWT.getMessage("SWT_Subwindow_Of")};

    Relation(Accessible accessible, int type) {
        this.accessible = accessible;
        this.type = type;
        this.targets = new Accessible[0];
        this.AddRef();
    }

    long getAddress() {
        if (this.objIAccessibleRelation == null) {
            this.createIAccessibleRelation();
        }
        return this.objIAccessibleRelation.getAddress();
    }

    void createIAccessibleRelation() {
        this.objIAccessibleRelation = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 2, 3}){

            public long method0(long[] args) {
                return Relation.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Relation.this.AddRef();
            }

            public long method2(long[] args) {
                return Relation.this.Release();
            }

            public long method3(long[] args) {
                return Relation.this.get_relationType(args[0]);
            }

            public long method4(long[] args) {
                return Relation.this.get_localizedRelationType(args[0]);
            }

            public long method5(long[] args) {
                return Relation.this.get_nTargets(args[0]);
            }

            public long method6(long[] args) {
                return Relation.this.get_target((int)args[0], args[1]);
            }

            public long method7(long[] args) {
                return Relation.this.get_targets((int)args[0], args[1], args[2]);
            }
        };
    }

    int QueryInterface(long iid, long ppvObject) {
        GUID guid = new GUID();
        COM.MoveMemory(guid, iid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIAccessibleRelation)) {
            COM.MoveMemory(ppvObject, new long[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessibleRelation != null) {
                this.objIAccessibleRelation.dispose();
            }
            this.objIAccessibleRelation = null;
        }
        return this.refCount;
    }

    int get_relationType(long pbstrRelationType) {
        this.setString(pbstrRelationType, relationTypeString[this.type]);
        return 0;
    }

    int get_localizedRelationType(long pbstrLocalizedRelationType) {
        this.setString(pbstrLocalizedRelationType, localizedRelationTypeString[this.type]);
        return 0;
    }

    int get_nTargets(long pNTargets) {
        COM.MoveMemory(pNTargets, new int[]{this.targets.length}, 4);
        return 0;
    }

    int get_target(int targetIndex, long ppTarget) {
        if (targetIndex < 0 || targetIndex >= this.targets.length) {
            return -2147024809;
        }
        Accessible target = this.targets[targetIndex];
        target.AddRef();
        COM.MoveMemory(ppTarget, new long[]{target.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_targets(int maxTargets, long ppTargets, long pNTargets) {
        int count = Math.min(this.targets.length, maxTargets);
        for (int i = 0; i < count; ++i) {
            Accessible target = this.targets[i];
            target.AddRef();
            COM.MoveMemory(ppTargets + (long)(i * OS.PTR_SIZEOF), new long[]{target.getAddress()}, OS.PTR_SIZEOF);
        }
        COM.MoveMemory(pNTargets, new int[]{count}, 4);
        return 0;
    }

    void addTarget(Accessible target) {
        if (this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, newTargets, 0, this.targets.length);
        newTargets[this.targets.length] = target;
        this.targets = newTargets;
    }

    boolean containsTarget(Accessible target) {
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != target) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible target) {
        if (!this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length - 1];
        int j = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] == target) continue;
            newTargets[j++] = this.targets[i];
        }
        this.targets = newTargets;
    }

    boolean hasTargets() {
        return this.targets.length > 0;
    }

    void setString(long psz, String string) {
        char[] data = (string + "\u0000").toCharArray();
        long ptr = COM.SysAllocString(data);
        COM.MoveMemory(psz, new long[]{ptr}, OS.PTR_SIZEOF);
    }
}

