/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common;

import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class CheckReport {
    private ReportType type = ReportType.INFO;
    private long timeMs;
    private IInstallableUnit iu;
    private String checkerId;
    private String checkResult;
    private String additionalData;
    private String iuVersion;
    private String artifactKey;

    public CheckReport(Class<?> checkerId, IInstallableUnit iu) {
        this.iu = iu;
        this.checkerId = checkerId.getName();
        if (iu != null) {
            this.iuVersion = iu.getVersion().getOriginal();
        }
        this.setTimeMs(System.currentTimeMillis());
    }

    public CheckReport(Class<?> checkerId, IInstallableUnit iu, IArtifactKey artifactKey) {
        this(checkerId, iu);
        this.artifactKey = artifactKey.toExternalForm();
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public ReportType getType() {
        return this.type;
    }

    public IInstallableUnit getIU() {
        return this.iu;
    }

    public String getCheckerId() {
        return this.checkerId;
    }

    public void setCheckResult(String result) {
        this.checkResult = result;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public long getTimeMs() {
        return this.timeMs;
    }

    public void setTimeMs(long timeMs) {
        this.timeMs = timeMs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type).append(": ").append(this.getVersionedId());
        if (this.artifactKey != null) {
            builder.append(" (").append(this.artifactKey).append(")");
        }
        builder.append(" <- ").append(this.checkerId).append(": ").append(this.checkResult).append(' ').append(this.additionalData).append(" " + this.timeMs);
        return builder.toString();
    }

    public String getVersionedId() {
        return String.valueOf(this.iu.getId()) + (this.iuVersion != null ? "_" + this.iuVersion : "");
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public String getIuVersion() {
        return this.iuVersion;
    }

    public String getArtifactKey() {
        return this.artifactKey;
    }
}

