/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common;

import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.CheckerRegistry;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IInstalationUnitChecker;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

public class P2RepositoryAnalyser {
    public void analyse(P2RepositoryDescription repoDescr, CheckerRegistry registry, Consumer<? super CheckReport> consumer) {
        this.analyse(repoDescr, registry, consumer, false);
    }

    public void analyse(P2RepositoryDescription repoDescr, CheckerRegistry registry, Consumer<? super CheckReport> consumer, boolean split) {
        Stream<Object> parallelStream;
        IQueryResult<IInstallableUnit> iQueryResult = this.collectInstalableUnits(repoDescr);
        if (split) {
            parallelStream = StreamSupport.stream(iQueryResult.spliterator(), true);
        } else {
            Set set = iQueryResult.toUnmodifiableSet();
            parallelStream = set.parallelStream();
        }
        parallelStream.forEach(iu -> {
            registry.getCheckers().stream().forEach(checker -> checker.check(consumer, repoDescr, (IInstallableUnit)iu));
            iu.getArtifacts().parallelStream().forEach(artifactKey -> {
                File artifactFile = repoDescr.getArtifactRepository().getArtifactFile(artifactKey);
                if (artifactFile != null) {
                    registry.getArtifactCheckers().stream().forEach(artChecker -> artChecker.check(consumer, repoDescr, (IInstallableUnit)iu, (IArtifactKey)artifactKey, artifactFile));
                } else {
                    CheckReport report = new CheckReport(SystemCheck.class, (IInstallableUnit)iu, (IArtifactKey)artifactKey);
                    report.setType(ReportType.INFO);
                    report.setCheckResult("Unable to load artifact file.");
                    report.setAdditionalData(String.valueOf(artifactKey.toExternalForm()) + " from " + repoDescr.getArtifactRepository().getLocation());
                    consumer.accept(report);
                }
            });
        });
    }

    protected IQueryResult<IInstallableUnit> collectInstalableUnits(P2RepositoryDescription descr) {
        return descr.getMetadataRepository().query(QueryUtil.createIUAnyQuery(), null);
    }

    class SystemCheck
    implements IInstalationUnitChecker {
        SystemCheck() {
        }

        @Override
        public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu) {
        }
    }
}

