/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.io.File;
import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IArtifactChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.CheckerUtils;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class BREEChecker
implements IArtifactChecker {
    private static final String EXCLUDE_PROPERTY = "breeExceptions";

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu, IArtifactKey artKey, File child) {
        CheckReport report = this.createReport(iu, artKey);
        String excludes = CheckerUtils.loadCheckerProperties(BREEChecker.class).getProperty(EXCLUDE_PROPERTY, null);
        if (excludes != null && excludes.contains(iu.getId())) {
            return;
        }
        try {
            String bree = IUUtil.getBundleManifestEntry(child, "Bundle-RequiredExecutionEnvironment");
            boolean needsBree = this.needsBree(child);
            if (bree != null && bree.length() > 0) {
                if (needsBree) {
                    report.setType(ReportType.INFO);
                    report.setCheckResult(bree);
                } else {
                    report.setType(ReportType.WARNING);
                    report.setCheckResult("None Java with BREE: " + bree);
                }
            } else if (needsBree) {
                report.setType(ReportType.BAD_GUY);
                report.setCheckResult("Java without BREE");
            }
        }
        catch (SecurityException e) {
            report.setType(ReportType.NOT_IN_TRAIN);
            report.setCheckResult("Invalid jar: " + child.getName());
        }
        if (report.getCheckResult() != null) {
            report.setTimeMs(System.currentTimeMillis());
            consumer.accept(report);
        }
    }

    private boolean needsBree(File child) {
        return this.exportsPackages(child);
    }

    private boolean exportsPackages(File child) {
        String entry = IUUtil.getBundleManifestEntry(child, "Export-Package");
        return entry != null && !entry.isEmpty();
    }
}

