/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.io.File;
import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IArtifactChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.CheckerUtils;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class EclipseSourceChecker
implements IArtifactChecker {
    private static final String ES_EXCEPTIONS_PROPERTY = "esExceptions";
    private static final String PROPERTY_ECLIPSE_SOURCEREFERENCES = "Eclipse-SourceReferences";
    private String excludes;

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu, IArtifactKey artKey, File child) {
        CheckReport report = this.createReport(iu, artKey);
        String es = IUUtil.getBundleManifestEntry(child, PROPERTY_ECLIPSE_SOURCEREFERENCES);
        if (!iu.getId().endsWith(".source")) {
            String excludedIus = this.getExcludes();
            if (!excludedIus.isEmpty() && excludedIus.contains(iu.getId())) {
                report.setCheckResult("Skipped");
            } else {
                if (es != null && es.contains("project=")) {
                    report.setCheckResult("Contains Eclipse-SourceReferences and project=");
                }
                if (es != null && es.length() > 0) {
                    report.setCheckResult("Contains Eclipse-SourceReferences");
                } else {
                    report.setCheckResult("Missing Eclipse-SourceReferences");
                    report.setType(ReportType.WARNING);
                }
            }
        }
        consumer.accept(report);
    }

    private String getExcludes() {
        if (this.excludes == null) {
            this.excludes = CheckerUtils.loadCheckerProperties(EclipseSourceChecker.class).getProperty(ES_EXCEPTIONS_PROPERTY, "");
        }
        return this.excludes;
    }
}

