/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IInstalationUnitChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class FeatureNameChecker
implements IInstalationUnitChecker {
    public static final int MAX_CRITERIA = 100;

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu) {
        if (IUUtil.isFeature(iu)) {
            String featureName = iu.getId().substring(0, iu.getId().length() - ".feature.group".length());
            String line = String.valueOf(featureName) + "_" + iu.getVersion();
            CheckReport checkReport = new CheckReport(FeatureNameChecker.class, iu);
            checkReport.setCheckResult(String.valueOf(line.length()));
            if (line.length() > 100) {
                checkReport.setCheckResult(line);
                checkReport.setType(ReportType.BAD_GUY);
                checkReport.setAdditionalData("Feature name is to long (max=100)");
            }
            checkReport.setTimeMs(System.currentTimeMillis());
            consumer.accept(checkReport);
        }
    }
}

