/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IInstalationUnitChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class IUNameChecker
implements IInstalationUnitChecker {
    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu) {
        CheckReport report = this.createReport(iu);
        String iuName = iu.getProperty("org.eclipse.equinox.p2.name", null);
        report.setCheckResult("Probably correct name");
        report.setAdditionalData(iuName);
        if (!IUUtil.isCategory(iu) && !IUUtil.isSpecial(iu) && !IUUtil.isFragment(iu) && (iuName == null || iuName.startsWith("%") || iuName.startsWith("Feature-") || iuName.startsWith("Bundle-") || iuName.startsWith("feature") || iuName.startsWith("plugin") || iuName.startsWith("Plugin.name") || iuName.startsWith("fragment.") || iuName.startsWith("Eclipse.org") || iuName.startsWith("bundle"))) {
            report.setCheckResult("Missing or (probably) incorrect name");
            report.setType(ReportType.NOT_IN_TRAIN);
        }
        consumer.accept(report);
    }
}

