/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IArtifactChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.CheckerUtils;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class LayoutChecker
implements IArtifactChecker {
    private static final String KEY_DFT_BIN_JAR = "default.binary.jar";
    private static final String KEY_DFT_SRC_JAR = "default.source.jar";
    private static final String KEY_DFT_FEATURE = "default.feature";

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu, IArtifactKey artifactKey, File file) {
        CheckReport report = this.createReport(iu, artifactKey);
        Properties checkerProperties = CheckerUtils.loadCheckerProperties(LayoutChecker.class);
        boolean sourceIU = this.isSourceIUName(iu.getId());
        String property = IUUtil.isFeature(iu) ? KEY_DFT_FEATURE : (sourceIU ? KEY_DFT_SRC_JAR : KEY_DFT_BIN_JAR);
        String expectedEntries = checkerProperties.getProperty(property, null);
        expectedEntries = sourceIU ? MessageFormat.format(expectedEntries, iu.getId().substring(0, iu.getId().lastIndexOf(46))) : MessageFormat.format(expectedEntries, iu.getId());
        this.processArchive(file, Arrays.asList(expectedEntries.split(",")), report);
        consumer.accept(report);
    }

    private boolean isSourceIUName(String id) {
        return id.endsWith(".source") || id.endsWith(".infopop") || id.endsWith(".doc.user") || id.endsWith(".doc") || id.endsWith(".doc.isv") || id.endsWith(".doc.dev") || id.endsWith(".doc.api") || id.endsWith("standard.schemas") || id.endsWith(".branding");
    }

    private void processArchive(File file, List<String> expected, CheckReport report) {
        block18: {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file, 1);
                    HashMap<String, String> found = new HashMap<String, String>();
                    for (String string : expected) {
                        found.put(string, null);
                    }
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        if (!found.values().contains(null)) break;
                        ZipEntry entry2 = e.nextElement();
                        String name = entry2.getName();
                        for (String expectedEntry : found.keySet()) {
                            try {
                                if (!name.matches(expectedEntry.trim())) continue;
                                found.put(expectedEntry, name);
                            }
                            catch (PatternSyntaxException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    String missing = found.entrySet().stream().filter(entry -> entry.getValue() == null).map(entry -> (String)entry.getKey()).collect(Collectors.joining(", "));
                    if (!missing.isEmpty()) {
                        report.setType(ReportType.NOT_IN_TRAIN);
                        report.setCheckResult("Missing " + missing + " in file: " + file.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zip == null) break block18;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

