/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IInstalationUnitChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.CheckerUtils;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;

public class LicenseConsistencyChecker
implements IInstalationUnitChecker {
    private License standardLicense2010;
    private License standardLicense2011;
    private License standardLicense2014;

    public LicenseConsistencyChecker() {
        Properties properties = CheckerUtils.loadCheckerProperties(LicenseConsistencyChecker.class);
        String body2014 = properties.getProperty("license2014");
        String body2011 = properties.getProperty("license2011");
        String body2010 = properties.getProperty("license2010");
        this.standardLicense2014 = new License(null, body2014, null);
        this.standardLicense2011 = new License(null, body2011, null);
        this.standardLicense2010 = new License(null, body2010, null);
    }

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit feature) {
        if (IUUtil.isFeature(feature)) {
            Collection licenses = feature.getLicenses(null);
            CheckReport report = new CheckReport(LicenseConsistencyChecker.class, feature);
            this.checkLicense(licenses, report);
            report.setTimeMs(System.currentTimeMillis());
            consumer.accept(report);
        }
    }

    private void checkLicense(Collection<ILicense> licenses, CheckReport report) {
        if (licenses.isEmpty()) {
            report.setType(ReportType.NOT_IN_TRAIN);
            report.setCheckResult("Licence is missing");
        } else if (licenses.size() != 1) {
            report.setType(ReportType.BAD_GUY);
            report.setCheckResult("Extra Licence found");
        } else {
            ILicense featureLicense = licenses.iterator().next();
            if (this.standardLicense2010.getUUID().equals(featureLicense.getUUID())) {
                report.setType(ReportType.BAD_GUY);
                report.setCheckResult("Old 2010 License");
            } else if (this.standardLicense2011.getUUID().equals(featureLicense.getUUID())) {
                report.setType(ReportType.BAD_GUY);
                report.setCheckResult("Old 2011 License");
            } else if (this.standardLicense2014.getUUID().equals(featureLicense.getUUID())) {
                report.setType(ReportType.INFO);
                report.setCheckResult("New 2014 License");
            } else {
                String featureLicenseText = featureLicense.getBody();
                report.setType(ReportType.NOT_IN_TRAIN);
                if (featureLicenseText == null || featureLicenseText.length() == 0) {
                    report.setCheckResult("Missing license content");
                } else {
                    report.setCheckResult("Not an eclipse license");
                }
            }
        }
    }
}

