/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.checker.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.IInstalationUnitChecker;
import org.eclipse.cbi.p2repo.analyzers.common.utils.CheckerUtils;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class ProviderNameChecker
implements IInstalationUnitChecker {
    private static final String OLD_PROVIDER_NAME = "Eclipse.org";
    private Set<String> knownProviderNames = null;

    @Override
    public void check(Consumer<? super CheckReport> consumer, P2RepositoryDescription descr, IInstallableUnit iu) {
        if (!(IUUtil.isCategory(iu) || IUUtil.isSpecial(iu) || IUUtil.isFragment(iu))) {
            CheckReport checkReport = new CheckReport(ProviderNameChecker.class, iu);
            String providerName = iu.getProperty("org.eclipse.equinox.p2.provider", null);
            checkReport.setCheckResult(providerName);
            if (providerName == null) {
                this.missingProviderName(checkReport);
            } else if (providerName.startsWith("%") || providerName.equals("Eclipse") || providerName.startsWith("eclipse.org") || providerName.equals("unknown") || providerName.startsWith("Engineering") || providerName.contains("org.eclipse.jwt") || providerName.contains("www.example.org") || providerName.contains("www.eclipse.org") || providerName.contains("Provider") || providerName.contains("provider") || providerName.startsWith("Bundle-") || providerName.startsWith("bund") || providerName.startsWith("Eclispe")) {
                this.incorrectProviderName(checkReport);
            } else if (providerName.startsWith("Eclipse.org - ")) {
                this.correctProviderName(checkReport);
            } else if (this.getKnownProviderNames().contains(providerName)) {
                this.correctProviderName(checkReport);
            } else if (OLD_PROVIDER_NAME.equals(providerName)) {
                this.oldProviderName(checkReport);
            } else if (providerName.startsWith("Eclipse")) {
                this.unknownProviderName(checkReport);
            } else if (iu.getId().startsWith("org.eclipse")) {
                this.suspectProviderName(checkReport);
            } else {
                this.unknownProviderName(checkReport);
            }
            checkReport.setCheckResult(providerName);
            consumer.accept(checkReport);
        }
    }

    private void missingProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.NOT_IN_TRAIN);
        checkReport.setAdditionalData("Provider name is missing.");
    }

    public Set<String> getKnownProviderNames() {
        if (this.knownProviderNames == null) {
            HashSet<String> temp = new HashSet<String>();
            String expectedProviderNames = CheckerUtils.loadCheckerProperties(ProviderNameChecker.class).getProperty("expectedProviderNames", "");
            if (!expectedProviderNames.isEmpty()) {
                String[] names;
                String[] stringArray = names = expectedProviderNames.split(",");
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    temp.add(string);
                    ++n2;
                }
            }
            this.knownProviderNames = Collections.unmodifiableSet(temp);
        }
        return this.knownProviderNames;
    }

    private void suspectProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.NOT_IN_TRAIN);
        checkReport.setAdditionalData("Suspect provider name.");
    }

    private void incorrectProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.NOT_IN_TRAIN);
        checkReport.setAdditionalData("Incorrect provider name.");
    }

    private void unknownProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.BAD_GUY);
        checkReport.setAdditionalData("Unknown provider name.");
    }

    private void oldProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.WARNING);
        checkReport.setAdditionalData("Old provider name.");
    }

    private void correctProviderName(CheckReport checkReport) {
        checkReport.setType(ReportType.INFO);
        checkReport.setAdditionalData("Correct provider name.");
    }
}

