/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.reporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.ICheckReportDumper;

public class CheckReportsManager
implements Consumer<CheckReport> {
    private ConcurrentLinkedQueue<CheckReport> queue = new ConcurrentLinkedQueue();

    public int reported() {
        return this.queue.size();
    }

    public ConcurrentLinkedQueue<CheckReport> getReports() {
        return this.queue;
    }

    public void dumpReports() {
        ArrayList<CheckReport> sorted = new ArrayList<CheckReport>(this.getReports());
        Collections.sort(sorted, (r1, r2) -> r2.getType().compareTo(r1.getType()));
        sorted.forEach(report -> new ConsoleReporter().dumpReport((CheckReport)report));
    }

    @Override
    public void accept(CheckReport report) {
        this.queue.add(report);
    }

    public Stream<CheckReport> reportsByCheckerId(String checkerId) {
        Stream stream = this.getReports().parallelStream();
        Stream<CheckReport> featureReports = stream.filter(report -> report.getCheckerId().equals(checkerId));
        return featureReports;
    }

    class ConsoleReporter
    implements ICheckReportDumper {
        ConsoleReporter() {
        }

        @Override
        public void dumpReport(CheckReport report) {
            if (report == null) {
                System.out.println("ERROR: Null report");
            } else if (report.getType() != ReportType.INFO) {
                System.out.println(report.toString());
            }
        }
    }
}

