/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.internal.Activator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class IUUtil {
    public static boolean isFeature(IInstallableUnit iu) {
        return iu.getArtifacts().stream().anyMatch(art -> "org.eclipse.update.feature".equals(art.getClassifier()));
    }

    public static P2RepositoryDescription createRepositoryDescription(URI p2RepoURL) throws ProvisionException, OperationCanceledException {
        P2RepositoryDescription description = new P2RepositoryDescription();
        description.setRepoURL(p2RepoURL);
        IMetadataRepository repo = Activator.getMetadataRepositoryManager().loadRepository(p2RepoURL, null);
        if (repo == null) {
            IUUtil.handleFatalError("no metadata repository found at " + p2RepoURL.toString());
        }
        description.setMetadataRepository(repo);
        IArtifactRepository artRepo = Activator.getArtifactRepositoryManager().loadRepository(p2RepoURL, null);
        if (artRepo == null) {
            IUUtil.handleFatalError("no artifact repository found at " + p2RepoURL.toString());
        }
        description.setArtifactRepository((IFileArtifactRepository)artRepo);
        return description;
    }

    private static void handleFatalError(String string) {
        System.err.println(string);
    }

    public static boolean isSpecial(IInstallableUnit iu) {
        String iuId = iu.getId();
        boolean isSpecial = iuId.startsWith("a.jre") || iuId.startsWith("config.a.jre") || iuId.endsWith("_root") || iuId.contains(".executable.") || iuId.contains("configuration_root") || iuId.contains("executable_root") || iuId.startsWith("toolingorg.eclipse") || iuId.startsWith("tooling.");
        return isSpecial;
    }

    public static String getBundleManifestEntry(File jarfile, String key) {
        return IUUtil.workWithJarEntry(jarfile, "META-INF/MANIFEST.MF", (jarEntry, stream) -> {
            String result = null;
            if (jarEntry != null) {
                try {
                    Map attributes = ManifestElement.parseBundleManifest((InputStream)stream, null);
                    result = (String)attributes.get(key);
                }
                catch (IOException | BundleException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        });
    }

    public static <T> T workWithJarEntry(File file, String entryName, BiFunction<JarEntry, InputStream, T> function) {
        T result;
        block24: {
            JarFile jar = null;
            InputStream entryStream = null;
            result = null;
            try {
                try {
                    jar = new JarFile(file, false, 1);
                    JarEntry jarEntry = jar.getJarEntry(entryName);
                    if (jarEntry != null) {
                        entryStream = jar.getInputStream(jarEntry);
                    }
                    result = function.apply(jarEntry, entryStream);
                }
                catch (IOException e) {
                    IUUtil.handleFatalError(e.getMessage());
                    if (entryStream != null) {
                        try {
                            entryStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (entryStream != null) {
                    try {
                        entryStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (entryStream != null) {
                try {
                    entryStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static Properties getEclipseInf(File jarfile) {
        return IUUtil.workWithJarEntry(jarfile, "META-INF/eclipse.inf", (jarEntry, entryStream) -> {
            Properties properties = new Properties();
            if (jarEntry != null) {
                try {
                    properties.load((InputStream)entryStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return properties;
        });
    }

    public static JarEntry getJarEntry(File file, String entryName) {
        return IUUtil.workWithJarEntry(file, entryName, (jarEntry, entryStream) -> jarEntry);
    }

    public static String versionedId(IInstallableUnit iu) {
        return String.valueOf(iu.getId()) + (iu.getVersion() != null ? "_" + iu.getVersion().getOriginal() : "");
    }

    public static boolean isCategory(IInstallableUnit iu) {
        return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
    }

    public static boolean isFragment(IInstallableUnit iu) {
        return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
    }
}

