/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.common.utils;

import java.net.URI;
import java.util.stream.Stream;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryAnalyser;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.checker.CheckerRegistry;
import org.eclipse.cbi.p2repo.analyzers.common.checker.impl.FeatureNameChecker;
import org.eclipse.cbi.p2repo.analyzers.common.checker.impl.LicenseConsistencyChecker;
import org.eclipse.cbi.p2repo.analyzers.common.checker.impl.ProviderNameChecker;
import org.eclipse.cbi.p2repo.analyzers.common.checker.impl.SignatureChecker;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.CheckReportsManager;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRunner {
    static final String JENKINS_XTEXT = "https://xtext-builds.itemis.de/jenkins/job/xtext-master/ws/xtext.p2.repository/";
    static final String EMF = "file:///Users/dhuebner/Downloads/emf-xsd-Update-N201505120526";
    static final String XTEXT = "file:///Users/dhuebner/Downloads/tmf-xtext-Update-2.8.3M7-2";
    static final String LUNA = "file:///Users/dhuebner/git/org.eclipse.xtext-master/releng/org.eclipse.xtext.releng/distrobuilder/luna/local-repo/final";
    private static CheckReportsManager reporter = null;

    @BeforeClass
    public static synchronized void setupOnce() throws ProvisionException, OperationCanceledException {
        if (reporter == null) {
            long start;
            long time = start = System.currentTimeMillis();
            P2RepositoryDescription p2Repo = IUUtil.createRepositoryDescription(URI.create(JENKINS_XTEXT));
            System.out.println("create repo descr " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
            CheckerRegistry registry = new CheckerRegistry();
            TestRunner.dumpCheckerRegistry(registry);
            P2RepositoryAnalyser analyser = new P2RepositoryAnalyser();
            reporter = new CheckReportsManager();
            analyser.analyse(p2Repo, registry, reporter);
            System.out.println("run analyse " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
            reporter.dumpReports();
            System.out.println("do dump " + (System.currentTimeMillis() - time) + "ms");
            System.out.println("overall " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private static void dumpCheckerRegistry(CheckerRegistry registry) {
        System.out.println("IU Checker:");
        registry.getCheckers().forEach(element -> System.out.println("   " + element.getClass().getSimpleName()));
        System.out.println("Artifact Checker:");
        registry.getArtifactCheckers().forEach(element -> System.out.println("   " + element.getClass().getSimpleName()));
    }

    @Test
    public void testFeatureNames() {
        Stream<CheckReport> reportsByCheckerId = this.reportsByCheckerId(FeatureNameChecker.class.getName());
        Assert.assertEquals((String)"To Long Featurenames", (long)0L, (long)reportsByCheckerId.filter(report -> report.getType() == ReportType.BAD_GUY).count());
    }

    @Test
    public void testProviderNames() {
        Assert.assertEquals((String)"Bad Provider name", (long)0L, (long)this.reportsByCheckerId(ProviderNameChecker.class.getName()).filter(report -> report.getType() == ReportType.BAD_GUY).count());
        Assert.assertEquals((String)"Wrong Provider name", (long)0L, (long)this.reportsByCheckerId(ProviderNameChecker.class.getName()).filter(report -> report.getType() == ReportType.NOT_IN_TRAIN).count());
    }

    @Test
    public void testLicense() {
        Stream<CheckReport> filter = this.reportsByCheckerId(LicenseConsistencyChecker.class.getName()).filter(report -> report.getType() == ReportType.BAD_GUY);
        Assert.assertEquals((String)"Old License", (long)0L, (long)filter.count());
    }

    @Test
    public void testSigning() {
        Stream<CheckReport> reportsByCheckerId = this.reportsByCheckerId(SignatureChecker.class.getName());
        Stream<CheckReport> filter = reportsByCheckerId.filter(report -> report.getType() == ReportType.NOT_IN_TRAIN);
        Assert.assertEquals((String)"Not signed", (long)0L, (long)filter.count());
    }

    @Test
    public void testAllError() {
        Assert.assertEquals((String)"Error Reports created", (long)0L, (long)reporter.getReports().stream().filter(report -> report.getType() == ReportType.NOT_IN_TRAIN).count());
        Assert.assertEquals((String)"Warning Reports created", (long)0L, (long)reporter.getReports().stream().filter(report -> report.getType() == ReportType.BAD_GUY).count());
    }

    private Stream<CheckReport> reportsByCheckerId(String checkerId) {
        Stream stream = reporter.getReports().parallelStream();
        Stream<CheckReport> featureReports = stream.filter(report -> report.getCheckerId().equals(checkerId));
        return featureReports;
    }
}

