/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.analyzers.BuildRepoTests;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.BREETest;
import org.eclipse.cbi.p2repo.analyzers.jars.ESTest;
import org.eclipse.cbi.p2repo.analyzers.jars.Pack200Test;
import org.eclipse.cbi.p2repo.analyzers.jars.SignerTest;
import org.eclipse.cbi.p2repo.analyzers.jars.TestLayoutTest;
import org.eclipse.cbi.p2repo.analyzers.jars.VersionTest;
import org.eclipse.cbi.p2repo.analyzers.repos.FeatureDisplayableDataChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.FeatureNameLengths;
import org.eclipse.cbi.p2repo.analyzers.repos.IUNameChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.IUVersionCheckToReference;
import org.eclipse.cbi.p2repo.analyzers.repos.ProviderNameChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.repos.VersionChecking;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RepositoryTest {
    private static final RepoTestsConfiguration CONF_FROM_SYSTEM_PROPERTIES = RepoTestsConfiguration.createFromSystemProperties();
    private static final String SKIP_CHECKER_PROP_NAME = "skipChecker";
    private static final Set<String> SKIPPED_CHECKER = new HashSet<String>();
    private static String dirToTest;
    private static String repoToTest;
    private static String refRepoDir;

    @BeforeClass
    public static final void beforeClass() {
        BuildRepoTests tests = new BuildRepoTests(CONF_FROM_SYSTEM_PROPERTIES);
        String directoryToCheck = tests.getDirectoryToCheck();
        if (directoryToCheck == null) {
            System.err.println("Repository directory was not specified. Use -reportRepoDir=/dir/location to pass the repository location");
        }
        if (System.getProperty("DUMP_ENV_PROPS", null) != null) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                System.out.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        dirToTest = directoryToCheck;
        repoToTest = "file://" + directoryToCheck;
        refRepoDir = tests.getDirectoryToCheckForReference();
        String skipCheckerProp = System.getProperty(SKIP_CHECKER_PROP_NAME);
        if (skipCheckerProp != null) {
            String[] split;
            String[] stringArray = split = skipCheckerProp.split(";");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String checkerName = stringArray[n2];
                SKIPPED_CHECKER.add(checkerName);
                System.out.println("Checker " + checkerName + " will be skipped.");
                ++n2;
            }
        }
    }

    @AfterClass
    public static final void afterClass() {
        String output = new BuildRepoTests(CONF_FROM_SYSTEM_PROPERTIES).getReportOutputDirectory();
        System.out.println("See reports in:" + output);
    }

    @Test
    public void testVersionUniqness() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        VersionChecking checker = new VersionChecking(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Unique Versions used in repository", (!checker.testVersionUniqness() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIUNames() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        IUNameChecker checker = new IUNameChecker(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct feature names", (!checker.testFeatureNames() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Correct bundle names", (!checker.testBundleNames() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProviderName() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        ProviderNameChecker checker = new ProviderNameChecker(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct provider names", (!checker.testProviderNames() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFeatureDisplayableData() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        FeatureDisplayableDataChecker checker = new FeatureDisplayableDataChecker(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct displayable data (checkLicenseConsistency,checkCopyrights,checkDescriptions)", (!checker.testDisplayableData() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFeatureNameLengths() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        FeatureNameLengths checker = new FeatureNameLengths(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertFalse((String)"FeatureDirectoryLengths is  <=100", (checker.testFeatureDirectoryLength() > 100 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIUVersionCheckToReference() throws ProvisionException, OperationCanceledException, URISyntaxException, IOException {
        IUVersionCheckToReference checker = new IUVersionCheckToReference(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker) && refRepoDir != null) {
            Assert.assertTrue((String)"Correct version changes", (!checker.checkIUVersionsToReference() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Correct version changes for features", (!checker.checkIUVersionsToReferenceForFeatures() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEclipseSourceReferences() throws OperationCanceledException, IOException {
        ESTest checker = new ESTest(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct eclipse source reference", (!checker.testESSettingRule() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBREE() throws OperationCanceledException, IOException {
        BREETest checker = new BREETest(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct BREE", (!checker.testBREESettingRule() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPack200() throws OperationCanceledException, IOException {
        Pack200Test checker = new Pack200Test(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct Pack200", (!checker.testBundlePack() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSigning() throws OperationCanceledException, IOException {
        SignerTest checker = new SignerTest(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct signature", (!checker.verifySignatures() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVersionTest() throws OperationCanceledException, IOException {
        VersionTest checker = new VersionTest(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct version pattern", (!checker.testVersionsPatterns() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLayout() throws OperationCanceledException, IOException {
        TestLayoutTest checker = new TestLayoutTest(CONF_FROM_SYSTEM_PROPERTIES);
        if (this.configureChecker((BuildRepoTests)checker)) {
            Assert.assertTrue((String)"Correct files and layout in bundles and features.", (!checker.testLayout() ? 1 : 0) != 0);
        }
    }

    private boolean configureChecker(BuildRepoTests checker) {
        checker.setDirectoryToCheck(dirToTest);
        if (checker instanceof TestRepo) {
            ((TestRepo)checker).setRepoURLToTest(repoToTest);
        }
        return !this.skipChecker(checker);
    }

    private boolean skipChecker(BuildRepoTests checker) {
        if (SKIPPED_CHECKER.size() > 0) {
            return SKIPPED_CHECKER.contains(checker.getClass().getSimpleName());
        }
        return false;
    }
}

