/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.BREETest;
import org.eclipse.cbi.p2repo.analyzers.jars.ESTest;
import org.eclipse.cbi.p2repo.analyzers.jars.Pack200Test;
import org.eclipse.cbi.p2repo.analyzers.jars.SignerTest;
import org.eclipse.cbi.p2repo.analyzers.jars.TestLayoutTest;
import org.eclipse.cbi.p2repo.analyzers.jars.VersionTest;
import org.eclipse.cbi.p2repo.analyzers.repos.FeatureDisplayableDataChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.FeatureNameLengths;
import org.eclipse.cbi.p2repo.analyzers.repos.IUNameChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.IUVersionCheckToReference;
import org.eclipse.cbi.p2repo.analyzers.repos.ProviderNameChecker;
import org.eclipse.cbi.p2repo.analyzers.repos.VersionChecking;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;

public class BuildRepoTests {
    private static final String TOP_OUTPUT_DIR = "reporeports";
    private static final String REPORT_SUB_OUTPUT_DIR = "reports";
    private String mainoutputDirectory;
    private String topreportdir;
    private String reportOutputDirectoryName;
    private static boolean outputDirectoryInitialized;
    private String directoryToCheck;
    private String referenceDirectoryToCheck;
    private String tempWorkingDir;
    private boolean failuresOccurred = false;
    private ReportWriter reportWriter;
    private final RepoTestsConfiguration configurations;

    public BuildRepoTests(RepoTestsConfiguration configurations) {
        this.configurations = configurations;
    }

    private String getMainOutputDirectory() {
        if (this.mainoutputDirectory == null) {
            this.mainoutputDirectory = this.configurations.getReportOutputDir();
        }
        if (this.mainoutputDirectory == null) {
            this.mainoutputDirectory = String.valueOf(System.getProperty("user.home")) + "/temp/p2repo";
            System.out.println("WARNING: no output direcotry explicitly set, so assumed to be based off user.home: " + this.mainoutputDirectory);
        }
        return this.mainoutputDirectory;
    }

    public void setMainOutputDirectory(String mainoutputDirectoryparam) {
        this.mainoutputDirectory = mainoutputDirectoryparam;
    }

    private void initReportOutputDirectory(String mainreportdirname) {
        if (!outputDirectoryInitialized) {
            String reportDirName;
            File reportDir;
            boolean success = false;
            File topReportDir = new File(mainreportdirname);
            if (topReportDir.exists() && !(success = this.removeDirectory(topReportDir))) {
                this.handleFatalError("could not remove top level report direcotry: " + topReportDir);
            }
            if (!(success = (reportDir = new File(reportDirName = this.getReportOutputDirectory())).mkdirs())) {
                this.handleFatalError("could not create report directory: " + topReportDir);
            }
            try {
                this.copyTemplateForIndexFile("/templateFiles/indexPending.html");
            }
            catch (IOException e) {
                this.handleFatalError("could not copy indexPending.html file into place. " + e.getMessage());
            }
            outputDirectoryInitialized = true;
        }
    }

    private boolean removeDirectory(File dir) {
        boolean result = true;
        String[] dirlist = dir.list();
        int i = 0;
        while (i < dirlist.length) {
            String childentry = dirlist[i];
            File child = new File(dir, childentry);
            if (child.isDirectory() ? !(result = this.removeDirectory(child)) : !(result = child.delete())) break;
            ++i;
        }
        if (result) {
            result = dir.delete();
        }
        return result;
    }

    protected String getTopReportOutputDirectory() {
        if (this.topreportdir == null) {
            String maindir = this.getMainOutputDirectory();
            this.topreportdir = String.valueOf(maindir) + "/" + TOP_OUTPUT_DIR;
            this.initReportOutputDirectory(this.topreportdir);
        }
        return this.topreportdir;
    }

    public String getReportOutputDirectory() {
        if (this.reportOutputDirectoryName == null) {
            this.reportOutputDirectoryName = String.valueOf(this.getTopReportOutputDirectory()) + "/" + REPORT_SUB_OUTPUT_DIR;
        }
        return this.reportOutputDirectoryName;
    }

    protected void handleFatalError(String messagestring) {
        System.out.println("ERROR: " + messagestring);
        throw new RuntimeException(messagestring);
    }

    protected void handleWarning(String messagestring) {
        System.out.println("WARNING: " + messagestring);
    }

    public boolean execute() {
        try {
            this.doRepoTests();
            this.doDirectoryTests();
            this.copyTemplateForIndexFile("/templateFiles/indexmain.html");
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            this.failuresOccurred = true;
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            this.failuresOccurred = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.failuresOccurred = true;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.failuresOccurred = true;
        }
        return this.failuresOccurred;
    }

    private void doDirectoryTests() throws IOException {
        ESTest esTest = new ESTest(this.getConfigurations());
        esTest.setDirectoryToCheck(this.getDirectoryToCheck());
        esTest.setTempWorkingDir(this.getTempWorkingDir());
        boolean esFailures = esTest.testESSettingRule();
        if (esFailures) {
            this.setFailuresOccurred(true);
        }
        BREETest breeTest = new BREETest(this.getConfigurations());
        breeTest.setDirectoryToCheck(this.getDirectoryToCheck());
        breeTest.setTempWorkingDir(this.getTempWorkingDir());
        boolean breeFailures = breeTest.testBREESettingRule();
        if (breeFailures) {
            this.setFailuresOccurred(true);
        }
        Pack200Test packTest = new Pack200Test(this.getConfigurations());
        packTest.setDirectoryToCheck(this.getDirectoryToCheck());
        boolean packFailures = packTest.testBundlePack();
        if (packFailures) {
            this.setFailuresOccurred(true);
        }
        SignerTest signerTest = new SignerTest(this.getConfigurations());
        signerTest.setDirectoryToCheck(this.getDirectoryToCheck());
        boolean signFailures = signerTest.verifySignatures();
        if (signFailures) {
            this.setFailuresOccurred(true);
        }
        VersionTest versionTest = new VersionTest(this.getConfigurations());
        versionTest.setDirectoryToCheck(this.getDirectoryToCheck());
        boolean versionCheck = versionTest.testVersionsPatterns();
        if (versionCheck) {
            this.setFailuresOccurred(true);
        }
        TestLayoutTest test = new TestLayoutTest(this.getConfigurations());
        test.setDirectoryToCheck(this.getDirectoryToCheck());
        test.setTempWorkingDir(this.getTempWorkingDir());
        boolean layoutFailures = test.testLayout();
        if (layoutFailures) {
            this.setFailuresOccurred(true);
        }
    }

    private void doRepoTests() throws IOException, ProvisionException, OperationCanceledException, URISyntaxException {
        String repoToTest = "file://" + this.getDirectoryToCheck();
        String referenceRepoToTest = null;
        if (this.getDirectoryToCheckForReference() != null) {
            File refRepoToCheck = new File(this.getDirectoryToCheckForReference());
            if (refRepoToCheck.exists()) {
                referenceRepoToTest = "file://" + this.getDirectoryToCheckForReference();
            } else {
                System.out.println("WARNING: the reference repository was found not to exist. No check done.");
                System.out.println("         referenceRepo: " + this.getDirectoryToCheckForReference());
            }
        }
        boolean uniquenessCheck = false;
        boolean featureNameFailures = false;
        boolean bundleNameFailures = false;
        boolean providerNamesFailure = false;
        boolean licenseConsistencyFailure = false;
        boolean greedyCheck = false;
        VersionChecking uniquenessChecker = new VersionChecking(this.getConfigurations());
        uniquenessChecker.setRepoURLToTest(repoToTest);
        uniquenessCheck = uniquenessChecker.testVersionUniqness();
        if (uniquenessCheck) {
            this.setFailuresOccurred(true);
        }
        IUNameChecker iuNames = new IUNameChecker(this.getConfigurations());
        iuNames.setRepoURLToTest(repoToTest);
        featureNameFailures = iuNames.testFeatureNames();
        bundleNameFailures = iuNames.testBundleNames();
        ProviderNameChecker providerNameChecker = new ProviderNameChecker(this.getConfigurations());
        providerNameChecker.setRepoURLToTest(repoToTest);
        providerNamesFailure = providerNameChecker.testProviderNames();
        FeatureDisplayableDataChecker licenseChecker = new FeatureDisplayableDataChecker(this.getConfigurations());
        licenseChecker.setRepoURLToTest(repoToTest);
        licenseConsistencyFailure = licenseChecker.testDisplayableData();
        FeatureNameLengths featureNameLengths = new FeatureNameLengths(this.getConfigurations());
        featureNameLengths.setRepoURLToTest(repoToTest);
        featureNameLengths.testFeatureDirectoryLength();
        IUVersionCheckToReference iuVersioncheck = new IUVersionCheckToReference(this.getConfigurations());
        iuVersioncheck.setRepoURLToTest(repoToTest);
        iuVersioncheck.setRepoURLForReference(referenceRepoToTest);
        if (referenceRepoToTest != null) {
            iuVersioncheck.checkIUVersionsToReference();
            iuVersioncheck.checkIUVersionsToReferenceForFeatures();
        }
        if (featureNameFailures || bundleNameFailures || providerNamesFailure || licenseConsistencyFailure || greedyCheck) {
            this.setFailuresOccurred(true);
        }
    }

    public String getDirectoryToCheck() {
        if (this.directoryToCheck == null) {
            this.directoryToCheck = this.configurations.getReportRepoDir();
        }
        return this.directoryToCheck;
    }

    public void setDirectoryToCheck(String bundleDirToCheck) {
        this.directoryToCheck = bundleDirToCheck;
    }

    protected String getTempWorkingDir() {
        if (this.tempWorkingDir == null) {
            this.tempWorkingDir = this.configurations.getTempWorkingDir();
        }
        return this.tempWorkingDir;
    }

    public void setTempWorkingDir(String tempWorkingDir) {
        this.tempWorkingDir = tempWorkingDir;
    }

    public boolean isFailuresOccurred() {
        return this.failuresOccurred;
    }

    public void setFailuresOccurred(boolean failuresOccurred) {
    }

    public String getDirectoryToCheckForReference() {
        if (this.referenceDirectoryToCheck == null) {
            this.referenceDirectoryToCheck = this.configurations.getReferenceRepoDir();
        }
        return this.referenceDirectoryToCheck;
    }

    public void setDirectoryToCheckForReference(String referenceDirectoryToCheck) {
        this.referenceDirectoryToCheck = referenceDirectoryToCheck;
    }

    public boolean copyTemplateForIndexFile(String filename) throws IOException {
        boolean success = true;
        File topdir = null;
        File indexfile = null;
        InputStream instream = null;
        BufferedInputStream inputstream = null;
        OutputStreamWriter indexfileoutput = null;
        try {
            topdir = new File(this.getTopReportOutputDirectory());
            indexfile = new File(topdir, "index.html");
            indexfileoutput = new FileWriter(indexfile);
            instream = this.getClass().getResourceAsStream(filename);
            if (instream != null) {
                inputstream = new BufferedInputStream(instream);
                while (inputstream.available() > 0) {
                    indexfileoutput.write(inputstream.read());
                }
            } else {
                System.out.println("Program Error: did not find expected resource on classpath: " + filename);
            }
        }
        finally {
            if (indexfileoutput != null) {
                indexfileoutput.close();
            }
            if (instream != null) {
                instream.close();
            }
            if (inputstream != null) {
                inputstream.close();
            }
        }
        return success;
    }

    protected ReportWriter createReportWriter(String outfilename) {
        if (this.reportWriter == null) {
            String outdir = this.getReportOutputDirectory();
            this.reportWriter = new ReportWriter(String.valueOf(outdir) + "/" + outfilename);
        }
        return this.reportWriter;
    }

    protected ReportWriter getReportWriter() {
        if (this.reportWriter == null) {
            this.handleFatalError("Program Error: getWriter() was called before report writer was created with filename");
        }
        return this.reportWriter;
    }

    public RepoTestsConfiguration getConfigurations() {
        return this.configurations;
    }
}

