/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryAnalyser;
import org.eclipse.cbi.p2repo.analyzers.common.P2RepositoryDescription;
import org.eclipse.cbi.p2repo.analyzers.common.checker.CheckerRegistry;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.CheckReportsManager;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.ICheckReporter;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.IP2RepositoryAnalyserConfiguration;
import org.eclipse.cbi.p2repo.analyzers.common.utils.IUUtil;
import org.eclipse.cbi.p2repo.analyzers.reports.HtmlReport;
import org.eclipse.cbi.p2repo.analyzers.reports.JunitXmlReport;
import org.eclipse.cbi.p2repo.analyzers.reports.OverviewReport;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;

public class P2RepositoryCheck {
    private List<ICheckReporter> reporter = Lists.newArrayList((Object[])new ICheckReporter[]{new JunitXmlReport(), new OverviewReport(), new HtmlReport()});

    public boolean runChecks(RepoTestsConfiguration configuration) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            P2RepositoryDescription p2Repo = IUUtil.createRepositoryDescription((URI)configuration.getReportRepoURI());
            System.out.println("create repo descr: " + stopwatch);
            stopwatch.reset().start();
            CheckerRegistry registry = new CheckerRegistry();
            P2RepositoryAnalyser analyser = new P2RepositoryAnalyser();
            CheckReportsManager manager = new CheckReportsManager();
            analyser.analyse(p2Repo, registry, (Consumer)manager);
            System.out.println("run analyse: " + stopwatch);
            stopwatch.reset().start();
            for (ICheckReporter iCheckReporter : this.reporter) {
                iCheckReporter.createReport(manager, (IP2RepositoryAnalyserConfiguration)configuration);
            }
            System.out.println("dump reports: " + stopwatch);
            System.out.println("Reports output: " + configuration.getReportOutputDir());
            stopwatch.stop();
        }
        catch (OperationCanceledException | ProvisionException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }
}

