/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers;

import com.google.common.base.Stopwatch;
import org.eclipse.cbi.p2repo.analyzers.BuildRepoTests;
import org.eclipse.cbi.p2repo.analyzers.P2RepositoryCheck;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class RepoReportApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Integer appresult = IApplication.EXIT_OK;
        RepoTestsConfiguration configurations = RepoTestsConfiguration.createFromSystemProperties();
        if (configurations.getReportRepoDir() == null) {
            this.dumpln("reportRepoDir - property is mandatory. Exit.");
            this.dumpHelpText();
            return appresult;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean testfailures = false;
        if (configurations.getUseNewApi().booleanValue()) {
            Stopwatch additionalReports = Stopwatch.createStarted();
            System.out.println("Using new API.");
            new P2RepositoryCheck().runChecks(configurations);
            System.out.println("Additional reports. Took: " + additionalReports);
        } else {
            testfailures = new BuildRepoTests(configurations).execute();
        }
        stopwatch.stop();
        if (testfailures) {
            appresult = new Integer(-1);
            System.out.println("Report tests failed. Took: " + stopwatch);
        } else {
            System.out.println("Reports completed as expected. Took: " + stopwatch);
        }
        return appresult;
    }

    private void dumpHelpText() {
        this.dumpln("Following properties are available:");
        this.dumpln("\treportRepoDir - repository location to create reports.");
        this.dumpln("\treportOutputDir - report output location.");
        this.dumpln("\treferenceRepo - reference repository location to compare with.");
    }

    private void dumpln(String string) {
        System.out.println(string);
    }

    public void stop() {
    }
}

