/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers;

import java.io.File;
import java.net.URI;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.IP2RepositoryAnalyserConfiguration;

public final class RepoTestsConfiguration
implements IP2RepositoryAnalyserConfiguration {
    public static final String REPORT_REPO_DIR_PARAM = "reportRepoDir";
    public static final String REPORT_OUTPUT_DIR_PARAM = "reportOutputDir";
    public static final String REFERENCE_REPO_PARAM = "referenceRepo";
    public static final String REPO_URL_PARAM = "repoURLToTest";
    public static final String REFERENCE_REPO_URL_PARAM = "repoURLForReference";
    public static final String USE_NEW_API = "useNewApi";
    private String referenceRepoDir;
    private String reportOutputDir;
    private String reportRepoDir;
    private String tempWorkingDir;
    private String repoURLToTest;
    private String repoURLForReference;
    private Boolean useNewApi;

    public RepoTestsConfiguration(String reportRepoDir, String reportOutputDir, String referenceRepoDir, String tempWorkingDir) {
        this.reportRepoDir = reportRepoDir;
        this.reportOutputDir = reportOutputDir;
        this.referenceRepoDir = referenceRepoDir;
        this.tempWorkingDir = tempWorkingDir;
    }

    public String getRepoURLToTest() {
        return this.repoURLToTest;
    }

    public void setRepoURLToTest(String repoURLToTest) {
        this.repoURLToTest = repoURLToTest;
    }

    public String getRepoURLForReference() {
        return this.repoURLForReference;
    }

    public void setRepoURLForReference(String repoURLForReference) {
        this.repoURLForReference = repoURLForReference;
    }

    public String getReferenceRepoDir() {
        return this.referenceRepoDir;
    }

    public String getReportOutputDir() {
        return this.reportOutputDir;
    }

    public String getReportRepoDir() {
        return this.reportRepoDir;
    }

    public URI getReportRepoURI() {
        URI repoURL = new File(this.getReportRepoDir()).toURI();
        return repoURL;
    }

    public String getTempWorkingDir() {
        return this.tempWorkingDir;
    }

    public static RepoTestsConfiguration createFromSystemProperties() {
        String usenew;
        String outDir;
        String repoDir = System.getProperty(REPORT_REPO_DIR_PARAM, null);
        if (repoDir == null || repoDir.isEmpty()) {
            repoDir = System.getenv(REPORT_REPO_DIR_PARAM);
        }
        if ((outDir = System.getProperty(REPORT_OUTPUT_DIR_PARAM, null)) == null || outDir.isEmpty()) {
            outDir = System.getenv(REPORT_OUTPUT_DIR_PARAM);
        }
        if ((usenew = System.getProperty(USE_NEW_API, null)) == null || outDir.isEmpty()) {
            usenew = System.getenv(USE_NEW_API);
        }
        String tmpDir = System.getProperty("java.io.tmpdir");
        String refRepoDir = System.getProperty(REFERENCE_REPO_PARAM, null);
        RepoTestsConfiguration configuration = new RepoTestsConfiguration(repoDir, outDir, refRepoDir, tmpDir);
        configuration.setUseNewImpl(Boolean.valueOf(usenew));
        return configuration;
    }

    public Boolean getUseNewApi() {
        return this.useNewApi;
    }

    public void setUseNewImpl(Boolean useNewImpl) {
        this.useNewApi = useNewImpl;
    }

    public String getDataOutputDir() {
        File dataDir = new File(this.reportOutputDir, "data");
        dataDir.mkdirs();
        return dataDir.getAbsolutePath();
    }
}

