/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.BundleJarUtils;
import org.eclipse.cbi.p2repo.analyzers.utils.FullJarNameParser;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;

public class BREETest
extends TestJars {
    private static final String outputFilename = "breedata.txt";
    private static final FullJarNameParser nameParser = new FullJarNameParser();
    private static final Pattern breeFilter = Pattern.compile("\\(&\\(osgi.ee=\\w+\\)\\(version=\\d.\\d\\)");
    private static final Pattern breeName = Pattern.compile("osgi.ee=\\w+");
    private static final Pattern breeVersion = Pattern.compile("version=\\d.\\d");

    public BREETest(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        BREETest testlayout = new BREETest(RepoTestsConfiguration.createFromSystemProperties());
        testlayout.setDirectoryToCheck("/home/files/testSDKRepo");
        try {
            testlayout.testBREESettingRule();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean testBREESettingRule() throws IOException {
        this.createReportWriter(outputFilename);
        File inputdir = new File(this.getBundleDirectory());
        boolean failuresOccured = this.checkBundleBREE(inputdir);
        return failuresOccured;
    }

    private boolean checkBundleBREE(File inputdir) throws IOException {
        String breeExceptions;
        block26: {
            InputStream propertyStream = this.getClass().getResourceAsStream("exceptions.properties");
            Properties breeExceptionProperties = new Properties();
            breeExceptions = "";
            try {
                try {
                    breeExceptionProperties.load(propertyStream);
                    breeExceptions = breeExceptionProperties.getProperty("breeExceptions");
                    if (breeExceptions == null) {
                        breeExceptions = "";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (propertyStream != null) {
                        try {
                            propertyStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (propertyStream != null) {
                    try {
                        propertyStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (propertyStream != null) {
                try {
                    propertyStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        HashMap javaWithBree = new HashMap();
        ArrayList<String> invalidJars = new ArrayList<String>();
        ArrayList nonjavaWithBree = new ArrayList();
        ArrayList javaWithoutBree = new ArrayList();
        int nonJavaNoBREE = 0;
        boolean failuresOccured = false;
        File[] children = inputdir.listFiles(new JARFileNameFilter());
        int totalsize = children.length;
        int checked = 0;
        int i = 0;
        while (i < totalsize) {
            File child = children[i];
            String name = child.getName();
            String bundleName = this.getBundleName(name);
            if (bundleName != null && !breeExceptions.contains(bundleName)) {
                ++checked;
                try {
                    String bree = BundleJarUtils.getJarManifestEntry(child, "Bundle-RequiredExecutionEnvironment");
                    if (bree == null) {
                        bree = this.parseBREECapability(BundleJarUtils.getJarManifestEntry(child, "Require-Capability"));
                    }
                    boolean needsBree = this.needsBree(child);
                    if (bree != null && bree.length() > 0) {
                        if (needsBree) {
                            this.incrementCounts(javaWithBree, bree);
                        } else {
                            this.trackFalseInclusions(nonjavaWithBree, child, bree);
                            failuresOccured = true;
                        }
                    } else if (needsBree) {
                        this.trackOmissions(javaWithoutBree, child);
                        failuresOccured = true;
                    } else {
                        ++nonJavaNoBREE;
                    }
                }
                catch (SecurityException e) {
                    invalidJars.add(name);
                }
            }
            ++i;
        }
        this.printreport(invalidJars, javaWithBree, nonjavaWithBree, javaWithoutBree, nonJavaNoBREE, totalsize, checked);
        return failuresOccured;
    }

    private String parseBREECapability(String reqCap) {
        if (reqCap != null) {
            String[] requires;
            String[] stringArray = requires = reqCap.split(",");
            int n = requires.length;
            int n2 = 0;
            while (n2 < n) {
                String require = stringArray[n2];
                String[] split = require.split(";");
                if ("osgi.ee".equals(split[0]) && split[1] != null && split[1].startsWith("filter:=")) {
                    String filter = split[1].substring(9, split[1].length() - 1);
                    Matcher m = breeFilter.matcher(filter);
                    ArrayList<String> brees = new ArrayList<String>();
                    while (m.find()) {
                        String group = m.group();
                        Matcher nameMatcher = breeName.matcher(group);
                        Matcher verMatcher = breeVersion.matcher(group);
                        if (!nameMatcher.find() || !verMatcher.find()) continue;
                        String name = nameMatcher.group().split("=")[1];
                        String version = verMatcher.group().split("=")[1];
                        brees.add(String.valueOf(name) + "-" + version);
                    }
                    return brees.stream().collect(Collectors.joining(","));
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean needsBree(File child) {
        return this.exportsPackages(child) || this.containsJava(child);
    }

    private boolean exportsPackages(File child) {
        String entry = BundleJarUtils.getJarManifestEntry(child, "Export-Package");
        return entry != null && !entry.isEmpty();
    }

    private void printreport(List invalidJars, Map javaWithBree, List nonjavaWithBree, List javaWithoutBree, int nonJavaNoBREE, int totalsize, int checked) throws IOException {
        try (ReportWriter reportWriter = this.getReportWriter();){
            reportWriter.writeln();
            reportWriter.writeln("   Directory checked: " + this.getDirectoryToCheck());
            reportWriter.writeln();
            reportWriter.writeln("   Checked " + checked + " of " + totalsize + " jars.");
            reportWriter.writeln();
            this.printInvalidJars(invalidJars, reportWriter);
            reportWriter.writeln();
            reportWriter.writeln("  Bundles with appropriate use of Bundle-RequiredExecutionEnvironment (BREE):");
            reportWriter.writeln("   Java with BREE: " + this.totalCount(javaWithBree));
            reportWriter.writeln("   Non Java without BREE:" + nonJavaNoBREE);
            reportWriter.writeln();
            reportWriter.writeln("   Distribution of BREEs in Java Bundles ");
            reportWriter.writeln();
            Set allBREEs = javaWithBree.keySet();
            ArrayList allBREEList = new ArrayList(allBREEs);
            Collections.sort(allBREEList);
            for (Object object : allBREEList) {
                Integer count = (Integer)javaWithBree.get(object);
                reportWriter.printf("\t\t%5d\t%s\n", (int)count, object);
            }
            reportWriter.writeln();
            reportWriter.writeln("  Bundles with questionable absence or presence of BREE");
            reportWriter.writeln();
            reportWriter.writeln("    Java Bundles without a BREE: " + javaWithoutBree.size());
            reportWriter.writeln();
            Collections.sort(javaWithoutBree);
            for (Object object : javaWithoutBree) {
                reportWriter.writeln("       " + object);
            }
            reportWriter.writeln();
            reportWriter.writeln("    Non Java Bundles with a BREE: " + nonjavaWithBree.size());
            reportWriter.writeln();
            Collections.sort(nonjavaWithBree);
            BREEFileData breefiledata = null;
            for (Object object : nonjavaWithBree) {
                if (object instanceof BREEFileData) {
                    breefiledata = (BREEFileData)object;
                    reportWriter.printf("%24s\t%s\n", breefiledata.breeValue, breefiledata.filename);
                    continue;
                }
                throw new Error("Programming error.");
            }
        }
    }

    private int totalCount(Map javaWithBree) {
        Collection allCounts = javaWithBree.values();
        int total = 0;
        for (Integer count : allCounts) {
            total += count.intValue();
        }
        return total;
    }

    private void trackOmissions(List javaWithoutBree, File child) {
        javaWithoutBree.add(child.getName());
    }

    private void trackFalseInclusions(List list, File child, String bree) {
        list.add(new BREEFileData(child.getName(), bree));
    }

    private void incrementCounts(Map breeMap, String bree) {
        Integer count = (Integer)breeMap.get(bree);
        if (count == null) {
            breeMap.put(bree, new Integer(1));
        } else {
            breeMap.put(bree, this.increment(count));
        }
    }

    private Integer increment(Integer count) {
        return new Integer(count + 1);
    }

    private String getBundleName(String fullname) {
        String result = null;
        boolean parsable = nameParser.parse(fullname);
        if (parsable) {
            result = nameParser.getProjectString();
        }
        return result;
    }

    private boolean containsJava(File jarfile) {
        boolean containsJava;
        block15: {
            containsJava = false;
            ZipFile jar = null;
            try {
                try {
                    jar = new JarFile(jarfile, false, 1);
                    Enumeration<JarEntry> entries = ((JarFile)jar).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.getName().endsWith(".class")) {
                            containsJava = true;
                        } else {
                            InputStream input;
                            if (!entry.getName().endsWith(".jar") || !this.isInBundleClasspath(jarfile, entry.getName()) || !this.containsJava(input = ((JarFile)jar).getInputStream(entry))) continue;
                            containsJava = true;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    if (jar == null) break block15;
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return containsJava;
    }

    private boolean isInBundleClasspath(File jarfile, String name) {
        String entry = BundleJarUtils.getJarManifestEntry(jarfile, "Bundle-ClassPath");
        return entry != null && entry.contains(name);
    }

    private boolean containsJava(InputStream input) {
        boolean containsJava;
        block21: {
            containsJava = false;
            JarInputStream jarInputStream = null;
            try {
                try {
                    jarInputStream = new JarInputStream(input);
                    while (jarInputStream.available() > 0) {
                        ZipEntry entry = jarInputStream.getNextEntry();
                        if (entry == null || !entry.getName().endsWith(".class")) continue;
                        containsJava = true;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (jarInputStream == null) break block21;
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jarInputStream != null) {
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return containsJava;
    }

    static class BREEFileData
    implements Comparable {
        String filename;
        String breeValue;

        public BREEFileData(String filename, String breeValue) {
            this.filename = filename;
            this.breeValue = breeValue;
        }

        public int compareTo(Object o) {
            int result = this.breeValue.compareTo(((BREEFileData)o).breeValue);
            if (result == 0) {
                result = this.filename.compareTo(((BREEFileData)o).filename);
            }
            return result;
        }
    }
}

