/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.FullJarNameParser;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ESTest
extends TestJars {
    private static final Object PROPERTY_ECLIPSE_SOURCEREFERENCES = "Eclipse-SourceReferences";
    private static final FullJarNameParser nameParser = new FullJarNameParser();
    private static final String outputFilename = "esdata.txt";

    public ESTest(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        ESTest testlayout = new ESTest(RepoTestsConfiguration.createFromSystemProperties());
        testlayout.setDirectoryToCheck("/home/files/buildzips/junoRC2/eclipseJEE/");
        try {
            testlayout.testESSettingRule();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean testESSettingRule() throws IOException {
        File inputdir = new File(this.getBundleDirectory());
        this.createReportWriter(outputFilename);
        boolean failuresOccured = this.checkBundleES(inputdir);
        return failuresOccured;
    }

    private boolean checkBundleES(File inputdir) throws IOException {
        String esExceptions;
        block26: {
            InputStream propertyStream = this.getClass().getResourceAsStream("exceptions.properties");
            Properties esExceptionProperties = new Properties();
            esExceptions = "";
            try {
                try {
                    esExceptionProperties.load(propertyStream);
                    esExceptions = esExceptionProperties.getProperty("esExceptions");
                    if (esExceptions == null) {
                        esExceptions = "";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (propertyStream != null) {
                        try {
                            propertyStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (propertyStream != null) {
                    try {
                        propertyStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (propertyStream != null) {
                try {
                    propertyStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        HashMap withEs = new HashMap();
        ArrayList<String> invalidJars = new ArrayList<String>();
        ArrayList withoutEs = new ArrayList();
        boolean failuresOccured = false;
        File[] children = inputdir.listFiles(new JARFileNameFilter());
        int totalsize = children.length;
        int nSourceBundles = 0;
        int nInExceptionList = 0;
        int checked = 0;
        int nProjectTags = 0;
        int i = 0;
        while (i < totalsize) {
            File child = children[i];
            String name = child.getName();
            String bundleName = this.getBundleName(name);
            if (bundleName != null) {
                if (bundleName.endsWith(".source")) {
                    ++nSourceBundles;
                } else if (esExceptions.contains(bundleName)) {
                    ++nInExceptionList;
                } else {
                    ++checked;
                    try {
                        String es = this.getESFromJAR(child);
                        if (es != null && es.contains("project=")) {
                            ++nProjectTags;
                        }
                        if (es != null && es.length() > 0) {
                            this.incrementCounts(withEs, es);
                        } else {
                            this.trackOmissions(withoutEs, child);
                        }
                    }
                    catch (SecurityException e) {
                        invalidJars.add(name);
                    }
                }
            }
            ++i;
        }
        this.printreport(invalidJars, withEs, withoutEs, totalsize, checked, nProjectTags, nSourceBundles, nInExceptionList);
        return failuresOccured;
    }

    private void printreport(List invalidJars, Map withEs, List withoutESs, int totalsize, int checked, int nProjectTags, int nSourceBundles, int nInExceptionList) throws FileNotFoundException {
        try (ReportWriter reportWriter = this.getReportWriter();){
            reportWriter.writeln();
            reportWriter.writeln("   Directory checked: " + this.getBundleDirectory());
            reportWriter.writeln("   Number of source bundles (not checked): " + nSourceBundles);
            reportWriter.writeln("   Number in exception list (not checked): " + nInExceptionList);
            reportWriter.writeln("   Checked " + checked + " of " + totalsize + " jars.");
            reportWriter.writeln();
            reportWriter.writeln();
            reportWriter.writeln("   Number of bundles with an Eclipse-SourceReferences: " + this.totalCount(withEs));
            reportWriter.writeln("        Number of those with 'project=': " + nProjectTags + " attribute.");
            reportWriter.writeln("   Number of bundles without an Eclipse-SourceReferences: " + withoutESs.size());
            reportWriter.writeln();
            reportWriter.writeln();
            reportWriter.writeln("  Bundles with Eclipse-SourceReferences (total: " + this.totalCount(withEs) + ")");
            reportWriter.writeln();
            this.printInvalidJars(invalidJars, reportWriter);
            Set allESs = withEs.keySet();
            ArrayList allESList = new ArrayList(allESs);
            Collections.sort(allESList);
            for (Object object : allESList) {
                reportWriter.writeln("   " + object);
            }
            reportWriter.writeln();
            reportWriter.writeln();
            reportWriter.writeln("    Bundles without an Eclipse-SourceReferences (total: " + withoutESs.size() + ")");
            Collections.sort(withoutESs);
            for (Object object : withoutESs) {
                reportWriter.writeln("       " + object);
            }
            reportWriter.writeln();
        }
    }

    private int totalCount(Map bundlesWithEs) {
        Collection allCounts = bundlesWithEs.values();
        int total = 0;
        for (Integer count : allCounts) {
            total += count.intValue();
        }
        return total;
    }

    private void trackOmissions(List bundlesWithoutEs, File child) {
        bundlesWithoutEs.add(child.getName());
    }

    private void incrementCounts(Map esMap, String es) {
        Integer count = (Integer)esMap.get(es);
        if (count == null) {
            esMap.put(es, new Integer(1));
        } else {
            esMap.put(es, this.increment(count));
        }
    }

    private Integer increment(Integer count) {
        return new Integer(count + 1);
    }

    private String getBundleName(String fullname) {
        String result = null;
        boolean parsable = nameParser.parse(fullname);
        if (parsable) {
            result = nameParser.getProjectString();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getESFromManifest(InputStream input, String path) {
        String es = null;
        try {
            try {
                Map attributes = ManifestElement.parseBundleManifest((InputStream)input, null);
                es = (String)attributes.get(PROPERTY_ECLIPSE_SOURCEREFERENCES);
                return es;
            }
            catch (BundleException e) {
                e.printStackTrace();
                if (input == null) return es;
                try {
                    input.close();
                    return es;
                }
                catch (IOException iOException) {}
                return es;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (input == null) return es;
                try {
                    input.close();
                    return es;
                }
                catch (IOException iOException) {}
                return es;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getESFromJAR(File file) {
        String string;
        InputStream input = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false, 1);
            JarEntry entry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            input = jar.getInputStream(entry);
            string = this.getESFromManifest(input, file.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }
}

