/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.BundleJarUtils;
import org.eclipse.cbi.p2repo.analyzers.utils.FullJarNameParser;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.PackGzFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;

public class Pack200Test
extends TestJars {
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_PACEKD_JAR = ".jar.pack.gz";
    private static FullJarNameParser nameParser = new FullJarNameParser();
    private static final String outputFilename = "pack200data.txt";

    public Pack200Test(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        Pack200Test testlayout = new Pack200Test(RepoTestsConfiguration.createFromSystemProperties());
        testlayout.setDirectoryToCheck("D:\\temp\\staging\\");
        try {
            testlayout.testBundlePack();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean testBundlePack() throws IOException {
        File inputdir = new File(this.getBundleDirectory());
        boolean failuresOccured = this.checkFilesPacked(inputdir);
        return failuresOccured;
    }

    private boolean checkFilesPacked(File inputdir) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> invalidJars = new ArrayList<String>();
        boolean failuresOccured = false;
        File[] jarchildren = inputdir.listFiles(new JARFileNameFilter());
        File[] packedchildren = inputdir.listFiles(new PackGzFileNameFilter());
        File[] nopackedFile = this.nopackedFile(jarchildren, packedchildren);
        int totalsize = nopackedFile.length;
        int checked = 0;
        int i = 0;
        while (i < totalsize) {
            File child = nopackedFile[i];
            String name = child.getName();
            if (child.isFile()) {
                ++checked;
                try {
                    String basicName = this.getBasicName(name, EXTENSION_JAR);
                    boolean valid = nameParser.parse(basicName);
                    if (!valid) {
                        errors.add(String.valueOf(name) + " does not have a valid version (it is unparsable)");
                    } else if (this.containsJava(child)) {
                        errors.add(String.valueOf(name) + " contains java but is not packed");
                    }
                }
                catch (SecurityException e) {
                    invalidJars.add(name);
                }
            }
            ++i;
        }
        this.printSummary(invalidJars, errors, jarchildren, packedchildren, totalsize, checked);
        if (errors.size() > 0) {
            failuresOccured = true;
        }
        return failuresOccured;
    }

    private void printSummary(List invalidJars, List errors, File[] jarchildren, File[] packedchildren, int totalsize, int checked) throws IOException {
        try (ReportWriter reportWriter = this.createReportWriter(outputFilename);){
            reportWriter.writeln();
            reportWriter.writeln("   Directory checked: " + this.getBundleDirectory());
            reportWriter.writeln();
            reportWriter.writeln(" Check of packed and not packed bundles.");
            reportWriter.writeln("   Number of jar files " + jarchildren.length);
            reportWriter.writeln("   Number of pack.gz files " + packedchildren.length);
            reportWriter.writeln("   Difference, number of jar files to check: " + (jarchildren.length - packedchildren.length));
            reportWriter.writeln("   Checked " + checked + " of " + totalsize + ".");
            reportWriter.writeln("   Errors found: " + errors.size());
            this.printInvalidJars(invalidJars, reportWriter);
            if (errors.size() > 0) {
                Collections.sort(errors);
                Iterator iter = errors.iterator();
                while (iter.hasNext()) {
                    reportWriter.writeln(iter.next());
                }
            }
        }
    }

    private File[] nopackedFile(File[] jarchildren, File[] packedchildren) {
        ArrayList<File> results = new ArrayList<File>();
        int i = 0;
        while (i < jarchildren.length) {
            File file = jarchildren[i];
            if (!this.pack200Disabled(file) && !this.contains(packedchildren, file)) {
                results.add(file);
            }
            ++i;
        }
        File[] fileArray = new File[results.size()];
        int i2 = 0;
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            fileArray[i2++] = (File)iterator.next();
        }
        return fileArray;
    }

    private boolean pack200Disabled(File file) {
        Properties eclipseInf = BundleJarUtils.getEclipseInf(file);
        return Boolean.valueOf(eclipseInf.getProperty("jarprocessor.exclude.pack", Boolean.FALSE.toString())) != false;
    }

    private boolean contains(File[] packedchildren, File file) {
        boolean result = false;
        int i = 0;
        while (i < packedchildren.length) {
            if (this.getBasicName(packedchildren[i].getName(), EXTENSION_PACEKD_JAR).equals(this.getBasicName(file.getName(), EXTENSION_JAR))) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsJava(File jarfile) {
        boolean containsJava = false;
        ZipFile jar = null;
        try {
            try {
                jar = new JarFile(jarfile, false, 1);
                Enumeration<JarEntry> entries = ((JarFile)jar).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().endsWith(".class")) {
                        containsJava = true;
                        return containsJava;
                    } else {
                        InputStream input;
                        if (!entry.getName().endsWith(EXTENSION_JAR) || !this.containsJava(input = ((JarFile)jar).getInputStream(entry))) continue;
                        containsJava = true;
                    }
                    return containsJava;
                }
                return containsJava;
            }
            catch (ZipException e) {
                System.out.println("Failed to open jar file (zip exception): " + jarfile.getAbsolutePath());
                if (jar == null) return containsJava;
                try {
                    jar.close();
                    return containsJava;
                }
                catch (IOException iOException) {}
                return containsJava;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (jar == null) return containsJava;
                try {
                    jar.close();
                    return containsJava;
                }
                catch (IOException iOException) {}
                return containsJava;
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean containsJava(InputStream input) {
        boolean containsJava;
        block21: {
            containsJava = false;
            JarInputStream jarInputStream = null;
            try {
                try {
                    jarInputStream = new JarInputStream(input);
                    while (jarInputStream.available() > 0) {
                        ZipEntry entry = jarInputStream.getNextEntry();
                        if (entry == null || !entry.getName().endsWith(".class")) continue;
                        containsJava = true;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (jarInputStream == null) break block21;
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jarInputStream != null) {
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return containsJava;
    }

    private String getBasicName(String fullname, String extension) {
        String result = fullname;
        int pos = fullname.lastIndexOf(extension);
        if (pos >= 0) {
            result = fullname.substring(0, pos);
        }
        return result;
    }
}

