/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.BundleJarUtils;
import org.eclipse.cbi.p2repo.analyzers.utils.CompositeFileFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.PackGzFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.PlainCheckReport;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;
import org.eclipse.cbi.p2repo.analyzers.utils.VerifyStep;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SignerTest
extends TestJars {
    private static final String UNSIGNED_FILENAME = "unsigned8.txt";
    private static final String SIGNED_FILENAME = "verified8.txt";
    private static final String KNOWN_UNSIGNED = "knownunsigned8.txt";

    public SignerTest(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public boolean verifySignatures() throws IOException {
        boolean _not;
        CopyOnWriteArraySet<PlainCheckReport> checkReports = new CopyOnWriteArraySet<PlainCheckReport>();
        boolean _canVerify = VerifyStep.canVerify();
        boolean bl = _not = !_canVerify;
        if (_not) {
            System.err.println("jarsigner is not available. Can not check.");
            return true;
        }
        String _featureDirectory = this.getFeatureDirectory();
        File _file = new File(_featureDirectory);
        this.checkJars(_file, "feature", checkReports);
        String _bundleDirectory = this.getBundleDirectory();
        File _file_1 = new File(_bundleDirectory);
        this.checkJars(_file_1, "plugin", checkReports);
        Functions.Function1 _function = it -> {
            ReportType _type = it.getType();
            return Objects.equal((Object)_type, (Object)ReportType.NOT_IN_TRAIN);
        };
        boolean containsErrors = IterableExtensions.exists(checkReports, (Functions.Function1)_function);
        this.printSummary(checkReports);
        return containsErrors;
    }

    public void checkJars(File dirToCheck, String iuType, CopyOnWriteArraySet<PlainCheckReport> reports) {
        JARFileNameFilter _jARFileNameFilter = new JARFileNameFilter();
        PackGzFileNameFilter _packGzFileNameFilter = new PackGzFileNameFilter();
        CompositeFileFilter _create = CompositeFileFilter.create(_jARFileNameFilter, _packGzFileNameFilter);
        File[] jars = dirToCheck.listFiles(_create);
        Stream _parallelStream = ((List)Conversions.doWrapArray((Object)jars)).parallelStream();
        SignerCheck _signerCheck = new SignerCheck(reports, iuType);
        _parallelStream.forEach(_signerCheck);
    }

    private void printSummary(Set<PlainCheckReport> reports) throws IOException {
        ReportWriter info = this.createNewReportWriter(SIGNED_FILENAME);
        ReportWriter warn = this.createNewReportWriter(KNOWN_UNSIGNED);
        ReportWriter error = this.createNewReportWriter(UNSIGNED_FILENAME);
        try {
            Functions.Function1 _function = it -> {
                String _iuType = it.getIuType();
                return _iuType.equals("feature");
            };
            Iterable _filter = IterableExtensions.filter(reports, (Functions.Function1)_function);
            int featuresCount = IterableExtensions.size((Iterable)_filter);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Jars checked: ");
            int _size = reports.size();
            _builder.append((Object)_size, "");
            _builder.append(". ");
            _builder.append((Object)featuresCount, "");
            _builder.append(" features and ");
            int _size_1 = reports.size();
            int _minus = _size_1 - featuresCount;
            _builder.append((Object)_minus, "");
            _builder.append(" plugins.");
            _builder.newLineIfNotEmpty();
            _builder.append("Valid signatures: ");
            Functions.Function1 _function_1 = it -> {
                ReportType _type = it.getType();
                return Objects.equal((Object)_type, (Object)ReportType.INFO);
            };
            Iterable _filter_1 = IterableExtensions.filter(reports, (Functions.Function1)_function_1);
            int _size_2 = IterableExtensions.size((Iterable)_filter_1);
            _builder.append((Object)_size_2, "");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            _builder.append("Explicitly excluded from signing: ");
            Functions.Function1 _function_2 = it -> {
                ReportType _type = it.getType();
                return Objects.equal((Object)_type, (Object)ReportType.BAD_GUY);
            };
            Iterable _filter_2 = IterableExtensions.filter(reports, (Functions.Function1)_function_2);
            int _size_3 = IterableExtensions.size((Iterable)_filter_2);
            _builder.append((Object)_size_3, "");
            _builder.append(". See ");
            _builder.append(KNOWN_UNSIGNED, "");
            _builder.append(" for more details.");
            _builder.newLineIfNotEmpty();
            _builder.append("Invalid or missing signature: ");
            Functions.Function1 _function_3 = it -> {
                ReportType _type = it.getType();
                return Objects.equal((Object)_type, (Object)ReportType.NOT_IN_TRAIN);
            };
            Iterable _filter_3 = IterableExtensions.filter(reports, (Functions.Function1)_function_3);
            int _size_4 = IterableExtensions.size((Iterable)_filter_3);
            _builder.append((Object)_size_4, "");
            _builder.append(". See ");
            _builder.append(UNSIGNED_FILENAME, "");
            _builder.append(" for more details.");
            _builder.newLineIfNotEmpty();
            info.writeln(_builder);
            Functions.Function1 _function_4 = it -> {
                String _fileName = it.getFileName();
                return _fileName.length();
            };
            List _sortBy = IterableExtensions.sortBy(reports, (Functions.Function1)_function_4);
            PlainCheckReport _last = (PlainCheckReport)((Object)IterableExtensions.last((Iterable)_sortBy));
            String _fileName = _last.getFileName();
            int longestFileName = _fileName.length();
            Functions.Function1 _function_5 = it -> it.getFileName();
            List _sortBy_1 = IterableExtensions.sortBy(reports, (Functions.Function1)_function_5);
            for (PlainCheckReport report : _sortBy_1) {
                String _fileName_1 = report.getFileName();
                int _length = _fileName_1.length();
                int _minus_1 = longestFileName - _length;
                String indent = Strings.repeat((String)" ", (int)_minus_1);
                String _iuType = report.getIuType();
                int _length_1 = _iuType.length();
                int _minus_2 = 10 - _length_1;
                String trailing = Strings.repeat((String)" ", (int)_minus_2);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                String _fileName_2 = report.getFileName();
                _builder_1.append(_fileName_2, " ");
                _builder_1.append(indent, " ");
                _builder_1.append("\t");
                String _iuType_1 = report.getIuType();
                _builder_1.append(_iuType_1, " ");
                _builder_1.append(trailing, " ");
                _builder_1.append("\t");
                String _checkResult = report.getCheckResult();
                _builder_1.append(_checkResult, " ");
                String line = _builder_1.toString();
                ReportType _type = report.getType();
                if (_type == null) continue;
                switch (_type) {
                    case INFO: {
                        info.writeln(line);
                        break;
                    }
                    case WARNING: {
                        info.writeln(line);
                        break;
                    }
                    case NOT_IN_TRAIN: {
                        error.writeln(line);
                        break;
                    }
                    case BAD_GUY: {
                        warn.writeln(line);
                        break;
                    }
                }
            }
        }
        finally {
            info.close();
            warn.close();
            error.close();
        }
    }

    protected ReportWriter createNewReportWriter(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        String _reportOutputDirectory = this.getReportOutputDirectory();
        _builder.append(_reportOutputDirectory, "");
        _builder.append("/");
        _builder.append(filename, "");
        return new ReportWriter(_builder.toString());
    }

    public static final class SignerCheck
    implements Consumer<File> {
        private final Collection<PlainCheckReport> reports;
        private final String iuTypeName;

        SignerCheck(Collection<PlainCheckReport> reports, String iuTypeName) {
            this.reports = reports;
            this.iuTypeName = iuTypeName;
        }

        @Override
        public void accept(File file) {
            Properties eclipseInf;
            String _property;
            Boolean _valueOf;
            PlainCheckReport checkReport = new PlainCheckReport();
            String _name = file.getName();
            checkReport.setFileName(_name);
            checkReport.setIuType(this.iuTypeName);
            File fileToCheck = file;
            String _name_1 = fileToCheck.getName();
            boolean _endsWith = _name_1.endsWith(".jar.pack.gz");
            if (_endsWith) {
                try {
                    File _unpack200gz;
                    fileToCheck = _unpack200gz = BundleJarUtils.unpack200gz(fileToCheck);
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException e = (IOException)_t;
                        checkReport.setType(ReportType.NOT_IN_TRAIN);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Unable to unpack ");
                        String _absolutePath = file.getAbsolutePath();
                        _builder.append(_absolutePath, "");
                        _builder.append(". Can not check signature. ");
                        String _message = e.getMessage();
                        _builder.append(_message, "");
                        checkReport.setCheckResult(_builder.toString());
                        return;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            if ((_valueOf = Boolean.valueOf(_property = (eclipseInf = BundleJarUtils.getEclipseInf(fileToCheck)).getProperty("jarprocessor.exclude.sign", "false"))).booleanValue()) {
                checkReport.setType(ReportType.BAD_GUY);
                checkReport.setCheckResult("Jar was excluded from signing using the eclipse.inf entry.");
            } else {
                StringBuilder errorOut = new StringBuilder();
                StringBuilder warningOut = new StringBuilder();
                boolean verified = VerifyStep.verify(fileToCheck, errorOut, warningOut);
                if (!verified) {
                    checkReport.setType(ReportType.NOT_IN_TRAIN);
                    String _string = errorOut.toString();
                    checkReport.setCheckResult(_string);
                } else {
                    boolean _greaterThan;
                    String message = "jar verified";
                    int _length = warningOut.length();
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        String _string_1;
                        checkReport.setType(ReportType.INFO);
                        message = _string_1 = warningOut.toString();
                    }
                    checkReport.setCheckResult(message);
                }
            }
            this.reports.add(checkReport);
        }
    }
}

