/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import org.eclipse.cbi.p2repo.analyzers.BuildRepoTests;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;

public abstract class TestJars
extends BuildRepoTests {
    private String bundleDirectory;
    private String featureDirectory;

    public TestJars(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    protected String getBundleDirectory() {
        if (this.bundleDirectory == null) {
            String AGGR_PLUGINS_DIR = "aggregate/plugins";
            String PLUGINS_DIR = "plugins";
            String property = this.getDirectoryToCheck();
            if (property == null) {
                this.handleFatalError("Need to set input directory to check against.");
            }
            property = this.ensureEndingSlash(property);
            this.bundleDirectory = String.valueOf(property) + AGGR_PLUGINS_DIR;
            File inputdir = new File(this.bundleDirectory);
            if (!inputdir.exists() || !inputdir.isDirectory()) {
                this.bundleDirectory = String.valueOf(property) + PLUGINS_DIR;
                inputdir = new File(this.bundleDirectory);
                if (!inputdir.exists() || !inputdir.isDirectory()) {
                    this.handleFatalError("bundle direcotry (" + this.bundleDirectory + ") must be an existing directory.");
                }
            }
        }
        return this.bundleDirectory;
    }

    private String ensureEndingSlash(String property) {
        String result = property;
        if (!result.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        return result;
    }

    protected String getFeatureDirectory() {
        if (this.featureDirectory == null) {
            String AGGR_FEATURES_DIR = "aggregate/features";
            String FEATURES_DIR = "features";
            String property = this.getDirectoryToCheck();
            if (property == null) {
                this.handleFatalError("Need to set input directory to check against.");
            }
            property = this.ensureEndingSlash(property);
            this.featureDirectory = String.valueOf(property) + AGGR_FEATURES_DIR;
            File inputdir = new File(this.featureDirectory);
            if (!inputdir.exists() || !inputdir.isDirectory()) {
                this.featureDirectory = String.valueOf(property) + FEATURES_DIR;
                inputdir = new File(this.featureDirectory);
                if (!inputdir.exists() || !inputdir.isDirectory()) {
                    this.handleFatalError("feature direcotry (" + this.featureDirectory + ") must be an existing directory.");
                }
            }
        }
        return this.featureDirectory;
    }

    protected void printInvalidJars(List invalidJars, ReportWriter reportWriter) throws FileNotFoundException {
        if (invalidJars.size() > 0) {
            reportWriter.writeln("The following jars could not be read, perhaps invalid signatures led to security exceptions?");
            Collections.sort(invalidJars);
            for (Object bundle : invalidJars) {
                reportWriter.writeln("       " + bundle);
            }
        }
    }
}

