/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestLayoutTest
extends TestJars {
    private static final String outputFilename = "layoutCheck.txt";
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_PACEKD_JAR = ".pack.gz";
    private static final String EXTENSION_ZIP = ".zip";
    private static final String PROPERTY_BUNDLE_ID = "Bundle-SymbolicName";
    private String configFilename = "config.properties";
    private static final String KEY_DFT_BIN_JAR = "default.binary.jar";
    private static final String KEY_DFT_SRC_JAR = "default.source.jar";
    private static final String KEY_DFT_FEATURE = "default.feature";
    private Properties config;
    private List errors = new ArrayList();

    public TestLayoutTest(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        TestLayoutTest testlayout = new TestLayoutTest(RepoTestsConfiguration.createFromSystemProperties());
        testlayout.setDirectoryToCheck("D:\\temptest");
        testlayout.setTempWorkingDir("D:/temp");
        try {
            testlayout.testLayout();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addError(String message) {
        this.errors.add(message);
    }

    public boolean testLayout() throws IOException {
        boolean result = false;
        try {
            this.createReportWriter(outputFilename);
            this.getReportWriter().writeln("Check files and layout in bundles and features.");
            boolean featureFailures = this.testFeatureLayout();
            boolean bundleFailures = this.testBundleLayout();
            result = featureFailures || bundleFailures;
        }
        finally {
            this.getReportWriter().close();
        }
        return result;
    }

    private boolean testBundleLayout() throws IOException {
        this.errors = new ArrayList();
        boolean failuresOccured = false;
        File inputdir = new File(this.getBundleDirectory());
        File[] children = inputdir.listFiles(new JARFileNameFilter());
        int totalsize = children.length;
        int checked = 0;
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String id = this.getBundleId(child);
            if (id != null) {
                boolean sourceIU = this.isSourceIUName(id);
                this.processBundle(child, this.getExpected(id, sourceIU));
                ++checked;
            }
            ++i;
        }
        this.getReportWriter().writeln();
        this.getReportWriter().writeln("   Checking: " + this.getBundleDirectory());
        this.getReportWriter().writeln("   Checked " + checked + " of " + totalsize + ".");
        this.getReportWriter().writeln("   Errors found: " + this.errors.size());
        if (this.errors.size() > 0) {
            Collections.sort(this.errors);
            Iterator iter = this.errors.iterator();
            while (iter.hasNext()) {
                this.getReportWriter().writeln(iter.next());
            }
            failuresOccured = true;
        }
        return failuresOccured;
    }

    private boolean isSourceIUName(String id) {
        return id.endsWith(".source") || id.endsWith(".infopop") || id.endsWith(".doc.user") || id.endsWith(".doc") || id.endsWith(".doc.isv") || id.endsWith(".doc.dev") || id.endsWith(".doc.api") || id.endsWith("standard.schemas") || id.endsWith(".branding");
    }

    private Set getExpected(String id, boolean source) {
        return this.findConfiguration(id, source, false);
    }

    private Set getFeatureExpected(String id, boolean source, boolean zip) {
        return this.findConfiguration(id, source, true);
    }

    private Set<String> findConfiguration(String id, boolean source, boolean feature) {
        String line;
        if (this.config == null) {
            this.loadConfig();
        }
        if ((line = this.config.getProperty(id)) == null) {
            line = feature ? this.config.getProperty(KEY_DFT_FEATURE) : (source ? this.config.getProperty(KEY_DFT_SRC_JAR) : this.config.getProperty(KEY_DFT_BIN_JAR));
        }
        if (line == null) {
            this.handleFatalError("Unable to load settings for: " + id);
        }
        line = id.endsWith(".source") ? MessageFormat.format(line, id.substring(0, id.lastIndexOf(46))) : MessageFormat.format(line, id);
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    private void loadConfig() {
        this.config = new Properties();
        InputStream input = null;
        try {
            try {
                File configFile = new File(this.getConfigFilename());
                input = configFile.exists() ? new FileInputStream(configFile) : this.getClass().getResourceAsStream(this.getConfigFilename());
                if (input == null) {
                    this.handleFatalError("Unable to load configuration file.");
                }
                this.config.load(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void processBundle(File file, Set expected) {
        if (file.isDirectory()) {
            String[] array = expected.toArray(new String[expected.size()]);
            this.processDir("", file, array);
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    this.addError("Missing " + array[i] + " in dir: " + file.getAbsolutePath());
                }
                ++i;
            }
        } else {
            this.processArchive(file, expected.toArray(new String[expected.size()]));
        }
    }

    private void processFeature(File file, Set expected) {
        if (file.isDirectory()) {
            String[] array = expected.toArray(new String[expected.size()]);
            this.processDir("", file, array);
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    this.addError("Missing " + array[i] + " in dir: " + file.getAbsolutePath());
                }
                ++i;
            }
        } else {
            this.processArchive(file, expected.toArray(new String[expected.size()]));
        }
    }

    private void processArchive(File file, String[] expected) {
        block20: {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file, 1);
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String name = entry.getName();
                        int i = 0;
                        while (i < expected.length) {
                            String pattern = expected[i];
                            if (pattern != null) {
                                try {
                                    if (name.matches(pattern)) {
                                        expected[i] = null;
                                    }
                                }
                                catch (PatternSyntaxException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ++i;
                        }
                    }
                    int i = 0;
                    while (i < expected.length) {
                        if (expected[i] != null) {
                            this.addError("Missing " + expected[i] + " in file: " + file.getName());
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zip == null) break block20;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void processDir(String root, File dir, String[] expected) {
        File[] children = dir.listFiles();
        int index = 0;
        while (index < children.length) {
            String name;
            File child = children[index];
            String string = name = root.length() == 0 ? child.getName() : String.valueOf(root) + '/' + child.getName();
            if (child.isDirectory()) {
                this.processDir(name, child, expected);
            } else {
                int i = 0;
                while (i < expected.length) {
                    String pattern = expected[i];
                    if (pattern != null) {
                        try {
                            if (name.matches(pattern)) {
                                expected[i] = null;
                            }
                        }
                        catch (PatternSyntaxException ex) {
                            this.addError(ex.getMessage());
                        }
                    }
                    ++i;
                }
            }
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBundleIdFromManifest(InputStream input, String path) {
        String id = null;
        try {
            try {
                Map attributes = ManifestElement.parseBundleManifest((InputStream)input, null);
                id = (String)attributes.get(PROPERTY_BUNDLE_ID);
                if (id == null || id.length() == 0) {
                    this.addError("BundleSymbolicName header not set in manifest for bundle: " + path);
                    return id;
                } else {
                    int pos = id.indexOf(59);
                    if (pos <= 0) return id;
                    id = id.substring(0, pos);
                    return id;
                }
            }
            catch (BundleException e) {
                this.addError(e.getMessage());
                if (input == null) return id;
                try {
                    input.close();
                    return id;
                }
                catch (IOException iOException) {}
                return id;
            }
            catch (IOException e) {
                this.addError(e.getMessage());
                if (input == null) return id;
                try {
                    input.close();
                    return id;
                }
                catch (IOException iOException) {}
                return id;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getBundleId(File file) {
        String id = null;
        if (file.isDirectory()) {
            id = this.getBundleIdFromDir(file);
        } else if (file.getName().toLowerCase().endsWith(EXTENSION_ZIP)) {
            id = this.getBundleIdFromZIP(file);
        } else if (file.getName().toLowerCase().endsWith(EXTENSION_JAR)) {
            id = this.getBundleIdFromJAR(file);
        }
        return id;
    }

    /*
     * Exception decompiling
     */
    private String getBundleIdFromZIP(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getBundleIdFromDir(File dir) {
        String id = null;
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists() || !manifestFile.isFile()) {
            this.addError("Bundle manifest (MANIFEST.MF) not found at: " + manifestFile.getAbsolutePath());
        } else {
            try {
                id = this.getBundleIdFromManifest(new FileInputStream(manifestFile), manifestFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                this.addError(e.getMessage());
            }
        }
        return id;
    }

    private File getFileFromPACKEDJAR(File file) {
        File tmpjar = null;
        try {
            JarProcessor jarprocessor = JarProcessor.getUnpackProcessor(null);
            jarprocessor.setWorkingDirectory(this.getTempWorkingDir());
            tmpjar = jarprocessor.processJar(file);
        }
        catch (IOException e) {
            this.addError(e.getMessage());
        }
        return tmpjar;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public void setConfigFilename(String configFilename) {
        this.configFilename = configFilename;
    }

    private String getBundleIdFromJAR(File file) {
        String string;
        InputStream input = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false, 1);
            JarEntry entry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                this.addError("Bundle does not contain a MANIFEST.MF file: " + file.getAbsolutePath());
                return null;
            }
            input = jar.getInputStream(entry);
            string = this.getBundleIdFromManifest(input, file.getAbsolutePath());
        }
        catch (IOException e) {
            this.addError(e.getMessage());
            return null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private boolean testFeatureLayout() throws IOException {
        this.errors = new ArrayList();
        boolean failuresOccurred = false;
        File inputdir = new File(this.getFeatureDirectory());
        File[] children = inputdir.listFiles(new JARFileNameFilter());
        int totalsize = children.length;
        int checked = 0;
        int i = 0;
        while (i < children.length) {
            String id;
            File child = children[i];
            if (child.getName().toLowerCase().endsWith(EXTENSION_PACEKD_JAR)) {
                child = this.getFileFromPACKEDJAR(child);
            }
            if (child != null && (id = this.getFeatureId(child)) != null) {
                this.processFeature(child, this.getFeatureExpected(id, true, child.getName().endsWith(EXTENSION_ZIP)));
                ++checked;
            }
            ++i;
        }
        this.getReportWriter().writeln();
        this.getReportWriter().writeln("   Checking: " + this.getFeatureDirectory());
        this.getReportWriter().writeln("   Checked " + checked + " of " + totalsize + ".");
        this.getReportWriter().writeln("   Errors found: " + this.errors.size());
        if (this.errors.size() > 0) {
            Collections.sort(this.errors);
            Iterator iter = this.errors.iterator();
            while (iter.hasNext()) {
                this.getReportWriter().writeln(iter.next());
            }
            failuresOccurred = true;
        }
        return failuresOccurred;
    }

    private String getFeatureId(File file) {
        String id = null;
        if (file.isDirectory()) {
            id = this.getFeatureIdFromDir(file);
        } else if (file.getName().toLowerCase().endsWith(EXTENSION_JAR)) {
            id = this.getFeatureIdFromJAR(file);
        }
        return id;
    }

    /*
     * Loose catch block
     */
    private String getFeatureIdFromJAR(File file) {
        InputStream input = null;
        JarFile jar = null;
        String id = null;
        try {
            try {
                jar = new JarFile(file, false, 1);
                JarEntry entry = jar.getJarEntry("feature.xml");
                if (entry == null) {
                    this.addError("Feature jar does not contain a feature.xml file: " + file.getAbsolutePath());
                }
                input = jar.getInputStream(entry);
                id = this.getFeatureFromFeatureXML(input);
            }
            catch (IOException e) {
                this.addError(e.getMessage());
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ParserConfigurationException e) {
                block37: {
                    this.addError(e.getMessage());
                    if (input == null) break block37;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (SAXException e) {
                block38: {
                    this.addError(e.getMessage());
                    if (input == null) break block38;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return id;
    }

    private String getFeatureIdFromDir(File dir) {
        String id = null;
        File featureFile = new File(dir, "feature.xml");
        if (!featureFile.exists() || !featureFile.isFile()) {
            this.addError("Feature.xml not found at: " + featureFile.getAbsolutePath());
        } else {
            id = this.getFeatureFromFeatureXML(featureFile);
        }
        return id;
    }

    private String getFeatureFromFeatureXML(File file) {
        Document document = this.getDOM(file);
        return this.getFeatureIdFromDOM(document);
    }

    private String getFeatureIdFromDOM(Document document) {
        String id = null;
        if (document != null) {
            Node featureNode;
            NodeList featureElements = document.getElementsByTagName("feature");
            Node featureElement = null;
            if (featureElements.getLength() > 0 && (featureNode = featureElements.item(0)) instanceof Element) {
                featureElement = (Element)featureNode;
            }
            if (featureElement != null) {
                NamedNodeMap aNamedNodeMap = featureElement.getAttributes();
                Node idAttribute = aNamedNodeMap.getNamedItem("id");
                id = idAttribute.getNodeValue();
            }
        }
        return id;
    }

    private String getFeatureFromFeatureXML(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        Document document = this.getDOM(stream);
        return this.getFeatureIdFromDOM(document);
    }

    /*
     * Exception decompiling
     */
    private Document getDOM(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 11[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Document getDOM(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        Document aDocument = null;
        InputSource inputSource = new InputSource(stream);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        aDocument = builder.parse(inputSource);
        return aDocument;
    }
}

