/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.jars;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.jars.TestJars;
import org.eclipse.cbi.p2repo.analyzers.utils.FullJarNameParser;
import org.eclipse.cbi.p2repo.analyzers.utils.JARFileNameFilter;
import org.eclipse.cbi.p2repo.analyzers.utils.ReportWriter;

public class VersionTest
extends TestJars {
    private static final String outputFilename = "versionPatternCheck.txt";
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_PACEKD_JAR = ".jar.pack.gz";
    private static final String EXTENSION_ZIP = ".zip";
    private FullJarNameParser nameParser = new FullJarNameParser();
    private String BACKSLASH = "\\";
    private String LITERAL_PERIOD = String.valueOf(this.BACKSLASH) + ".";
    private String ANY = ".*";
    private Pattern threedots = Pattern.compile(String.valueOf(this.ANY) + this.LITERAL_PERIOD + this.ANY + this.LITERAL_PERIOD + this.ANY + this.LITERAL_PERIOD + this.ANY);
    public ReportWriter reportWriter;

    public VersionTest(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        VersionTest testlayout = new VersionTest(RepoTestsConfiguration.createFromSystemProperties());
        testlayout.setDirectoryToCheck("D:\\temp\\staging\\");
        try {
            testlayout.testFeatureVersions();
            testlayout.testBundleVersions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean testBundleVersions() throws IOException {
        File inputdir = new File(this.getBundleDirectory());
        this.getReportWriter().writeln(" Check for 4-part versions in Bundles");
        boolean failuresOccured = this.checkFilesVersions(inputdir);
        return failuresOccured;
    }

    private boolean checkFilesVersions(File inputdir) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        boolean failuresOccured = false;
        File[] children = inputdir.listFiles(new JARFileNameFilter());
        int totalsize = children.length;
        int checked = 0;
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String name = child.getName();
            if (child.isFile()) {
                if (name.endsWith(EXTENSION_PACEKD_JAR)) {
                    name = this.getBasicName(name, EXTENSION_PACEKD_JAR);
                } else if (name.endsWith(EXTENSION_JAR)) {
                    name = this.getBasicName(name, EXTENSION_JAR);
                } else if (name.endsWith(EXTENSION_ZIP)) {
                    name = this.getBasicName(name, EXTENSION_ZIP);
                }
            }
            ++checked;
            boolean valid = this.nameParser.parse(name);
            if (!valid) {
                errors.add(String.valueOf(name) + " does not have a valid version (it is unparsable)");
            } else {
                String version = this.nameParser.getVersionString();
                Matcher matcher = this.threedots.matcher(version);
                if (!matcher.matches()) {
                    errors.add(String.valueOf(name) + " does not contain 4 parts");
                }
            }
            ++i;
        }
        this.getReportWriter().writeln("   Checked " + checked + " of " + totalsize + ".");
        this.getReportWriter().writeln("   Errors found: " + errors.size());
        if (errors.size() > 0) {
            Collections.sort(errors);
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                this.getReportWriter().writeln(iter.next());
            }
            failuresOccured = true;
        }
        return failuresOccured;
    }

    private String getBasicName(String fullname, String extension) {
        String result = fullname;
        int pos = fullname.lastIndexOf(extension);
        if (pos >= 0) {
            result = fullname.substring(0, pos);
        }
        return result;
    }

    public boolean testVersionsPatterns() throws IOException {
        boolean result = false;
        this.createReportWriter(outputFilename);
        try {
            this.getReportWriter().writeln("Check 4-part version patterns");
            boolean featureFailures = this.testFeatureVersions();
            boolean bundleFailures = this.testBundleVersions();
            result = featureFailures || bundleFailures;
        }
        finally {
            this.getReportWriter().close();
        }
        return result;
    }

    private boolean testFeatureVersions() throws IOException {
        File inputdir = new File(this.getFeatureDirectory());
        this.getReportWriter().writeln(" Check for 4-part versions in Features");
        boolean failuresOccured = this.checkFilesVersions(inputdir);
        return failuresOccured;
    }
}

