/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.reports;

import com.google.common.base.Objects;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.CheckReportsManager;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.ICheckReporter;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.IP2RepositoryAnalyserConfiguration;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HtmlReport
implements ICheckReporter {
    private final String cssFileName = "html-report.css";
    private final String jsFileName = "html-report.js";
    private final String errorsFileName = "errors-and-moderate_warnings.html";
    private final String warningsFileName = "warnings.html";

    public void createReport(CheckReportsManager manager, IP2RepositoryAnalyserConfiguration configs) {
        try {
            String _errorsHtmlLocation = this.errorsHtmlLocation(configs);
            PrintWriter writer = new PrintWriter(_errorsHtmlLocation);
            ConcurrentLinkedQueue allreports = manager.getReports();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<html>");
            _builder.newLine();
            _builder.append("<head>");
            _builder.newLine();
            _builder.append("<link rel=\"stylesheet\" href=\"./data/");
            _builder.append("html-report.css", "");
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("<script src=\"http://code.jquery.com/jquery-1.11.3.min.js\"></script>");
            _builder.newLine();
            _builder.append("<script src=\"./data/");
            _builder.append("html-report.js", "");
            _builder.append("\"></script>");
            _builder.newLineIfNotEmpty();
            _builder.append("</head>");
            _builder.newLine();
            _builder.append("<body>");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _summary = this.summary(configs);
            _builder.append((Object)_summary, "\t");
            _builder.append("<br>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<a href=\"./");
            _builder.append("warnings.html", "\t");
            _builder.append("\">show warnings</a>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _htmlTable = this.htmlTable(ReportType.NOT_IN_TRAIN, allreports);
            _builder.append(_htmlTable, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<br>");
            _builder.newLine();
            _builder.append("\t");
            String _htmlTable_1 = this.htmlTable(ReportType.BAD_GUY, allreports);
            _builder.append(_htmlTable_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
            String xmlContent = _builder.toString();
            PrintWriter _append = writer.append(xmlContent);
            _append.close();
            String _warningsHtmlLocation = this.warningsHtmlLocation(configs);
            PrintWriter warnWriter = new PrintWriter(_warningsHtmlLocation);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<html>");
            _builder_1.newLine();
            _builder_1.append("<head>");
            _builder_1.newLine();
            _builder_1.append("<link rel=\"stylesheet\" href=\"./data/");
            _builder_1.append("html-report.css", "");
            _builder_1.append("\"/>");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("<script src=\"http://code.jquery.com/jquery-1.11.3.min.js\"></script>");
            _builder_1.newLine();
            _builder_1.append("<script src=\"./data/");
            _builder_1.append("html-report.js", "");
            _builder_1.append("\"></script>");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("</head>");
            _builder_1.newLine();
            _builder_1.append("<body>");
            _builder_1.newLine();
            _builder_1.append("\t");
            CharSequence _summary_1 = this.summary(configs);
            _builder_1.append((Object)_summary_1, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("<a href=\"./");
            _builder_1.append("errors-and-moderate_warnings.html", "\t");
            _builder_1.append("\">show errors</a>");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            String _htmlTable_2 = this.htmlTable(ReportType.WARNING, allreports);
            _builder_1.append(_htmlTable_2, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("</body>");
            _builder_1.newLine();
            _builder_1.append("</html>");
            _builder_1.newLine();
            String warnContent = _builder_1.toString();
            PrintWriter _append_1 = warnWriter.append(warnContent);
            _append_1.close();
            this.addCssFile(configs);
            this.addJsFile(configs);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String errorsHtmlLocation(IP2RepositoryAnalyserConfiguration configs) {
        StringConcatenation _builder = new StringConcatenation();
        String _reportOutputDir = configs.getReportOutputDir();
        _builder.append(_reportOutputDir, "");
        _builder.append("/");
        _builder.append("errors-and-moderate_warnings.html", "");
        return _builder.toString();
    }

    public String warningsHtmlLocation(IP2RepositoryAnalyserConfiguration configs) {
        StringConcatenation _builder = new StringConcatenation();
        String _reportOutputDir = configs.getReportOutputDir();
        _builder.append(_reportOutputDir, "");
        _builder.append("/");
        _builder.append("warnings.html", "");
        return _builder.toString();
    }

    public CharSequence summary(IP2RepositoryAnalyserConfiguration conf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<h3>Check results for the repository: ");
        URI _reportRepoURI = conf.getReportRepoURI();
        _builder.append((Object)_reportRepoURI, "");
        _builder.append("</h3>");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String htmlTable(ReportType reportType, Iterable<CheckReport> allreports) {
        Functions.Function1 _function = it -> {
            ReportType _type = it.getType();
            return Objects.equal((Object)_type, (Object)reportType);
        };
        Iterable reports = IterableExtensions.filter(allreports, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getIU();
        Map groupbyIU = IterableExtensions.groupBy((Iterable)reports, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.getCheckerId();
        Iterable _map = IterableExtensions.map(allreports, (Functions.Function1)_function_2);
        Set _set = IterableExtensions.toSet((Iterable)_map);
        List checkerIds = IterableExtensions.sort((Iterable)_set);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<h3 class=\"");
        String _asCssClass = this.asCssClass(reportType);
        _builder.append(_asCssClass, "");
        _builder.append("\">Installation units with ");
        String _asHeaderTitle = this.asHeaderTitle(reportType);
        _builder.append(_asHeaderTitle, "");
        _builder.append("s (");
        int _size = IterableExtensions.size((Iterable)reports);
        _builder.append((Object)_size, "");
        _builder.append(")</h3>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("<table id=\"table_");
        String _asCssClass_1 = this.asCssClass(reportType);
        _builder.append(_asCssClass_1, "");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<thead>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<tr>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<td>Id</td>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<td>Version</td>");
        _builder.newLine();
        for (String checker : checkerIds) {
            _builder.append("\t\t\t");
            _builder.append("<td title=\"");
            _builder.append(checker, "\t\t\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            String _abbreviation = this.abbreviation(checker);
            _builder.append(_abbreviation, "\t\t\t");
            _builder.append("&nbsp;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("<input type=\"checkbox\" name=\"checker\" class=\"");
            String _asCssClass_2 = this.asCssClass(reportType);
            _builder.append(_asCssClass_2, "\t\t\t");
            _builder.append("_toggler\" checker=\"");
            String _abbreviation_1 = this.abbreviation(checker);
            _builder.append(_abbreviation_1, "\t\t\t");
            _builder.append("\" checked=\"true\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("</td>\t");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("</tr>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</thead>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<tbody>");
        _builder.newLine();
        Set _keySet = groupbyIU.keySet();
        Functions.Function1 _function_3 = it -> it.getId();
        List _sortBy = IterableExtensions.sortBy(_keySet, (Functions.Function1)_function_3);
        for (IInstallableUnit iu : _sortBy) {
            _builder.append("\t");
            Functions.Function1 _function_4 = it -> {
                IInstallableUnit _iU = it.getIU();
                return Objects.equal((Object)_iU, (Object)iu);
            };
            Iterable iuReports = IterableExtensions.filter(allreports, (Functions.Function1)_function_4);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<tr class=\"");
            String _id = iu.getId();
            _builder.append(_id, "\t");
            _builder.append("_");
            Version _version = iu.getVersion();
            String _original = _version.getOriginal();
            _builder.append(_original, "\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("<td>");
            String _id_1 = iu.getId();
            _builder.append(_id_1, "\t\t");
            _builder.append("</td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("<td>");
            Version _version_1 = iu.getVersion();
            String _original_1 = _version_1.getOriginal();
            _builder.append(_original_1, "\t\t");
            _builder.append("</td>");
            _builder.newLineIfNotEmpty();
            for (String checker_1 : checkerIds) {
                _builder.append("\t");
                _builder.append("\t");
                Functions.Function1 _function_5 = it -> {
                    String _checkerId = it.getCheckerId();
                    return Objects.equal((Object)_checkerId, (Object)checker_1);
                };
                Iterable _filter = IterableExtensions.filter((Iterable)iuReports, (Functions.Function1)_function_5);
                CheckReport report = (CheckReport)IterableExtensions.head((Iterable)_filter);
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("<td title=\"");
                String _asDescription = this.asDescription(report);
                _builder.append(_asDescription, "\t\t");
                _builder.append("\" class=\"");
                String _asCssClass_3 = this.asCssClass(report);
                _builder.append(_asCssClass_3, "\t\t");
                _builder.append("\" data-result=\"");
                String _asCssClass_4 = this.asCssClass(reportType);
                _builder.append(_asCssClass_4, "\t\t");
                _builder.append("_");
                String _asCssClass_5 = this.asCssClass(report);
                _builder.append(_asCssClass_5, "\t\t");
                _builder.append("_");
                String _abbreviation_2 = this.abbreviation(checker_1);
                _builder.append(_abbreviation_2, "\t\t");
                _builder.append("\" data-checker=\"");
                String _abbreviation_3 = this.abbreviation(checker_1);
                _builder.append(_abbreviation_3, "\t\t");
                _builder.append("\">");
                String _asStatus = this.asStatus(report);
                _builder.append(_asStatus, "\t\t");
                _builder.append("</td>\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("</tbody>");
        _builder.newLine();
        _builder.append("</table>");
        _builder.newLine();
        String html = _builder.toString();
        return html;
    }

    public void addJsFile(IP2RepositoryAnalyserConfiguration configs) {
        try {
            ReportType[] types;
            StringConcatenation _builder = new StringConcatenation();
            String _dataOutputDir = configs.getDataOutputDir();
            _builder.append(_dataOutputDir, "");
            _builder.append("/");
            _builder.append("html-report.js", "");
            PrintWriter writer = new PrintWriter(_builder.toString());
            ReportType[] reportTypeArray = types = ReportType.values();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ReportType type = reportTypeArray[n2];
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("$(document).ready(function() {");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("$(\".");
                String _asCssClass = this.asCssClass(type);
                _builder_1.append(_asCssClass, "\t");
                _builder_1.append("_toggler\").click(function(e) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t\t");
                _builder_1.append("var targets = $('*[data-result=\"");
                String _asCssClass_1 = this.asCssClass(type);
                _builder_1.append(_asCssClass_1, "\t\t");
                _builder_1.append("_");
                String _asCssClass_2 = this.asCssClass(type);
                _builder_1.append(_asCssClass_2, "\t\t");
                _builder_1.append("_' + $(this).attr('checker')+'\"]');");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t\t");
                _builder_1.append("var state = $(this).attr('checked')");
                _builder_1.newLine();
                _builder_1.append("\t\t");
                _builder_1.append("targets.each(function() {");
                _builder_1.newLine();
                _builder_1.append("\t\t\t");
                _builder_1.append("var tr = $(this).parent();");
                _builder_1.newLine();
                _builder_1.append("\t\t\t");
                _builder_1.append("tr.toggle(state)");
                _builder_1.newLine();
                _builder_1.append("\t\t");
                _builder_1.append("});");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("});");
                _builder_1.newLine();
                _builder_1.append("});");
                _builder_1.newLine();
                writer.append((CharSequence)_builder_1);
                ++n2;
            }
            writer.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void addCssFile(IP2RepositoryAnalyserConfiguration configs) {
        try {
            ReportType[] _values;
            StringConcatenation _builder = new StringConcatenation();
            String _dataOutputDir = configs.getDataOutputDir();
            _builder.append(_dataOutputDir, "");
            _builder.append("/");
            _builder.append("html-report.css", "");
            PrintWriter writer = new PrintWriter(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("table {");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("min-width: 79%;");
            _builder_1.newLine();
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append("thead {");
            _builder_1.newLine();
            _builder_1.append("    ");
            _builder_1.append("padding: 2px;");
            _builder_1.newLine();
            _builder_1.append("    ");
            _builder_1.append("background-color: #E8E8E8;");
            _builder_1.newLine();
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append("td {");
            _builder_1.newLine();
            _builder_1.append("    ");
            _builder_1.append("padding: 2px;");
            _builder_1.newLine();
            _builder_1.append("}");
            _builder_1.newLine();
            writer.append((CharSequence)_builder_1);
            ReportType[] reportTypeArray = _values = ReportType.values();
            int n = _values.length;
            int n2 = 0;
            while (n2 < n) {
                ReportType type = reportTypeArray[n2];
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(".");
                String _asCssClass = this.asCssClass(type);
                _builder_2.append(_asCssClass, "");
                _builder_2.append(" {");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                _builder_2.append("text-align: center;");
                _builder_2.newLine();
                _builder_2.append("\t");
                _builder_2.append("background-color: #");
                String _asBgColor = this.asBgColor(type);
                _builder_2.append(_asBgColor, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("}");
                _builder_2.newLine();
                writer.append((CharSequence)_builder_2);
                ++n2;
            }
            writer.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String asBgColor(ReportType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case NOT_IN_TRAIN: {
                    _switchResult = "FFCCCC";
                    break;
                }
                case BAD_GUY: {
                    _switchResult = "FFCC66";
                    break;
                }
                case WARNING: {
                    _switchResult = "FFFFCC";
                    break;
                }
                case INFO: {
                    _switchResult = "CCFFCC";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String asCssClass(CheckReport report) {
        String _xblockexpression = null;
        boolean _equals = Objects.equal((Object)report, null);
        if (_equals) {
            return "skipped_check";
        }
        ReportType _type = report.getType();
        _xblockexpression = this.asCssClass(_type);
        return _xblockexpression;
    }

    public String asCssClass(ReportType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case NOT_IN_TRAIN: {
                    _switchResult = "error_result";
                    break;
                }
                case BAD_GUY: {
                    _switchResult = "moderate_warning_result";
                    break;
                }
                case WARNING: {
                    _switchResult = "warning_result";
                    break;
                }
                case INFO: {
                    _switchResult = "info_result";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String asHeaderTitle(ReportType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case NOT_IN_TRAIN: {
                    _switchResult = "Error";
                    break;
                }
                case BAD_GUY: {
                    _switchResult = "Moderate Warning";
                    break;
                }
                case WARNING: {
                    _switchResult = "Warning";
                    break;
                }
                case INFO: {
                    _switchResult = "Info";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String abbreviation(String string) {
        int _length;
        boolean _lessThan;
        String simpleName = string;
        int dotIndex = string.lastIndexOf(".");
        boolean _and = false;
        _and = dotIndex < 0 ? false : (_lessThan = dotIndex < (_length = string.length()));
        if (_and) {
            String _substring;
            simpleName = _substring = string.substring(dotIndex + 1);
        }
        return simpleName.replaceAll("([A-Z]+)((?![A-Z])\\w)+", "$1");
    }

    public String asDescription(CheckReport report) {
        boolean _not;
        boolean _equals = Objects.equal((Object)report, null);
        if (_equals) {
            return "any reports";
        }
        String _xifexpression = null;
        String _checkResult = report.getCheckResult();
        boolean _equals_1 = Objects.equal((Object)_checkResult, null);
        _xifexpression = _equals_1 ? "null" : report.getCheckResult();
        String result = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(result, "");
        String _xifexpression_1 = null;
        String _additionalData = report.getAdditionalData();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_additionalData);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _additionalData_1 = report.getAdditionalData();
            _xifexpression_1 = " - " + _additionalData_1;
        }
        _builder.append(_xifexpression_1, "");
        return _builder.toString();
    }

    public String asStatus(CheckReport report) {
        String _xblockexpression = null;
        boolean _equals = Objects.equal((Object)report, null);
        if (_equals) {
            return "&nbsp;";
        }
        String _switchResult = null;
        ReportType _type = report.getType();
        if (_type != null) {
            switch (_type) {
                case NOT_IN_TRAIN: {
                    _switchResult = "--";
                    break;
                }
                case BAD_GUY: {
                    _switchResult = "-";
                    break;
                }
                case WARNING: {
                    _switchResult = "+";
                    break;
                }
                case INFO: {
                    _switchResult = "++";
                    break;
                }
            }
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }
}

