/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.reports;

import com.google.common.base.Objects;
import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.cbi.p2repo.analyzers.common.CheckReport;
import org.eclipse.cbi.p2repo.analyzers.common.ReportType;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.CheckReportsManager;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.ICheckReporter;
import org.eclipse.cbi.p2repo.analyzers.common.reporter.IP2RepositoryAnalyserConfiguration;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JunitXmlReport
implements ICheckReporter {
    public void createReport(CheckReportsManager manager, IP2RepositoryAnalyserConfiguration configs) {
        try {
            String _reportOutputDir = configs.getReportOutputDir();
            File dataDir = new File(_reportOutputDir, "data");
            dataDir.mkdirs();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)dataDir, "");
            _builder.append("/junit-report.xml");
            PrintWriter writer = new PrintWriter(_builder.toString());
            ConcurrentLinkedQueue _reports = manager.getReports();
            Functions.Function1 _function = it -> it.getCheckerId();
            Map groupedByCheck = IterableExtensions.groupBy((Iterable)_reports, (Functions.Function1)_function);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            _builder_1.newLine();
            _builder_1.append("<testrun name=\"Simrel report\" project=\"org.eclipse.cbi.p2repo.analyzers-bundle\" tests=\"");
            ConcurrentLinkedQueue _reports_1 = manager.getReports();
            int _size = _reports_1.size();
            _builder_1.append((Object)_size, "");
            _builder_1.append("\" started=\"");
            ConcurrentLinkedQueue _reports_2 = manager.getReports();
            int _size_1 = _reports_2.size();
            _builder_1.append((Object)_size_1, "");
            _builder_1.append("\" failures=\"0\" errors=\"0\" ignored=\"0\">");
            _builder_1.newLineIfNotEmpty();
            Set _keySet = groupedByCheck.keySet();
            for (String check : _keySet) {
                _builder_1.append("\t");
                List _get = (List)groupedByCheck.get(check);
                Functions.Function1 _function_1 = it -> it.getIU();
                Map checkedIUsById = IterableExtensions.groupBy((Iterable)_get, (Functions.Function1)_function_1);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("<testsuite name=\"");
                String[] _split = check.split("\\.");
                String _last = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
                _builder_1.append(_last, "\t");
                _builder_1.append("\" time=\"");
                int _size_2 = checkedIUsById.size();
                String _timeFormat = this.toTimeFormat(_size_2);
                _builder_1.append(_timeFormat, "\t");
                _builder_1.append("\">");
                _builder_1.newLineIfNotEmpty();
                Set _keySet_1 = checkedIUsById.keySet();
                Functions.Function1 _function_2 = it -> it.getId();
                List _sortBy = IterableExtensions.sortBy(_keySet_1, (Functions.Function1)_function_2);
                for (IInstallableUnit iu : _sortBy) {
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    List reportsForIU = (List)checkedIUsById.get(iu);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("<testcase name=\"check_");
                    String _id = iu.getId();
                    _builder_1.append(_id, "\t\t\t");
                    _builder_1.append("\" classname=\"");
                    _builder_1.append(check, "\t\t\t");
                    _builder_1.append("\" time=\"");
                    int _size_3 = reportsForIU.size();
                    String _timeFormat_1 = this.toTimeFormat(_size_3);
                    _builder_1.append(_timeFormat_1, "\t\t\t");
                    _builder_1.append("\">");
                    _builder_1.newLineIfNotEmpty();
                    for (CheckReport report : reportsForIU) {
                        boolean _notEquals;
                        _builder_1.append("\t");
                        _builder_1.append("\t");
                        _builder_1.append("<");
                        ReportType _type = report.getType();
                        String _asTag = this.asTag(_type);
                        _builder_1.append(_asTag, "\t\t");
                        _builder_1.append(">");
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("\t");
                        _builder_1.append("\t");
                        String _versionedId = report.getVersionedId();
                        _builder_1.append(_versionedId, "\t\t");
                        _builder_1.newLineIfNotEmpty();
                        String _checkResult = report.getCheckResult();
                        boolean bl = _notEquals = !Objects.equal((Object)_checkResult, null);
                        if (_notEquals) {
                            boolean _notEquals_1;
                            _builder_1.append("\t");
                            _builder_1.append("\t");
                            Escaper _xmlAttributeEscaper = XmlEscapers.xmlAttributeEscaper();
                            String _checkResult_1 = report.getCheckResult();
                            String _escape = _xmlAttributeEscaper.escape(_checkResult_1);
                            _builder_1.append(_escape, "\t\t");
                            String _additionalData = report.getAdditionalData();
                            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_additionalData, null);
                            if (_notEquals_1) {
                                _builder_1.append(" - ");
                                Escaper _xmlAttributeEscaper_1 = XmlEscapers.xmlAttributeEscaper();
                                String _additionalData_1 = report.getAdditionalData();
                                String _escape_1 = _xmlAttributeEscaper_1.escape(_additionalData_1);
                                _builder_1.append(_escape_1, "\t\t");
                            }
                            _builder_1.newLineIfNotEmpty();
                        }
                        _builder_1.append("\t");
                        _builder_1.append("\t");
                        _builder_1.append("</");
                        ReportType _type_1 = report.getType();
                        String _asTag_1 = this.asTag(_type_1);
                        _builder_1.append(_asTag_1, "\t\t");
                        _builder_1.append(">");
                        _builder_1.newLineIfNotEmpty();
                    }
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("</testcase>");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                _builder_1.append("</testsuite>");
                _builder_1.newLine();
            }
            _builder_1.append("</testrun>");
            _builder_1.newLine();
            String xmlContent = _builder_1.toString();
            writer.append(xmlContent);
            writer.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String toTimeFormat(Integer testsCount) {
        if (testsCount <= 0) {
            return "0.000";
        }
        DecimalFormatSymbols _decimalFormatSymbols = new DecimalFormatSymbols();
        Procedures.Procedure1 _function = it -> it.setDecimalSeparator('.');
        DecimalFormatSymbols decimalFormatSymbol = (DecimalFormatSymbols)ObjectExtensions.operator_doubleArrow((Object)_decimalFormatSymbols, (Procedures.Procedure1)_function);
        DecimalFormat customFormat = new DecimalFormat("0.000", decimalFormatSymbol);
        return customFormat.format(0.001 * (double)testsCount.intValue());
    }

    public String asTag(ReportType type) {
        boolean _equals = Objects.equal((Object)type, (Object)ReportType.NOT_IN_TRAIN);
        if (_equals) {
            return "failure";
        }
        return "system-out";
    }
}

